/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.javaagent;

import java.io.FilePermission;
import java.lang.reflect.Method;
import java.net.NetPermission;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.spi.FileSystemProvider;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Collection;
import net.bytebuddy.asm.Advice;
import org.opensearch.javaagent.StackCallerProtectionDomainChainExtractor;
import org.opensearch.javaagent.bootstrap.AgentPolicy;

public class FileInterceptor {
    @Advice.OnMethodEnter
    public static void intercept(@Advice.AllArguments Object[] args, @Advice.Origin Method method) throws Exception {
        boolean isDelete;
        Object object;
        Policy policy = AgentPolicy.getPolicy();
        if (policy == null) {
            return;
        }
        FileSystemProvider provider = null;
        String filePath = null;
        if (args.length > 0 && (object = args[0]) instanceof String) {
            String pathStr = (String)object;
            filePath = Paths.get(pathStr, new String[0]).toAbsolutePath().toString();
        } else if (args.length > 0 && (object = args[0]) instanceof Path) {
            Path path = (Path)object;
            filePath = path.toAbsolutePath().toString();
            provider = path.getFileSystem().provider();
        }
        if (filePath == null) {
            return;
        }
        if (provider != null && AgentPolicy.isTrustedFileSystem((String)provider.getScheme())) {
            return;
        }
        StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        Collection<ProtectionDomain> callers = walker.walk(StackCallerProtectionDomainChainExtractor.INSTANCE);
        String name = method.getName();
        boolean isMutating = name.equals("move") || name.equals("write") || name.startsWith("create");
        boolean bl = isDelete = !isMutating ? name.startsWith("delete") : false;
        if (isDelete && walker.getCallerClass().getName().equalsIgnoreCase("sun.nio.ch.PipeImpl$Initializer$LoopbackConnector")) {
            NetPermission permission = new NetPermission("accessUnixDomainSocket");
            for (ProtectionDomain protectionDomain : callers) {
                if (policy.implies(protectionDomain, permission)) continue;
                throw new SecurityException("Denied access to: " + filePath + ", domain " + String.valueOf(protectionDomain));
            }
        } else {
            String targetFilePath = null;
            if (!isMutating && !isDelete) {
                if (name.equals("newByteChannel") || name.equals("open")) {
                    Object object2;
                    if (args.length > 1 && (object2 = args[1]) instanceof OpenOption[]) {
                        OpenOption[] opts;
                        for (OpenOption opt : opts = (OpenOption[])object2) {
                            if (opt == StandardOpenOption.READ) continue;
                            isMutating = true;
                            break;
                        }
                    }
                } else if (name.equals("copy")) {
                    Object object3;
                    if (args.length > 1 && (object3 = args[1]) instanceof String) {
                        String pathStr = (String)object3;
                        targetFilePath = Paths.get(pathStr, new String[0]).toAbsolutePath().toString();
                    } else if (args.length > 1 && (object3 = args[1]) instanceof Path) {
                        Path path = (Path)object3;
                        targetFilePath = path.toAbsolutePath().toString();
                    }
                }
            }
            for (ProtectionDomain protectionDomain : callers) {
                if (method.getName().equals("open")) {
                    if (isMutating && !policy.implies(protectionDomain, new FilePermission(filePath, "read,write"))) {
                        throw new SecurityException("Denied OPEN (read/write) access to file: " + filePath + ", domain: " + String.valueOf(protectionDomain));
                    }
                    if (!policy.implies(protectionDomain, new FilePermission(filePath, "read"))) {
                        throw new SecurityException("Denied OPEN (read) access to file: " + filePath + ", domain: " + String.valueOf(protectionDomain));
                    }
                }
                if (method.getName().equals("copy")) {
                    if (!policy.implies(protectionDomain, new FilePermission(filePath, "read"))) {
                        throw new SecurityException("Denied COPY (read) access to file: " + filePath + ", domain: " + String.valueOf(protectionDomain));
                    }
                    if (targetFilePath != null && !policy.implies(protectionDomain, new FilePermission(targetFilePath, "write"))) {
                        throw new SecurityException("Denied COPY (write) access to file: " + targetFilePath + ", domain: " + String.valueOf(protectionDomain));
                    }
                }
                if (isMutating && !policy.implies(protectionDomain, new FilePermission(filePath, "write"))) {
                    throw new SecurityException("Denied WRITE access to file: " + filePath + ", domain: " + String.valueOf(protectionDomain));
                }
                if (!isDelete || policy.implies(protectionDomain, new FilePermission(filePath, "delete"))) continue;
                throw new SecurityException("Denied DELETE access to file: " + filePath + ", domain: " + String.valueOf(protectionDomain));
            }
        }
    }
}

