/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.opensearch.search.internal.SearchContext;

public class DelayedShardAggregationBuilder
extends AbstractAggregationBuilder<DelayedShardAggregationBuilder> {
    public static final String NAME = "shard_delay";
    private TimeValue delay;
    static final ConstructingObjectParser<DelayedShardAggregationBuilder, String> PARSER = new ConstructingObjectParser("shard_delay", false, (args, name) -> new DelayedShardAggregationBuilder((String)name, TimeValue.parseTimeValue((String)((String)args[0]), (String)"value")));

    public DelayedShardAggregationBuilder(String name, TimeValue delay) {
        super(name);
        this.delay = delay;
    }

    public DelayedShardAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.delay = in.readTimeValue();
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new DelayedShardAggregationBuilder(this.name, this.delay);
    }

    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.ONE;
    }

    public String getType() {
        return NAME;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeTimeValue(this.delay);
    }

    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("value", this.delay.toString());
        builder.endObject();
        return builder;
    }

    protected AggregatorFactory doBuild(QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
        queryShardContext.nowInMillis();
        FilterAggregationBuilder filterAgg = (FilterAggregationBuilder)new FilterAggregationBuilder(this.name, (QueryBuilder)QueryBuilders.matchAllQuery()).subAggregations(subfactoriesBuilder);
        final AggregatorFactory factory = filterAgg.build(queryShardContext, parent);
        return new AggregatorFactory(this.name, queryShardContext, parent, subfactoriesBuilder, this.metadata){

            protected Aggregator createInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
                long start = searchContext.getRelativeTimeInMillis();
                long sleepTime = Math.min(DelayedShardAggregationBuilder.this.delay.getMillis(), 100L);
                while (!searchContext.isCancelled()) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                    if (searchContext.getRelativeTimeInMillis() - start < DelayedShardAggregationBuilder.this.delay.getMillis()) continue;
                }
                return factory.create(searchContext, parent, cardinality);
            }

            protected boolean supportsConcurrentSegmentSearch() {
                return true;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DelayedShardAggregationBuilder that = (DelayedShardAggregationBuilder)((Object)o);
        return Objects.equals(this.delay, that.delay);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delay);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("value", new String[0]));
    }
}

