/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.filterrewrite;

import java.io.IOException;
import java.util.OptionalLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.opensearch.common.Rounding;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.search.aggregations.bucket.filterrewrite.AggregatorBridge;
import org.opensearch.search.aggregations.bucket.filterrewrite.FilterRewriteOptimizationContext;
import org.opensearch.search.aggregations.bucket.filterrewrite.Helper;
import org.opensearch.search.aggregations.bucket.filterrewrite.Ranges;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

public abstract class DateHistogramAggregatorBridge
extends AggregatorBridge {
    int maxRewriteFilters;

    protected boolean canOptimize(ValuesSourceConfig config, Rounding rounding) {
        MappedFieldType fieldType;
        if (!rounding.isUTC()) {
            return false;
        }
        if (config.script() == null && config.missing() == null && (fieldType = config.fieldType()) instanceof DateFieldMapper.DateFieldType && fieldType.isSearchable()) {
            this.fieldType = fieldType;
            return true;
        }
        return false;
    }

    protected void buildRanges(SearchContext context) throws IOException {
        long[] bounds = Helper.getDateHistoAggBounds(context, this.fieldType.name());
        this.maxRewriteFilters = context.maxAggRewriteFilters();
        this.setRanges.accept(this.buildRanges(bounds, this.maxRewriteFilters));
    }

    @Override
    final Ranges tryBuildRangesFromSegment(LeafReaderContext leaf) throws IOException {
        long[] bounds = Helper.getSegmentBounds(leaf, this.fieldType.name());
        return this.buildRanges(bounds, this.maxRewriteFilters);
    }

    private Ranges buildRanges(long[] bounds, int maxRewriteFilters) {
        if ((bounds = this.processHardBounds(bounds)) == null) {
            return null;
        }
        assert (bounds[0] <= bounds[1]) : "Low bound should be less than high bound";
        Rounding rounding = this.getRounding(bounds[0], bounds[1]);
        OptionalLong intervalOpt = Rounding.getInterval(rounding);
        if (intervalOpt.isEmpty()) {
            return null;
        }
        long interval = intervalOpt.getAsLong();
        bounds = this.processAfterKey(bounds, interval);
        return Helper.createRangesFromAgg((DateFieldMapper.DateFieldType)this.fieldType, interval, this.getRoundingPrepared(), bounds[0], bounds[1], maxRewriteFilters);
    }

    protected abstract Rounding getRounding(long var1, long var3);

    protected abstract Rounding.Prepared getRoundingPrepared();

    protected long[] processAfterKey(long[] bounds, long interval) {
        return bounds;
    }

    protected long[] processHardBounds(long[] bounds) {
        return this.processHardBounds(bounds, null);
    }

    protected long[] processHardBounds(long[] bounds, LongBounds hardBounds) {
        if (bounds != null && hardBounds != null) {
            if (hardBounds.getMin() > bounds[0]) {
                bounds[0] = hardBounds.getMin();
            }
            if (hardBounds.getMax() - 1L < bounds[1]) {
                bounds[1] = hardBounds.getMax() - 1L;
            }
            if (bounds[0] > bounds[1]) {
                return null;
            }
        }
        return bounds;
    }

    private DateFieldMapper.DateFieldType getFieldType() {
        assert (this.fieldType instanceof DateFieldMapper.DateFieldType);
        return (DateFieldMapper.DateFieldType)this.fieldType;
    }

    protected int getSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    final FilterRewriteOptimizationContext.OptimizeResult tryOptimize(PointValues values, BiConsumer<Long, Long> incrementDocCount, Ranges ranges, FilterRewriteOptimizationContext.SubAggCollectorParam subAggCollectorParam) throws IOException {
        int size = this.getSize();
        DateFieldMapper.DateFieldType fieldType = this.getFieldType();
        Function<Integer, Long> getBucketOrd = activeIndex -> {
            long rangeStart = LongPoint.decodeDimension((byte[])ranges.lowers[activeIndex], (int)0);
            rangeStart = fieldType.convertNanosToMillis(rangeStart);
            return DateHistogramAggregatorBridge.getBucketOrd(this.bucketOrdProducer().apply(rangeStart));
        };
        return DateHistogramAggregatorBridge.getResult(values, incrementDocCount, ranges, getBucketOrd, size, subAggCollectorParam);
    }

    private static long getBucketOrd(long bucketOrd) {
        if (bucketOrd < 0L) {
            bucketOrd = -1L - bucketOrd;
        }
        return bucketOrd;
    }

    protected abstract Function<Long, Long> bucketOrdProducer();
}

