/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.pollingingest;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.common.Nullable;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IngestionShardPointer;
import org.opensearch.index.Message;
import org.opensearch.index.VersionType;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.engine.IngestionEngine;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.ParsedDocument;
import org.opensearch.index.mapper.SourceToParse;
import org.opensearch.index.mapper.Uid;
import org.opensearch.indices.pollingingest.IngestionErrorStrategy;
import org.opensearch.indices.pollingingest.ShardUpdateMessage;

public class MessageProcessorRunnable
implements Runnable,
Closeable {
    private static final Logger logger = LogManager.getLogger(MessageProcessorRunnable.class);
    private static final String ID = "_id";
    private static final String OP_TYPE = "_op_type";
    private static final String SOURCE = "_source";
    private static final int WAIT_BEFORE_RETRY_DURATION_MS = 5000;
    private final BlockingQueue<ShardUpdateMessage<? extends IngestionShardPointer, ? extends Message>> blockingQueue;
    private final MessageProcessor messageProcessor;
    private final CounterMetric processedCounter = new CounterMetric();
    private final CounterMetric skippedCounter = new CounterMetric();
    @Nullable
    private volatile IngestionShardPointer currentShardPointer;
    private volatile boolean closed = false;
    private volatile IngestionErrorStrategy errorStrategy;

    public MessageProcessorRunnable(BlockingQueue<ShardUpdateMessage<? extends IngestionShardPointer, ? extends Message>> blockingQueue, IngestionEngine engine, IngestionErrorStrategy errorStrategy) {
        this(blockingQueue, new MessageProcessor(engine), errorStrategy);
    }

    MessageProcessorRunnable(BlockingQueue<ShardUpdateMessage<? extends IngestionShardPointer, ? extends Message>> blockingQueue, MessageProcessor messageProcessor, IngestionErrorStrategy errorStrategy) {
        this.blockingQueue = Objects.requireNonNull(blockingQueue);
        this.messageProcessor = messageProcessor;
        this.errorStrategy = errorStrategy;
    }

    private static BytesReference convertToBytes(Object object) throws IOException {
        assert (object instanceof Map);
        return BytesReference.bytes((XContentBuilder)XContentFactory.jsonBuilder().map((Map)object));
    }

    BlockingQueue<ShardUpdateMessage<? extends IngestionShardPointer, ? extends Message>> getBlockingQueue() {
        return this.blockingQueue;
    }

    @Override
    public void run() {
        ShardUpdateMessage<? extends IngestionShardPointer, ? extends Message> shardUpdateMessage = null;
        while (!Thread.currentThread().isInterrupted() && !this.closed) {
            try {
                if (shardUpdateMessage == null) {
                    shardUpdateMessage = this.blockingQueue.poll(1000L, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e) {
                logger.debug("MessageProcessorRunnable poll interruptedException", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            if (shardUpdateMessage == null) continue;
            try {
                this.processedCounter.inc();
                this.currentShardPointer = shardUpdateMessage.pointer();
                this.messageProcessor.process(shardUpdateMessage, this.skippedCounter);
                shardUpdateMessage = null;
            }
            catch (VersionConflictEngineException e) {
                logger.debug("Dropping message due to version conflict. ShardPointer: " + shardUpdateMessage.pointer().asString(), (Throwable)((Object)e));
                shardUpdateMessage = null;
            }
            catch (Exception e) {
                this.errorStrategy.handleError(e, IngestionErrorStrategy.ErrorStage.PROCESSING);
                if (this.errorStrategy.shouldIgnoreError(e, IngestionErrorStrategy.ErrorStage.PROCESSING)) {
                    shardUpdateMessage = null;
                    continue;
                }
                this.waitBeforeRetry();
            }
        }
    }

    private void waitBeforeRetry() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            logger.debug("MessageProcessor thread interrupted while waiting for retry", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public CounterMetric getProcessedCounter() {
        return this.processedCounter;
    }

    public CounterMetric getSkippedCounter() {
        return this.skippedCounter;
    }

    public IngestionErrorStrategy getErrorStrategy() {
        return this.errorStrategy;
    }

    public void setErrorStrategy(IngestionErrorStrategy errorStrategy) {
        this.errorStrategy = errorStrategy;
    }

    @Nullable
    public IngestionShardPointer getCurrentShardPointer() {
        return this.currentShardPointer;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    static class MessageProcessor {
        private final IngestionEngine engine;
        private final String index;

        MessageProcessor(IngestionEngine engine) {
            this(engine, engine.config().getIndexSettings().getIndex().getName());
        }

        MessageProcessor(IngestionEngine engine, String index) {
            this.engine = engine;
            this.index = index;
        }

        protected void process(ShardUpdateMessage shardUpdateMessage, CounterMetric skippedCounter) {
            try {
                Engine.Operation operation = this.getOperation(shardUpdateMessage, skippedCounter);
                switch (operation.operationType()) {
                    case INDEX: {
                        this.engine.indexInternal((Engine.Index)operation);
                        break;
                    }
                    case DELETE: {
                        this.engine.deleteInternal((Engine.Delete)operation);
                        break;
                    }
                    case NO_OP: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid operation: " + String.valueOf(operation));
                    }
                }
            }
            catch (IOException e) {
                logger.error("Failed to process operation from message {} at pointer {}: {}", shardUpdateMessage.originalMessage(), (Object)shardUpdateMessage.pointer().asString(), (Object)e);
                throw new RuntimeException(e);
            }
        }

        protected Engine.Operation getOperation(ShardUpdateMessage shardUpdateMessage, CounterMetric skippedCounter) throws IOException {
            Engine.Operation operation;
            Map<String, Object> payloadMap = shardUpdateMessage.parsedPayloadMap();
            Object pointer = shardUpdateMessage.pointer();
            if (payloadMap.containsKey(MessageProcessorRunnable.OP_TYPE) && !(payloadMap.get(MessageProcessorRunnable.OP_TYPE) instanceof String)) {
                skippedCounter.inc();
                logger.error("_op_type field is of type {} but not string, skipping the message", payloadMap.get(MessageProcessorRunnable.OP_TYPE).getClass());
                return null;
            }
            if (!payloadMap.containsKey(MessageProcessorRunnable.ID)) {
                logger.error("ID field is missing, skipping the message");
                return null;
            }
            String id = (String)payloadMap.get(MessageProcessorRunnable.ID);
            String opTypeString = (String)payloadMap.getOrDefault(MessageProcessorRunnable.OP_TYPE, "index");
            DocWriteRequest.OpType opType = DocWriteRequest.OpType.fromString(opTypeString);
            long documentVersion = -3L;
            VersionType documentVersionType = VersionType.INTERNAL;
            if (payloadMap.containsKey("_version")) {
                documentVersion = Long.parseLong((String)payloadMap.get("_version"));
                documentVersionType = VersionType.EXTERNAL;
            }
            switch (opType) {
                case INDEX: {
                    if (!payloadMap.containsKey(MessageProcessorRunnable.SOURCE)) {
                        skippedCounter.inc();
                        logger.error("missing _source field, skipping the message");
                        return null;
                    }
                    if (!(payloadMap.get(MessageProcessorRunnable.SOURCE) instanceof Map)) {
                        skippedCounter.inc();
                        logger.error("_source field does not contain a map, skipping the message");
                        return null;
                    }
                    BytesReference source = MessageProcessorRunnable.convertToBytes(payloadMap.get(MessageProcessorRunnable.SOURCE));
                    SourceToParse sourceToParse = new SourceToParse(this.index, id, source, MediaTypeRegistry.xContentType((BytesReference)source), null);
                    ParsedDocument doc = this.engine.getDocumentMapperForType().getDocumentMapper().parse(sourceToParse);
                    ParseContext.Document document = doc.rootDoc();
                    document.add((IndexableField)pointer.asPointField("_offset"));
                    document.add((IndexableField)new StoredField("_offset", pointer.asString()));
                    operation = new Engine.Index(new Term(MessageProcessorRunnable.ID, Uid.encodeId(id)), doc, 0L, 1L, documentVersion, documentVersionType, Engine.Operation.Origin.PRIMARY, System.nanoTime(), shardUpdateMessage.autoGeneratedIdTimestamp(), false, -2L, 0L);
                    break;
                }
                case DELETE: {
                    if (shardUpdateMessage.autoGeneratedIdTimestamp() != -1L) {
                        logger.info("Delete operation without ID received, and will be dropped.");
                        operation = new Engine.NoOp(0L, 1L, Engine.Operation.Origin.PRIMARY, System.nanoTime(), "Delete operation is missing ID");
                        break;
                    }
                    operation = new Engine.Delete(id, new Term(MessageProcessorRunnable.ID, Uid.encodeId(id)), 0L, 1L, documentVersion, documentVersionType, Engine.Operation.Origin.PRIMARY, System.nanoTime(), -2L, 0L);
                    break;
                }
                default: {
                    logger.error("Unsupported operation type {}", (Object)opType);
                    return null;
                }
            }
            return operation;
        }
    }
}

