/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.pollingingest;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.common.Nullable;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.index.IngestionShardConsumer;
import org.opensearch.index.IngestionShardPointer;
import org.opensearch.index.Message;
import org.opensearch.index.engine.IngestionEngine;
import org.opensearch.indices.pollingingest.IngestionErrorStrategy;
import org.opensearch.indices.pollingingest.PartitionedBlockingQueueContainer;
import org.opensearch.indices.pollingingest.PollingIngestStats;
import org.opensearch.indices.pollingingest.StreamPoller;

public class DefaultStreamPoller
implements StreamPoller {
    private static final Logger logger = LogManager.getLogger(DefaultStreamPoller.class);
    public static final long MAX_POLL_SIZE = 1000L;
    public static final int POLL_TIMEOUT = 1000;
    private volatile StreamPoller.State state = StreamPoller.State.NONE;
    private volatile boolean started;
    private volatile boolean closed;
    private volatile boolean paused;
    private volatile IngestionErrorStrategy errorStrategy;
    private IngestionShardConsumer consumer;
    private ExecutorService consumerThread;
    private IngestionShardPointer initialBatchStartPointer;
    private boolean includeBatchStartPointer = false;
    private StreamPoller.ResetState resetState;
    private final String resetValue;
    private Set<IngestionShardPointer> persistedPointers;
    private final CounterMetric totalPolledCount = new CounterMetric();
    @Nullable
    private IngestionShardPointer maxPersistedPointer;
    private PartitionedBlockingQueueContainer blockingQueueContainer;

    public DefaultStreamPoller(IngestionShardPointer startPointer, Set<IngestionShardPointer> persistedPointers, IngestionShardConsumer consumer, IngestionEngine ingestionEngine, StreamPoller.ResetState resetState, String resetValue, IngestionErrorStrategy errorStrategy, StreamPoller.State initialState, long maxPollSize, int pollTimeout, int numProcessorThreads) {
        this(startPointer, persistedPointers, consumer, new PartitionedBlockingQueueContainer(numProcessorThreads, consumer.getShardId(), ingestionEngine, errorStrategy), resetState, resetValue, errorStrategy, initialState);
    }

    DefaultStreamPoller(IngestionShardPointer startPointer, Set<IngestionShardPointer> persistedPointers, IngestionShardConsumer consumer, PartitionedBlockingQueueContainer blockingQueueContainer, StreamPoller.ResetState resetState, String resetValue, IngestionErrorStrategy errorStrategy, StreamPoller.State initialState) {
        this.consumer = Objects.requireNonNull(consumer);
        this.resetState = resetState;
        this.resetValue = resetValue;
        this.initialBatchStartPointer = startPointer;
        this.state = initialState;
        this.persistedPointers = persistedPointers;
        if (!this.persistedPointers.isEmpty()) {
            this.maxPersistedPointer = (IngestionShardPointer)this.persistedPointers.stream().max(Comparable::compareTo).get();
        }
        this.blockingQueueContainer = blockingQueueContainer;
        this.consumerThread = Executors.newSingleThreadExecutor(r -> new Thread(r, String.format(Locale.ROOT, "stream-poller-consumer-%d-%d", consumer.getShardId(), System.currentTimeMillis())));
        this.errorStrategy = errorStrategy;
    }

    @Override
    public void start() {
        if (this.closed) {
            throw new RuntimeException("poller is closed!");
        }
        if (this.started) {
            throw new RuntimeException("poller is already running");
        }
        this.started = true;
        this.includeBatchStartPointer = true;
        this.consumerThread.submit(this::startPoll);
        this.blockingQueueContainer.startProcessorThreads();
    }

    protected void startPoll() {
        if (!this.started) {
            throw new IllegalStateException("poller is not started!");
        }
        if (this.closed) {
            throw new IllegalStateException("poller is closed!");
        }
        logger.info("Starting poller for shard {}", (Object)this.consumer.getShardId());
        IngestionShardPointer failedShardPointer = null;
        block10: while (true) {
            try {
                while (true) {
                    List<IngestionShardConsumer.ReadResult<? extends IngestionShardPointer, ? extends Message>> results;
                    if (this.closed) {
                        this.state = StreamPoller.State.CLOSED;
                        break block10;
                    }
                    if (this.resetState != StreamPoller.ResetState.NONE) {
                        switch (this.resetState) {
                            case EARLIEST: {
                                this.initialBatchStartPointer = this.consumer.earliestPointer();
                                logger.info("Resetting offset by seeking to earliest offset {}", (Object)this.initialBatchStartPointer.asString());
                                break;
                            }
                            case LATEST: {
                                this.initialBatchStartPointer = this.consumer.latestPointer();
                                logger.info("Resetting offset by seeking to latest offset {}", (Object)this.initialBatchStartPointer.asString());
                                break;
                            }
                            case REWIND_BY_OFFSET: {
                                this.initialBatchStartPointer = this.consumer.pointerFromOffset(this.resetValue);
                                logger.info("Resetting offset by seeking to offset {}", (Object)this.initialBatchStartPointer.asString());
                                break;
                            }
                            case REWIND_BY_TIMESTAMP: {
                                this.initialBatchStartPointer = this.consumer.pointerFromTimestampMillis(Long.parseLong(this.resetValue));
                                logger.info("Resetting offset by seeking to timestamp {}, corresponding offset {}", (Object)this.resetValue, (Object)this.initialBatchStartPointer.asString());
                            }
                        }
                        this.resetState = StreamPoller.ResetState.NONE;
                    }
                    if (this.paused) {
                        this.state = StreamPoller.State.PAUSED;
                        try {
                            Thread.sleep(100L);
                            continue block10;
                        }
                        catch (Throwable e) {
                            logger.error("Error in pausing the poller of shard {}: {}", (Object)this.consumer.getShardId(), (Object)e);
                            continue;
                        }
                    }
                    this.state = StreamPoller.State.POLLING;
                    if (this.includeBatchStartPointer) {
                        results = this.consumer.readNext(this.initialBatchStartPointer, true, 1000L, 1000);
                        this.includeBatchStartPointer = false;
                    } else if (failedShardPointer != null) {
                        results = this.consumer.readNext(failedShardPointer, true, 1000L, 1000);
                        failedShardPointer = null;
                    } else {
                        results = this.consumer.readNext(1000L, 1000);
                    }
                    if (results.isEmpty()) continue;
                    this.state = StreamPoller.State.PROCESSING;
                    failedShardPointer = this.processRecords(results);
                }
            }
            catch (Exception e) {
                logger.error("Pausing ingestion. Fatal error occurred in polling the shard {}: {}", (Object)this.consumer.getShardId(), (Object)e);
                this.pause();
                continue;
            }
            break;
        }
    }

    private IngestionShardPointer processRecords(List<IngestionShardConsumer.ReadResult<? extends IngestionShardPointer, ? extends Message>> results) {
        IngestionShardPointer failedShardPointer = null;
        for (IngestionShardConsumer.ReadResult<? extends IngestionShardPointer, ? extends Message> result : results) {
            try {
                if (this.isProcessed(result.getPointer())) {
                    logger.debug("Skipping message with pointer {} as it is already processed", new Supplier[]{() -> ((IngestionShardPointer)result.getPointer()).asString()});
                    continue;
                }
                this.totalPolledCount.inc();
                this.blockingQueueContainer.add(result);
                logger.debug("Put message {} with pointer {} to the blocking queue", (Object)String.valueOf(result.getMessage().getPayload()), (Object)result.getPointer().asString());
            }
            catch (Exception e) {
                logger.error("Error in processing a record. Shard {}, pointer {}: {}", (Object)this.consumer.getShardId(), (Object)result.getPointer().asString(), (Object)e);
                this.errorStrategy.handleError(e, IngestionErrorStrategy.ErrorStage.POLLING);
                if (this.errorStrategy.shouldIgnoreError(e, IngestionErrorStrategy.ErrorStage.POLLING)) continue;
                this.pause();
                failedShardPointer = result.getPointer();
                break;
            }
        }
        return failedShardPointer;
    }

    private boolean isProcessed(IngestionShardPointer pointer) {
        if (this.maxPersistedPointer == null) {
            return false;
        }
        if (pointer.compareTo(this.maxPersistedPointer) > 0) {
            return false;
        }
        return this.persistedPointers.contains(pointer);
    }

    protected IngestionShardPointer getMaxPersistedPointer() {
        return this.maxPersistedPointer;
    }

    @Override
    public void pause() {
        if (this.closed) {
            throw new RuntimeException("consumer is closed!");
        }
        this.paused = true;
    }

    @Override
    public void resume() {
        if (this.closed) {
            throw new RuntimeException("consumer is closed!");
        }
        this.paused = false;
    }

    @Override
    public void close() {
        this.closed = true;
        if (!this.started) {
            logger.info("consumer thread not started");
            return;
        }
        long startTime = System.currentTimeMillis();
        long timeout = 5000L;
        while (this.state != StreamPoller.State.CLOSED) {
            if (System.currentTimeMillis() - startTime > timeout) {
                logger.error("Timeout reached while waiting for shard {} to close", (Object)this.consumer.getShardId());
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (Throwable e) {
                logger.error("Error in closing the poller of shard {}: {}", (Object)this.consumer.getShardId(), (Object)e);
            }
        }
        this.consumerThread.shutdown();
        this.blockingQueueContainer.close();
        logger.info("closed the poller of shard {}", (Object)this.consumer.getShardId());
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public IngestionShardPointer getBatchStartPointer() {
        return this.blockingQueueContainer.getCurrentShardPointers().stream().filter(Objects::nonNull).min(Comparator.naturalOrder()).orElseGet(() -> this.initialBatchStartPointer);
    }

    @Override
    public PollingIngestStats getStats() {
        PollingIngestStats.Builder builder = new PollingIngestStats.Builder();
        builder.setTotalPolledCount(this.totalPolledCount.count());
        builder.setTotalProcessedCount(this.blockingQueueContainer.getTotalProcessedCount());
        builder.setTotalSkippedCount(this.blockingQueueContainer.getTotalSkippedCount());
        return builder.build();
    }

    @Override
    public StreamPoller.State getState() {
        return this.state;
    }

    @Override
    public IngestionErrorStrategy getErrorStrategy() {
        return this.errorStrategy;
    }

    @Override
    public void updateErrorStrategy(IngestionErrorStrategy errorStrategy) {
        this.errorStrategy = errorStrategy;
        this.blockingQueueContainer.updateErrorStrategy(errorStrategy);
    }
}

