/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.opensearch.cluster.AckedClusterStateTaskListener;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateTaskConfig;
import org.opensearch.cluster.ClusterStateTaskExecutor;
import org.opensearch.cluster.ack.ClusterStateUpdateResponse;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.Priority;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.index.Index;
import org.opensearch.index.IndexService;
import org.opensearch.index.compositeindex.CompositeIndexValidator;
import org.opensearch.index.mapper.DocumentMapper;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.cluster.IndicesClusterStateService;

public class MetadataMappingService {
    private static final Logger logger = LogManager.getLogger(MetadataMappingService.class);
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final ClusterManagerTaskThrottler.ThrottlingKey putMappingTaskKey;
    final RefreshTaskExecutor refreshExecutor = new RefreshTaskExecutor();
    final PutMappingExecutor putMappingExecutor = new PutMappingExecutor();

    @Inject
    public MetadataMappingService(ClusterService clusterService, IndicesService indicesService) {
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.putMappingTaskKey = clusterService.registerClusterManagerTask("put-mapping", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterState executeRefresh(ClusterState currentState, List<RefreshTask> allTasks) throws Exception {
        HashMap<String, List> tasksPerIndex = new HashMap<String, List>();
        for (RefreshTask task : allTasks) {
            if (task.index == null) {
                logger.debug("ignoring a mapping task of type [{}] with a null index.", (Object)task);
            }
            tasksPerIndex.computeIfAbsent(task.index, k -> new ArrayList()).add(task);
        }
        boolean dirty = false;
        Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
        for (Map.Entry entry : tasksPerIndex.entrySet()) {
            IndexMetadata indexMetadata = mdBuilder.get((String)entry.getKey());
            if (indexMetadata == null) {
                logger.debug("[{}] ignoring tasks - index meta data doesn't exist", entry.getKey());
                continue;
            }
            Index index = indexMetadata.getIndex();
            List allIndexTasks = (List)entry.getValue();
            boolean hasTaskWithRightUUID = false;
            for (RefreshTask task : allIndexTasks) {
                if (indexMetadata.isSameUUID(task.indexUUID)) {
                    hasTaskWithRightUUID = true;
                    continue;
                }
                logger.debug("{} ignoring task [{}] - index meta data doesn't match task uuid", (Object)index, (Object)task);
            }
            if (!hasTaskWithRightUUID) continue;
            boolean removeIndex = false;
            IndicesClusterStateService.AllocatedIndex<IndexShard> indexService = this.indicesService.indexService(indexMetadata.getIndex());
            if (indexService == null) {
                indexService = this.indicesService.createIndex(indexMetadata, Collections.emptyList(), false);
                removeIndex = true;
                ((IndexService)indexService).mapperService().merge(indexMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
            }
            IndexMetadata.Builder builder = IndexMetadata.builder(indexMetadata);
            try {
                boolean indexDirty = this.refreshIndexMapping((IndexService)indexService, builder);
                if (!indexDirty) continue;
                mdBuilder.put(builder);
                dirty = true;
            }
            finally {
                if (!removeIndex) continue;
                this.indicesService.removeIndex(index, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, "created for mapping processing");
            }
        }
        if (!dirty) {
            return currentState;
        }
        return ClusterState.builder(currentState).metadata(mdBuilder).build();
    }

    private boolean refreshIndexMapping(IndexService indexService, IndexMetadata.Builder builder) {
        boolean dirty = false;
        String index = indexService.index().getName();
        try {
            MapperService mapperService = indexService.mapperService();
            DocumentMapper mapper = mapperService.documentMapper();
            if (mapper != null && !mapper.mappingSource().equals(builder.mapping().source())) {
                dirty = true;
            }
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("[{}] failed to refresh-mapping in cluster state", (Object)index), (Throwable)e);
        }
        return dirty;
    }

    public void refreshMapping(String index, String indexUUID) {
        RefreshTask refreshTask = new RefreshTask(index, indexUUID);
        this.clusterService.submitStateUpdateTask("refresh-mapping [" + index + "]", refreshTask, ClusterStateTaskConfig.build(Priority.HIGH), this.refreshExecutor, (source, e) -> logger.warn(() -> new ParameterizedMessage("failure during [{}]", (Object)source), (Throwable)e));
    }

    public void putMapping(final PutMappingClusterStateUpdateRequest request, final ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("put-mapping " + Strings.arrayToCommaDelimitedString((Object[])request.indices()), request, ClusterStateTaskConfig.build(Priority.HIGH, request.clusterManagerNodeTimeout()), this.putMappingExecutor, new AckedClusterStateTaskListener(){

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return true;
            }

            @Override
            public void onAllNodesAcked(@Nullable Exception e) {
                listener.onResponse((Object)new ClusterStateUpdateResponse(e == null));
            }

            @Override
            public void onAckTimeout() {
                listener.onResponse((Object)new ClusterStateUpdateResponse(false));
            }

            @Override
            public TimeValue ackTimeout() {
                return request.ackTimeout();
            }
        });
    }

    class RefreshTaskExecutor
    implements ClusterStateTaskExecutor<RefreshTask> {
        RefreshTaskExecutor() {
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<RefreshTask> execute(ClusterState currentState, List<RefreshTask> tasks) throws Exception {
            ClusterState newClusterState = MetadataMappingService.this.executeRefresh(currentState, tasks);
            return ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(newClusterState);
        }
    }

    class PutMappingExecutor
    implements ClusterStateTaskExecutor<PutMappingClusterStateUpdateRequest> {
        PutMappingExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<PutMappingClusterStateUpdateRequest> execute(ClusterState currentState, List<PutMappingClusterStateUpdateRequest> tasks) throws Exception {
            HashMap<Index, MapperService> indexMapperServices = new HashMap<Index, MapperService>();
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<PutMappingClusterStateUpdateRequest> builder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
            try {
                for (PutMappingClusterStateUpdateRequest request : tasks) {
                    try {
                        for (Index index : request.indices()) {
                            IndexMetadata indexMetadata = currentState.metadata().getIndexSafe(index);
                            if (indexMapperServices.containsKey(indexMetadata.getIndex())) continue;
                            MapperService mapperService = MetadataMappingService.this.indicesService.createIndexMapperService(indexMetadata);
                            indexMapperServices.put(index, mapperService);
                            mapperService.merge(indexMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
                        }
                        currentState = this.applyRequest(currentState, request, indexMapperServices);
                        builder.success(request);
                    }
                    catch (Exception e) {
                        builder.failure(request, e);
                    }
                }
                ClusterStateTaskExecutor.ClusterTasksResult clusterTasksResult = builder.build(currentState);
                return clusterTasksResult;
            }
            finally {
                IOUtils.close(indexMapperServices.values());
            }
        }

        @Override
        public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
            return MetadataMappingService.this.putMappingTaskKey;
        }

        private ClusterState applyRequest(ClusterState currentState, PutMappingClusterStateUpdateRequest request, Map<Index, MapperService> indexMapperServices) throws IOException {
            CompressedXContent mappingUpdateSource = new CompressedXContent(request.source());
            Metadata metadata = currentState.metadata();
            ArrayList<IndexMetadata> updateList = new ArrayList<IndexMetadata>();
            for (Index index : request.indices()) {
                MapperService mapperService = indexMapperServices.get(index);
                IndexMetadata indexMetadata = currentState.getMetadata().getIndexSafe(index);
                updateList.add(indexMetadata);
                DocumentMapper existingMapper = mapperService.documentMapper();
                DocumentMapper newMapper = mapperService.parse("_doc", mappingUpdateSource);
                if (existingMapper == null) continue;
                existingMapper.merge(newMapper.mapping(), MapperService.MergeReason.MAPPING_UPDATE);
            }
            Metadata.Builder builder = Metadata.builder(metadata);
            boolean updated = false;
            for (IndexMetadata indexMetadata : updateList) {
                boolean updatedMapping = false;
                Index index = indexMetadata.getIndex();
                MapperService mapperService = indexMapperServices.get(index);
                boolean isCompositeFieldPresent = !mapperService.getCompositeFieldTypes().isEmpty();
                CompressedXContent existingSource = null;
                DocumentMapper existingMapper = mapperService.documentMapper();
                if (existingMapper != null) {
                    existingSource = existingMapper.mappingSource();
                }
                DocumentMapper mergedMapper = mapperService.merge("_doc", mappingUpdateSource, MapperService.MergeReason.MAPPING_UPDATE);
                CompositeIndexValidator.validate(mapperService, MetadataMappingService.this.indicesService.getCompositeIndexSettings(), mapperService.getIndexSettings(), isCompositeFieldPresent);
                CompressedXContent updatedSource = mergedMapper.mappingSource();
                if (existingSource != null) {
                    if (!existingSource.equals(updatedSource)) {
                        updatedMapping = true;
                        if (logger.isDebugEnabled()) {
                            logger.debug("{} update_mapping [{}] with source [{}]", (Object)index, (Object)mergedMapper.type(), (Object)updatedSource);
                        } else if (logger.isInfoEnabled()) {
                            logger.info("{} update_mapping [{}]", (Object)index, (Object)mergedMapper.type());
                        }
                    }
                } else {
                    updatedMapping = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug("{} create_mapping with source [{}]", (Object)index, (Object)updatedSource);
                    } else if (logger.isInfoEnabled()) {
                        logger.info("{} create_mapping", (Object)index);
                    }
                }
                IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder(indexMetadata);
                DocumentMapper mapper = mapperService.documentMapper();
                if (mapper != null) {
                    indexMetadataBuilder.putMapping(new MappingMetadata(mapper.mappingSource()));
                }
                if (updatedMapping) {
                    indexMetadataBuilder.mappingVersion(1L + indexMetadataBuilder.mappingVersion());
                }
                builder.put(indexMetadataBuilder);
                updated |= updatedMapping;
            }
            if (updated) {
                return ClusterState.builder(currentState).metadata(builder).build();
            }
            return currentState;
        }
    }

    static class RefreshTask {
        final String index;
        final String indexUUID;

        RefreshTask(String index, String indexUUID) {
            this.index = index;
            this.indexUUID = indexUUID;
        }

        public String toString() {
            return "[" + this.index + "][" + this.indexUUID + "]";
        }
    }
}

