/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.autotagging;

import java.io.IOException;
import java.util.Map;
import org.opensearch.autotagging.Attribute;
import org.opensearch.autotagging.AutoTaggingRegistry;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public interface FeatureType
extends Writeable {
    public static final int DEFAULT_MAX_ATTRIBUTE_VALUES = 10;
    public static final int DEFAULT_MAX_ATTRIBUTE_VALUE_LENGTH = 100;

    public String getName();

    public Map<String, Attribute> getAllowedAttributesRegistry();

    default public int getMaxNumberOfValuesPerAttribute() {
        return 10;
    }

    default public int getMaxCharLengthPerAttributeValue() {
        return 100;
    }

    public void registerFeatureType();

    default public boolean isValidAttribute(Attribute attribute) {
        return this.getAllowedAttributesRegistry().containsValue(attribute);
    }

    default public Attribute getAttributeFromName(String name) {
        return this.getAllowedAttributesRegistry().get(name);
    }

    default public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.getName());
    }

    public static FeatureType from(StreamInput in) throws IOException {
        return AutoTaggingRegistry.getFeatureType(in.readString());
    }
}

