/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.NumericUtils;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.DoubleArray;
import org.opensearch.index.codec.composite.CompositeIndexFieldInfo;
import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.StarTreeBucketCollector;
import org.opensearch.search.aggregations.StarTreePreComputeCollector;
import org.opensearch.search.aggregations.metrics.CompensatedSum;
import org.opensearch.search.aggregations.metrics.InternalSum;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.startree.StarTreeQueryHelper;

public class SumAggregator
extends NumericMetricsAggregator.SingleValue
implements StarTreePreComputeCollector {
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat format;
    private DoubleArray sums;
    private DoubleArray compensations;

    SumAggregator(String name, ValuesSourceConfig valuesSourceConfig, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Numeric)valuesSourceConfig.getValuesSource() : null;
        this.format = valuesSourceConfig.format();
        if (this.valuesSource != null) {
            this.sums = context.bigArrays().newDoubleArray(1L, true);
            this.compensations = context.bigArrays().newDoubleArray(1L, true);
        }
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    protected boolean tryPrecomputeAggregationForLeaf(LeafReaderContext ctx) throws IOException {
        if (this.valuesSource == null) {
            return false;
        }
        CompositeIndexFieldInfo supportedStarTree = StarTreeQueryHelper.getSupportedStarTree(this.context.getQueryShardContext());
        if (supportedStarTree != null) {
            if (this.parent != null && this.subAggregators.length == 0) {
                return true;
            }
            this.precomputeLeafUsingStarTree(ctx, supportedStarTree);
            return true;
        }
        return false;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(this, sub, values){
            final /* synthetic */ SumAggregator this$0;
            {
                this.this$0 = this$0;
                super(sub, values2);
            }

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    this.setKahanSummation(bucket);
                    for (int i = 0; i < values.docValueCount(); ++i) {
                        double value = values.nextValue();
                        kahanSummation.add(value);
                    }
                    this.this$0.compensations.set(bucket, kahanSummation.delta());
                    this.this$0.sums.set(bucket, kahanSummation.value());
                }
            }

            @Override
            public void collect(DocIdStream stream, long bucket) throws IOException {
                this.setKahanSummation(bucket);
                stream.forEach(doc -> {
                    if (values.advanceExact(doc)) {
                        for (int i = 0; i < values.docValueCount(); ++i) {
                            kahanSummation.add(values.nextValue());
                        }
                    }
                });
                this.this$0.compensations.set(bucket, kahanSummation.delta());
                this.this$0.sums.set(bucket, kahanSummation.value());
            }

            @Override
            public void collectRange(int min, int max) throws IOException {
                this.setKahanSummation(0L);
                for (int docId = min; docId < max; ++docId) {
                    if (!values.advanceExact(docId)) continue;
                    for (int i = 0; i < values.docValueCount(); ++i) {
                        kahanSummation.add(values.nextValue());
                    }
                }
                this.this$0.sums.set(0L, kahanSummation.value());
                this.this$0.compensations.set(0L, kahanSummation.delta());
            }

            private void setKahanSummation(long bucket) {
                this.this$0.sums = bigArrays.grow(this.this$0.sums, bucket + 1L);
                this.this$0.compensations = bigArrays.grow(this.this$0.compensations, bucket + 1L);
                double sum = this.this$0.sums.get(bucket);
                double compensation = this.this$0.compensations.get(bucket);
                kahanSummation.reset(sum, compensation);
            }
        };
    }

    private void precomputeLeafUsingStarTree(LeafReaderContext ctx, CompositeIndexFieldInfo starTree) throws IOException {
        CompensatedSum kahanSummation = new CompensatedSum(this.sums.get(0L), this.compensations.get(0L));
        StarTreeQueryHelper.precomputeLeafUsingStarTree(this.context, this.valuesSource, ctx, starTree, MetricStat.SUM.getTypeName(), value -> kahanSummation.add(NumericUtils.sortableLongToDouble((long)value)), () -> {
            this.sums.set(0L, kahanSummation.value());
            this.compensations.set(0L, kahanSummation.delta());
        });
    }

    @Override
    public StarTreeBucketCollector getStarTreeBucketCollector(LeafReaderContext ctx, CompositeIndexFieldInfo starTree, StarTreeBucketCollector parentCollector) throws IOException {
        CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return StarTreeQueryHelper.getStarTreeBucketMetricCollector(starTree, MetricStat.SUM.getTypeName(), this.valuesSource, parentCollector, bucket -> {
            this.sums = this.context.bigArrays().grow(this.sums, bucket + 1L);
            this.compensations = this.context.bigArrays().grow(this.compensations, bucket + 1L);
        }, (bucket, metricValue) -> {
            kahanSummation.reset(this.sums.get((long)bucket), this.compensations.get((long)bucket));
            kahanSummation.add(NumericUtils.sortableLongToDouble((long)metricValue));
            this.sums.set((long)bucket, kahanSummation.value());
            this.compensations.set((long)bucket, kahanSummation.delta());
        });
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.sums.size()) {
            return 0.0;
        }
        return this.sums.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalSum(this.name, this.sums.get(bucket), this.format, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalSum(this.name, 0.0, this.format, this.metadata());
    }

    @Override
    public void doReset() {
        if (this.sums != null) {
            this.sums.fill(0L, this.sums.size(), 0.0);
        }
        if (this.compensations != null) {
            this.compensations.fill(0L, this.compensations.size(), 0.0);
        }
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.sums, this.compensations});
    }
}

