/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchTimeoutException;
import org.opensearch.common.util.concurrent.BaseFuture;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.transport.ResponseHandlerFailureTransportException;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportFuture;
import org.opensearch.transport.TransportResponseHandler;

public class PlainTransportFuture<V extends TransportResponse>
extends BaseFuture<V>
implements TransportFuture<V>,
TransportResponseHandler<V> {
    private final TransportResponseHandler<V> handler;

    public PlainTransportFuture(TransportResponseHandler<V> handler) {
        this.handler = handler;
    }

    @Override
    public V txGet() {
        try {
            return (V)((TransportResponse)this.get());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Future got interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof OpenSearchException) {
                OpenSearchException openSearchException = (OpenSearchException)throwable;
                throw openSearchException;
            }
            throw new TransportException("Failed execution", e);
        }
    }

    @Override
    public V txGet(long timeout, TimeUnit unit) {
        try {
            return (V)((TransportResponse)this.get(timeout, unit));
        }
        catch (TimeoutException e) {
            throw new OpenSearchTimeoutException(e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Future got interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof OpenSearchException) {
                OpenSearchException openSearchException = (OpenSearchException)throwable;
                throw openSearchException;
            }
            throw new TransportException("Failed execution", e);
        }
    }

    public V read(StreamInput in) throws IOException {
        return (V)((TransportResponse)this.handler.read(in));
    }

    @Override
    public String executor() {
        return this.handler.executor();
    }

    @Override
    public void handleResponse(V response) {
        try {
            this.handler.handleResponse(response);
            this.set(response);
        }
        catch (Exception e) {
            this.handleException(new ResponseHandlerFailureTransportException(e));
        }
    }

    @Override
    public void handleException(TransportException exp) {
        try {
            this.handler.handleException(exp);
        }
        finally {
            this.setException((Throwable)((Object)exp));
        }
    }

    public String toString() {
        return "future(" + this.handler.toString() + ")";
    }
}

