/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.BigArrays;
import org.opensearch.index.fielddata.plain.HllFieldData;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.metrics.AbstractHyperLogLogPlusPlus;
import org.opensearch.search.aggregations.metrics.HyperLogLogPlusPlus;
import org.opensearch.search.aggregations.metrics.InternalCardinality;
import org.opensearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.opensearch.search.internal.SearchContext;

public class HllCardinalityAggregator
extends NumericMetricsAggregator.SingleValue {
    private static final Logger logger = LogManager.getLogger(HllCardinalityAggregator.class);
    private final HllFieldData fieldData;
    private final int precision;
    private HyperLogLogPlusPlus counts;

    HllCardinalityAggregator(String name, HllFieldData fieldData, int precision, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.fieldData = fieldData;
        this.precision = precision;
        this.counts = null;
    }

    @Override
    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        final HllFieldData.HllLeafFieldData leafData = this.fieldData.load(ctx);
        return new LeafBucketCollector(this){
            final /* synthetic */ HllCardinalityAggregator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void collect(int doc, long bucket) throws IOException {
                try (AbstractHyperLogLogPlusPlus sketch = null;){
                    sketch = leafData.getSketch(doc);
                    if (sketch != null) {
                        if (this.this$0.counts == null) {
                            this.this$0.counts = new HyperLogLogPlusPlus(this.this$0.precision, this.this$0.context.bigArrays(), bucket + 1L);
                        }
                        if (bucket >= this.this$0.counts.maxOrd()) {
                            HyperLogLogPlusPlus newCounts = new HyperLogLogPlusPlus(this.this$0.precision, this.this$0.context.bigArrays(), bucket + 1L);
                            for (long i = 0L; i < this.this$0.counts.maxOrd(); ++i) {
                                if (this.this$0.counts.cardinality(i) <= 0L) continue;
                                newCounts.merge(i, this.this$0.counts, i);
                            }
                            this.this$0.counts.close();
                            this.this$0.counts = newCounts;
                        }
                        this.this$0.counts.merge(bucket, sketch, 0L);
                    }
                }
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.counts == null ? 0.0 : (double)this.counts.cardinality(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.counts == null || owningBucketOrdinal >= this.counts.maxOrd() || this.counts.cardinality(owningBucketOrdinal) == 0L) {
            return this.buildEmptyAggregation();
        }
        AbstractHyperLogLogPlusPlus copy = this.counts.clone(owningBucketOrdinal, BigArrays.NON_RECYCLING_INSTANCE);
        return new InternalCardinality(this.name, copy, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalCardinality(this.name, null, this.metadata());
    }

    @Override
    protected void doClose() {
        Releasables.close((Releasable)this.counts);
    }
}

