/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.IntroSelector;
import org.apache.lucene.util.NumericUtils;
import org.opensearch.common.Numbers;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.IntArray;
import org.opensearch.index.fielddata.FieldData;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalMultiBucketAggregation;
import org.opensearch.search.aggregations.InternalOrder;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.LocalBucketCountThresholds;
import org.opensearch.search.aggregations.bucket.terms.DoubleTerms;
import org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.opensearch.search.aggregations.bucket.terms.InternalMappedTerms;
import org.opensearch.search.aggregations.bucket.terms.InternalTerms;
import org.opensearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.opensearch.search.aggregations.bucket.terms.LongTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.opensearch.search.aggregations.bucket.terms.UnsignedLongTerms;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.internal.SearchContext;

public class StreamNumericTermsAggregator
extends TermsAggregator {
    private static final Logger logger = LogManager.getLogger(StreamNumericTermsAggregator.class);
    private final ResultStrategy<?, ?> resultStrategy;
    private final ValuesSource.Numeric valuesSource;
    private final IncludeExclude.LongFilter longFilter;
    private LongKeyedBucketOrds bucketOrds;
    private final CardinalityUpperBound cardinality;
    private final int segmentTopN;

    public StreamNumericTermsAggregator(String name, AggregatorFactories factories, Function<StreamNumericTermsAggregator, ResultStrategy<?, ?>> resultStrategy, ValuesSource.Numeric valuesSource, DocValueFormat format, BucketOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, SearchContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, IncludeExclude.LongFilter longFilter, CardinalityUpperBound cardinality, int segmentTopN, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggregationContext, parent, bucketCountThresholds, order, format, subAggCollectMode, metadata);
        this.resultStrategy = resultStrategy.apply(this);
        this.valuesSource = valuesSource;
        this.longFilter = longFilter;
        this.cardinality = cardinality;
        this.segmentTopN = segmentTopN;
    }

    @Override
    public void doReset() {
        super.doReset();
        Releasables.close((Releasable)this.bucketOrds);
        this.bucketOrds = null;
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.bucketOrds != null) {
            this.bucketOrds.close();
        }
        this.bucketOrds = LongKeyedBucketOrds.build(this.context.bigArrays(), this.cardinality);
        final SortedNumericDocValues values = this.resultStrategy.getValues(ctx);
        return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(this, sub, values){
            final /* synthetic */ StreamNumericTermsAggregator this$0;
            {
                this.this$0 = this$0;
                super(sub2, values2);
            }

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    long previous = Long.MAX_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long val = values.nextValue();
                        if (previous == val && i != 0) continue;
                        if (this.this$0.longFilter == null || this.this$0.longFilter.accept(val)) {
                            long bucketOrdinal = this.this$0.bucketOrds.add(owningBucketOrd, val);
                            if (bucketOrdinal < 0L) {
                                bucketOrdinal = -1L - bucketOrdinal;
                                this.this$0.collectExistingBucket(sub, doc, bucketOrdinal);
                            } else {
                                this.this$0.collectBucket(sub, doc, bucketOrdinal);
                            }
                        }
                        previous = val;
                    }
                }
            }
        });
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.resultStrategy.buildAggregationsBatch(owningBucketOrds);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.resultStrategy.buildEmptyResult();
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("result_strategy", this.resultStrategy.describe());
        add.accept("total_buckets", this.bucketOrds == null ? 0L : this.bucketOrds.size());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{() -> super.doClose(), this.bucketOrds, this.resultStrategy});
    }

    public abstract class ResultStrategy<R extends InternalAggregation, B extends InternalMultiBucketAggregation.InternalBucket>
    implements Releasable {
        protected IntArray reusableIndices;
        protected Aggregator.BucketComparator ordinalComparator;
        protected B tempBucket1;
        protected B tempBucket2;

        private InternalAggregation[] buildAggregationsBatch(long[] owningBucketOrds) throws IOException {
            if (StreamNumericTermsAggregator.this.bucketOrds == null) {
                InternalAggregation[] results = new InternalAggregation[owningBucketOrds.length];
                for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                    results[ordIdx] = this.buildEmptyResult();
                }
                return results;
            }
            LocalBucketCountThresholds localBucketCountThresholds = StreamNumericTermsAggregator.this.context.asLocalBucketCountThresholds(StreamNumericTermsAggregator.this.bucketCountThresholds);
            InternalMultiBucketAggregation.InternalBucket[][] topBucketsPerOrd = this.buildTopBucketsPerOrd(owningBucketOrds.length);
            long[] otherDocCount = new long[owningBucketOrds.length];
            for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                StreamNumericTermsAggregator.this.checkCancelled();
                this.collectZeroDocEntriesIfNeeded(owningBucketOrds[ordIdx]);
                LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = StreamNumericTermsAggregator.this.bucketOrds.ordsEnum(owningBucketOrds[ordIdx]);
                long bucketsInOrd = StreamNumericTermsAggregator.this.bucketOrds.bucketsInOrd(owningBucketOrds[ordIdx]);
                logger.debug("Cardinality post collection for ordIdx {}: {}", (Object)ordIdx, (Object)bucketsInOrd);
                SelectionResult<B> selectionResult = this.selectTopBuckets(ordsEnum, bucketsInOrd, StreamNumericTermsAggregator.this.segmentTopN, StreamNumericTermsAggregator.this.bucketCountThresholds, owningBucketOrds[ordIdx]);
                otherDocCount[ordIdx] = selectionResult.otherDocCount;
                topBucketsPerOrd[ordIdx] = this.buildBuckets(selectionResult.buckets.size());
                for (int i = 0; i < topBucketsPerOrd[ordIdx].length; ++i) {
                    topBucketsPerOrd[ordIdx][i] = (InternalMultiBucketAggregation.InternalBucket)selectionResult.buckets.get(i);
                }
            }
            this.buildSubAggs(topBucketsPerOrd);
            InternalAggregation[] result = new InternalAggregation[owningBucketOrds.length];
            for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
                result[ordIdx] = this.buildResult(owningBucketOrds[ordIdx], otherDocCount[ordIdx], topBucketsPerOrd[ordIdx]);
            }
            return result;
        }

        private void prepareIndicesArray(long valueCount) {
            if (this.reusableIndices == null) {
                this.reusableIndices = StreamNumericTermsAggregator.this.context.bigArrays().newIntArray(valueCount, false);
            } else if (this.reusableIndices.size() < valueCount) {
                this.reusableIndices = StreamNumericTermsAggregator.this.context.bigArrays().grow(this.reusableIndices, valueCount);
            }
        }

        protected void ensureOrdinalComparator() {
        }

        abstract B createTempBucket();

        private SelectionResult<B> selectTopBuckets(LongKeyedBucketOrds.BucketOrdsEnum ordsEnum, long totalBuckets, int segmentSize, TermsAggregator.BucketCountThresholds thresholds, long owningBucketOrd) throws IOException {
            this.prepareIndicesArray(totalBuckets);
            int candidateCount = 0;
            long totalDocCount = 0L;
            while (ordsEnum.next()) {
                long docCount = StreamNumericTermsAggregator.this.bucketDocCount(ordsEnum.ord());
                totalDocCount += docCount;
                if (docCount < thresholds.getMinDocCount()) continue;
                this.reusableIndices.set(candidateCount++, (int)ordsEnum.ord());
            }
            if (candidateCount <= (segmentSize = Math.min(segmentSize, candidateCount))) {
                ordsEnum = StreamNumericTermsAggregator.this.bucketOrds.ordsEnum(owningBucketOrd);
                ArrayList<B> result = new ArrayList<B>(candidateCount);
                long selectedDocCount = 0L;
                while (ordsEnum.next()) {
                    long docCount = StreamNumericTermsAggregator.this.bucketDocCount(ordsEnum.ord());
                    if (docCount < thresholds.getMinDocCount()) continue;
                    result.add(this.buildFinalBucket(ordsEnum.ord(), ordsEnum.value(), docCount, owningBucketOrd));
                    selectedDocCount += docCount;
                }
                return new SelectionResult(result, totalDocCount - selectedDocCount);
            }
            this.ensureOrdinalComparator();
            IntroSelector selector = new IntroSelector(){
                int pivotOrdinal;

                protected void swap(int i, int j) {
                    int temp = ResultStrategy.this.reusableIndices.get(i);
                    ResultStrategy.this.reusableIndices.set(i, ResultStrategy.this.reusableIndices.get(j));
                    ResultStrategy.this.reusableIndices.set(j, temp);
                }

                protected void setPivot(int i) {
                    this.pivotOrdinal = ResultStrategy.this.reusableIndices.get(i);
                }

                protected int comparePivot(int j) {
                    long leftOrd = ResultStrategy.this.reusableIndices.get(j);
                    long rightOrd = this.pivotOrdinal;
                    if (ResultStrategy.this.ordinalComparator != null) {
                        return -ResultStrategy.this.ordinalComparator.compare(leftOrd, rightOrd);
                    }
                    long leftDocCount = StreamNumericTermsAggregator.this.bucketDocCount(leftOrd);
                    long rightDocCount = StreamNumericTermsAggregator.this.bucketDocCount(rightOrd);
                    return Long.compare(leftDocCount, rightDocCount);
                }
            };
            selector.select(0, candidateCount, segmentSize);
            ArrayList<B> result = new ArrayList<B>(segmentSize);
            long selectedDocCount = 0L;
            for (int i = 0; i < segmentSize; ++i) {
                int selectedOrd = this.reusableIndices.get(i);
                long value = StreamNumericTermsAggregator.this.bucketOrds.get(selectedOrd);
                long docCount = StreamNumericTermsAggregator.this.bucketDocCount(selectedOrd);
                result.add(this.buildFinalBucket(selectedOrd, value, docCount, owningBucketOrd));
                selectedDocCount += docCount;
            }
            return new SelectionResult(result, totalDocCount - selectedDocCount);
        }

        public final void close() {
            Releasables.close((Releasable)this.reusableIndices);
            this.reusableIndices = null;
        }

        abstract String describe();

        abstract SortedNumericDocValues getValues(LeafReaderContext var1) throws IOException;

        abstract LeafBucketCollector wrapCollector(LeafBucketCollector var1);

        abstract B[][] buildTopBucketsPerOrd(int var1);

        abstract B[] buildBuckets(int var1);

        abstract void buildSubAggs(B[][] var1) throws IOException;

        abstract void collectZeroDocEntriesIfNeeded(long var1) throws IOException;

        abstract R buildResult(long var1, long var3, B[] var5);

        abstract R buildEmptyResult();

        abstract B buildFinalBucket(long var1, long var3, long var5, long var7) throws IOException;

        private static class SelectionResult<B> {
            final List<B> buckets;
            final long otherDocCount;

            SelectionResult(List<B> buckets, long otherDocCount) {
                this.buckets = buckets;
                this.otherDocCount = otherDocCount;
            }
        }
    }

    public class UnsignedLongTermsResults
    extends StandardTermsResultStrategy<UnsignedLongTerms, UnsignedLongTerms.Bucket> {
        public UnsignedLongTermsResults(boolean showTermDocCountError) {
            super(showTermDocCountError);
        }

        @Override
        UnsignedLongTerms.Bucket createTempBucket() {
            return new UnsignedLongTerms.Bucket(Numbers.toUnsignedBigInteger((long)0L), 0L, null, this.showTermDocCountError, 0L, StreamNumericTermsAggregator.this.format){

                @Override
                public int compareKey(UnsignedLongTerms.Bucket other) {
                    long thisValue = StreamNumericTermsAggregator.this.bucketOrds.get(this.bucketOrd);
                    long otherValue = StreamNumericTermsAggregator.this.bucketOrds.get(other.bucketOrd);
                    return Long.compareUnsigned(thisValue, otherValue);
                }
            };
        }

        @Override
        String describe() {
            return "stream_unsigned_long_terms";
        }

        @Override
        SortedNumericDocValues getValues(LeafReaderContext ctx) throws IOException {
            return StreamNumericTermsAggregator.this.valuesSource.longValues(ctx);
        }

        UnsignedLongTerms.Bucket[][] buildTopBucketsPerOrd(int size) {
            return new UnsignedLongTerms.Bucket[size][];
        }

        UnsignedLongTerms.Bucket[] buildBuckets(int size) {
            return new UnsignedLongTerms.Bucket[size];
        }

        UnsignedLongTerms buildResult(long owningBucketOrd, long otherDocCount, UnsignedLongTerms.Bucket[] topBuckets) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(StreamNumericTermsAggregator.this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBuckets, reduceOrder.comparator());
            } else {
                reduceOrder = StreamNumericTermsAggregator.this.order;
            }
            return new UnsignedLongTerms(StreamNumericTermsAggregator.this.name, reduceOrder, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.metadata(), StreamNumericTermsAggregator.this.format, StreamNumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, List.of(topBuckets), 0L, StreamNumericTermsAggregator.this.bucketCountThresholds);
        }

        @Override
        UnsignedLongTerms buildEmptyResult() {
            return new UnsignedLongTerms(StreamNumericTermsAggregator.this.name, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.metadata(), StreamNumericTermsAggregator.this.format, StreamNumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, 0L, Collections.emptyList(), 0L, StreamNumericTermsAggregator.this.bucketCountThresholds);
        }

        @Override
        UnsignedLongTerms.Bucket buildFinalBucket(long ord, long value, long docCount, long owningBucketOrd) {
            UnsignedLongTerms.Bucket result = new UnsignedLongTerms.Bucket(Numbers.toUnsignedBigInteger((long)value), docCount, null, this.showTermDocCountError, 0L, StreamNumericTermsAggregator.this.format);
            result.bucketOrd = ord;
            result.setDocCountError(0L);
            return result;
        }
    }

    public class DoubleTermsResults
    extends StandardTermsResultStrategy<DoubleTerms, DoubleTerms.Bucket> {
        public DoubleTermsResults(boolean showTermDocCountError) {
            super(showTermDocCountError);
        }

        @Override
        DoubleTerms.Bucket createTempBucket() {
            return new DoubleTerms.Bucket(0.0, 0L, null, this.showTermDocCountError, 0L, StreamNumericTermsAggregator.this.format){

                @Override
                public int compareKey(DoubleTerms.Bucket other) {
                    long thisValue = StreamNumericTermsAggregator.this.bucketOrds.get(this.bucketOrd);
                    long otherValue = StreamNumericTermsAggregator.this.bucketOrds.get(other.bucketOrd);
                    return Double.compare(NumericUtils.sortableLongToDouble((long)thisValue), NumericUtils.sortableLongToDouble((long)otherValue));
                }
            };
        }

        @Override
        String describe() {
            return "stream_double_terms";
        }

        @Override
        SortedNumericDocValues getValues(LeafReaderContext ctx) throws IOException {
            return FieldData.toSortableLongBits(StreamNumericTermsAggregator.this.valuesSource.doubleValues(ctx));
        }

        DoubleTerms.Bucket[][] buildTopBucketsPerOrd(int size) {
            return new DoubleTerms.Bucket[size][];
        }

        DoubleTerms.Bucket[] buildBuckets(int size) {
            return new DoubleTerms.Bucket[size];
        }

        DoubleTerms buildResult(long owningBucketOrd, long otherDocCount, DoubleTerms.Bucket[] topBuckets) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(StreamNumericTermsAggregator.this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBuckets, reduceOrder.comparator());
            } else {
                reduceOrder = StreamNumericTermsAggregator.this.order;
            }
            return new DoubleTerms(StreamNumericTermsAggregator.this.name, reduceOrder, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.metadata(), StreamNumericTermsAggregator.this.format, StreamNumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, List.of(topBuckets), 0L, StreamNumericTermsAggregator.this.bucketCountThresholds);
        }

        @Override
        DoubleTerms buildEmptyResult() {
            return new DoubleTerms(StreamNumericTermsAggregator.this.name, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.metadata(), StreamNumericTermsAggregator.this.format, StreamNumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, 0L, Collections.emptyList(), 0L, StreamNumericTermsAggregator.this.bucketCountThresholds);
        }

        @Override
        DoubleTerms.Bucket buildFinalBucket(long ord, long value, long docCount, long owningBucketOrd) {
            DoubleTerms.Bucket result = new DoubleTerms.Bucket(NumericUtils.sortableLongToDouble((long)value), docCount, null, this.showTermDocCountError, 0L, StreamNumericTermsAggregator.this.format);
            result.bucketOrd = ord;
            result.setDocCountError(0L);
            return result;
        }
    }

    public class LongTermsResults
    extends StandardTermsResultStrategy<LongTerms, LongTerms.Bucket> {
        public LongTermsResults(boolean showTermDocCountError) {
            super(showTermDocCountError);
        }

        @Override
        LongTerms.Bucket createTempBucket() {
            return new LongTerms.Bucket(0L, 0L, null, this.showTermDocCountError, 0L, StreamNumericTermsAggregator.this.format){

                @Override
                public int compareKey(LongTerms.Bucket other) {
                    long thisValue = StreamNumericTermsAggregator.this.bucketOrds.get(this.bucketOrd);
                    long otherValue = StreamNumericTermsAggregator.this.bucketOrds.get(other.bucketOrd);
                    return Long.compare(thisValue, otherValue);
                }
            };
        }

        @Override
        String describe() {
            return "stream_long_terms";
        }

        @Override
        SortedNumericDocValues getValues(LeafReaderContext ctx) throws IOException {
            return StreamNumericTermsAggregator.this.valuesSource.longValues(ctx);
        }

        LongTerms.Bucket[][] buildTopBucketsPerOrd(int size) {
            return new LongTerms.Bucket[size][];
        }

        LongTerms.Bucket[] buildBuckets(int size) {
            return new LongTerms.Bucket[size];
        }

        LongTerms buildResult(long owningBucketOrd, long otherDocCount, LongTerms.Bucket[] topBuckets) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(StreamNumericTermsAggregator.this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBuckets, reduceOrder.comparator());
            } else {
                reduceOrder = StreamNumericTermsAggregator.this.order;
            }
            return new LongTerms(StreamNumericTermsAggregator.this.name, reduceOrder, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.metadata(), StreamNumericTermsAggregator.this.format, StreamNumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, List.of(topBuckets), 0L, StreamNumericTermsAggregator.this.bucketCountThresholds);
        }

        @Override
        LongTerms buildEmptyResult() {
            return new LongTerms(StreamNumericTermsAggregator.this.name, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.order, StreamNumericTermsAggregator.this.metadata(), StreamNumericTermsAggregator.this.format, StreamNumericTermsAggregator.this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, 0L, Collections.emptyList(), 0L, StreamNumericTermsAggregator.this.bucketCountThresholds);
        }

        @Override
        LongTerms.Bucket buildFinalBucket(long ord, long value, long docCount, long owningBucketOrd) {
            LongTerms.Bucket result = new LongTerms.Bucket(value, docCount, null, this.showTermDocCountError, 0L, StreamNumericTermsAggregator.this.format);
            result.bucketOrd = ord;
            result.setDocCountError(0L);
            return result;
        }
    }

    abstract class StandardTermsResultStrategy<R extends InternalMappedTerms<R, B>, B extends InternalTerms.Bucket<B>>
    extends ResultStrategy<R, B> {
        protected final boolean showTermDocCountError;

        StandardTermsResultStrategy(boolean showTermDocCountError) {
            this.showTermDocCountError = showTermDocCountError;
        }

        @Override
        protected void ensureOrdinalComparator() {
            if (this.ordinalComparator == null) {
                if (InternalOrder.isKeyOrder(StreamNumericTermsAggregator.this.order)) {
                    throw new IllegalArgumentException("Streaming aggregation does not support key-based ordering for numeric fields. Use traditional aggregation approach instead.");
                }
                if (StreamNumericTermsAggregator.this.partiallyBuiltBucketComparator != null) {
                    this.tempBucket1 = this.createTempBucket();
                    this.tempBucket2 = this.createTempBucket();
                    this.ordinalComparator = (leftOrd, rightOrd) -> {
                        ((InternalTerms.Bucket)this.tempBucket1).bucketOrd = leftOrd;
                        ((InternalTerms.Bucket)this.tempBucket1).docCount = StreamNumericTermsAggregator.this.bucketDocCount(leftOrd);
                        ((InternalTerms.Bucket)this.tempBucket2).bucketOrd = rightOrd;
                        ((InternalTerms.Bucket)this.tempBucket2).docCount = StreamNumericTermsAggregator.this.bucketDocCount(rightOrd);
                        return StreamNumericTermsAggregator.this.partiallyBuiltBucketComparator.compare((InternalTerms.Bucket)this.tempBucket1, (InternalTerms.Bucket)this.tempBucket2);
                    };
                }
            }
        }

        @Override
        final LeafBucketCollector wrapCollector(LeafBucketCollector primary) {
            return primary;
        }

        @Override
        final void buildSubAggs(B[][] topBucketsPerOrd) throws IOException {
            StreamNumericTermsAggregator.this.buildSubAggsForAllBuckets(topBucketsPerOrd, b -> b.bucketOrd, (b, aggs) -> {
                b.aggregations = aggs;
            });
        }

        @Override
        final void collectZeroDocEntriesIfNeeded(long owningBucketOrd) throws IOException {
            if (StreamNumericTermsAggregator.this.bucketCountThresholds.getMinDocCount() != 0L) {
                return;
            }
            if (InternalOrder.isCountDesc(StreamNumericTermsAggregator.this.order) && StreamNumericTermsAggregator.this.bucketOrds.bucketsInOrd(owningBucketOrd) >= (long)StreamNumericTermsAggregator.this.bucketCountThresholds.getRequiredSize()) {
                return;
            }
            for (LeafReaderContext ctx : StreamNumericTermsAggregator.this.context.searcher().getTopReaderContext().leaves()) {
                SortedNumericDocValues values = this.getValues(ctx);
                for (int docId = 0; docId < ctx.reader().maxDoc(); ++docId) {
                    if (!values.advanceExact(docId)) continue;
                    int valueCount = values.docValueCount();
                    for (int v = 0; v < valueCount; ++v) {
                        long value = values.nextValue();
                        if (StreamNumericTermsAggregator.this.longFilter != null && !StreamNumericTermsAggregator.this.longFilter.accept(value)) continue;
                        StreamNumericTermsAggregator.this.bucketOrds.add(owningBucketOrd, value);
                    }
                }
            }
        }
    }
}

