/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.opensearch.OpenSearchCorruptionException;
import org.opensearch.action.StepListener;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.util.CancellableThreads;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.Store;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.indices.recovery.MultiFileWriter;
import org.opensearch.indices.replication.CheckpointInfoResponse;
import org.opensearch.indices.replication.GetSegmentFilesResponse;
import org.opensearch.indices.replication.SegmentReplicationSource;
import org.opensearch.indices.replication.SegmentReplicationState;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.opensearch.indices.replication.common.ReplicationFailedException;
import org.opensearch.indices.replication.common.ReplicationListener;
import org.opensearch.indices.replication.common.ReplicationLuceneIndex;
import org.opensearch.indices.replication.common.ReplicationTarget;

public abstract class AbstractSegmentReplicationTarget
extends ReplicationTarget {
    protected final ReplicationCheckpoint checkpoint;
    protected final SegmentReplicationSource source;
    protected final SegmentReplicationState state;
    protected final MultiFileWriter multiFileWriter;

    public AbstractSegmentReplicationTarget(String name, IndexShard indexShard, ReplicationCheckpoint checkpoint, SegmentReplicationSource source, ReplicationListener listener) {
        super(name, indexShard, new ReplicationLuceneIndex(), listener);
        this.checkpoint = checkpoint;
        this.source = source;
        this.state = new SegmentReplicationState(indexShard.routingEntry(), this.stateIndex, this.getId(), source.getDescription(), indexShard.recoveryState().getTargetNode());
        AbstractSegmentReplicationTarget abstractSegmentReplicationTarget = this;
        this.multiFileWriter = new MultiFileWriter(indexShard.store(), this.stateIndex, this.getPrefix(), this.logger, () -> abstractSegmentReplicationTarget.ensureRefCount());
    }

    @Override
    protected void closeInternal() {
        try {
            this.multiFileWriter.close();
        }
        finally {
            super.closeInternal();
        }
    }

    @Override
    protected void onCancel(String reason) {
        try {
            this.notifyListener(new ReplicationFailedException(reason), false);
        }
        finally {
            this.source.cancel();
            this.cancellableThreads.cancel(reason);
        }
    }

    @Override
    protected void onDone() {
        this.state.setStage(SegmentReplicationState.Stage.DONE);
    }

    @Override
    public SegmentReplicationState state() {
        return this.state;
    }

    @Override
    public String description() {
        return String.format(Locale.ROOT, "Id:[%d] Checkpoint [%s] Shard:[%s] Source:[%s]", this.getId(), this.getCheckpoint(), this.shardId(), this.source.getDescription());
    }

    @Override
    public void notifyListener(ReplicationFailedException e, boolean sendShardFailure) {
        this.listener.onFailure(this.state(), e, sendShardFailure);
    }

    @Override
    public boolean reset(CancellableThreads newTargetCancellableThreads) throws IOException {
        return false;
    }

    public ReplicationCheckpoint getCheckpoint() {
        return this.checkpoint;
    }

    @Override
    public void writeFileChunk(StoreFileMetadata metadata, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        try {
            this.multiFileWriter.writeFileChunk(metadata, position, content, lastChunk);
            listener.onResponse(null);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void startReplication(ActionListener<Void> listener, BiConsumer<ReplicationCheckpoint, IndexShard> checkpointUpdater) {
        this.cancellableThreads.setOnCancel((reason, beforeCancelEx) -> {
            throw new CancellableThreads.ExecutionCancelledException("replication was canceled reason [" + reason + "]");
        });
        this.state.setStage(SegmentReplicationState.Stage.REPLICATING);
        StepListener<CheckpointInfoResponse> checkpointInfoListener = new StepListener<CheckpointInfoResponse>();
        StepListener getFilesListener = new StepListener();
        this.logger.trace((Message)new ParameterizedMessage("Starting Replication Target: {}", (Object)this.description()));
        this.state.setStage(SegmentReplicationState.Stage.GET_CHECKPOINT_INFO);
        this.cancellableThreads.checkForCancel();
        this.getCheckpointMetadata(checkpointInfoListener);
        checkpointInfoListener.whenComplete((CheckedConsumer<CheckpointInfoResponse, Exception>)((CheckedConsumer)checkpointInfo -> {
            boolean isRecovering;
            ReplicationCheckpoint getMetadataCheckpoint = checkpointInfo.getCheckpoint();
            boolean bl = isRecovering = this.indexShard.routingEntry().initializing() || this.indexShard.routingEntry().relocating();
            if (this.indexShard.indexSettings().isSegRepLocalEnabled() && this.checkpoint.isAheadOf(getMetadataCheckpoint) && !isRecovering) {
                listener.onFailure((Exception)((Object)new ReplicationFailedException("Rejecting stale metadata checkpoint [" + String.valueOf(getMetadataCheckpoint) + "] since initial checkpoint [" + String.valueOf(this.checkpoint) + "] is ahead of it")));
                return;
            }
            this.updateCheckpoint(checkpointInfo.getCheckpoint(), checkpointUpdater);
            List<StoreFileMetadata> filesToFetch = this.getFiles((CheckpointInfoResponse)((Object)checkpointInfo));
            this.state.setStage(SegmentReplicationState.Stage.GET_FILES);
            this.cancellableThreads.checkForCancel();
            this.getFilesFromSource((CheckpointInfoResponse)((Object)checkpointInfo), filesToFetch, getFilesListener);
        }), arg_0 -> listener.onFailure(arg_0));
        getFilesListener.whenComplete(response -> {
            this.cancellableThreads.checkForCancel();
            this.state.setStage(SegmentReplicationState.Stage.FINALIZE_REPLICATION);
            this.finalizeReplication((CheckpointInfoResponse)((Object)((Object)checkpointInfoListener.result())));
            listener.onResponse(null);
        }, arg_0 -> listener.onFailure(arg_0));
    }

    protected abstract void getCheckpointMetadata(StepListener<CheckpointInfoResponse> var1);

    protected abstract void updateCheckpoint(ReplicationCheckpoint var1, BiConsumer<ReplicationCheckpoint, IndexShard> var2);

    protected abstract void getFilesFromSource(CheckpointInfoResponse var1, List<StoreFileMetadata> var2, StepListener<GetSegmentFilesResponse> var3);

    protected abstract void finalizeReplication(CheckpointInfoResponse var1) throws Exception;

    protected List<StoreFileMetadata> getFiles(CheckpointInfoResponse checkpointInfo) throws IOException {
        this.cancellableThreads.checkForCancel();
        this.state.setStage(SegmentReplicationState.Stage.FILE_DIFF);
        if (this.indexShard.indexSettings().isWarmIndex()) {
            return Collections.emptyList();
        }
        Store.RecoveryDiff diff = Store.segmentReplicationDiff(checkpointInfo.getMetadataMap(), this.indexShard.getSegmentMetadataMap());
        Set<String> localFiles = Set.of(this.indexShard.store().directory().listAll());
        Set reuseFiles = diff.missing.stream().filter(storeFileMetadata -> localFiles.contains(storeFileMetadata.name())).filter(this::validateLocalChecksum).map(StoreFileMetadata::name).collect(Collectors.toSet());
        List<StoreFileMetadata> missingFiles = diff.missing.stream().filter(md -> !reuseFiles.contains(md.name())).collect(Collectors.toList());
        this.logger.trace(() -> new ParameterizedMessage("Replication diff for checkpoint {} {} {}", new Object[]{checkpointInfo.getCheckpoint(), missingFiles, diff.different}));
        if (!diff.different.isEmpty()) {
            throw new OpenSearchCorruptionException(new ParameterizedMessage("Shard {} has local copies of segments that differ from the primary {}", (Object)this.indexShard.shardId(), diff.different).getFormattedMessage());
        }
        for (StoreFileMetadata file : missingFiles) {
            this.state.getIndex().addFileDetail(file.name(), file.length(), false);
        }
        return missingFiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateLocalChecksum(StoreFileMetadata file) {
        try (IndexInput indexInput = this.indexShard.store().directory().openInput(file.name(), IOContext.READONCE);){
            String checksum = Store.digestToString(CodecUtil.retrieveChecksum((IndexInput)indexInput));
            if (file.checksum().equals(checksum)) {
                boolean bl2 = true;
                return bl2;
            }
            this.store.deleteQuiet(file.name());
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.logger.warn("Error reading " + String.valueOf(file), (Throwable)e);
            try {
                this.indexShard.store().directory().deleteFile(file.name());
                return false;
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Error reading " + String.valueOf(file), e);
            }
        }
    }

    protected void updateFileRecoveryBytes(String fileName, long bytesRecovered) {
        ReplicationLuceneIndex index = this.state.getIndex();
        if (index != null) {
            index.addRecoveredBytesToFile(fileName, bytesRecovered);
        }
        this.setLastAccessTime();
    }
}

