/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.protobufs;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.opensearch.protobufs.CommonProto;
import org.opensearch.protobufs.KnnQueryOrBuilder;
import org.opensearch.protobufs.KnnQueryRescore;
import org.opensearch.protobufs.KnnQueryRescoreOrBuilder;
import org.opensearch.protobufs.ObjectMap;
import org.opensearch.protobufs.ObjectMapOrBuilder;
import org.opensearch.protobufs.QueryContainer;
import org.opensearch.protobufs.QueryContainerOrBuilder;

public final class KnnQuery
extends GeneratedMessageV3
implements KnnQueryOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int FIELD_FIELD_NUMBER = 1;
    private volatile Object field_ = "";
    public static final int VECTOR_FIELD_NUMBER = 2;
    private Internal.FloatList vector_ = KnnQuery.emptyFloatList();
    private int vectorMemoizedSerializedSize = -1;
    public static final int K_FIELD_NUMBER = 3;
    private int k_ = 0;
    public static final int MIN_SCORE_FIELD_NUMBER = 4;
    private float minScore_ = 0.0f;
    public static final int MAX_DISTANCE_FIELD_NUMBER = 5;
    private float maxDistance_ = 0.0f;
    public static final int FILTER_FIELD_NUMBER = 6;
    private QueryContainer filter_;
    public static final int BOOST_FIELD_NUMBER = 7;
    private float boost_ = 0.0f;
    public static final int X_NAME_FIELD_NUMBER = 8;
    private volatile Object xName_ = "";
    public static final int METHOD_PARAMETERS_FIELD_NUMBER = 9;
    private ObjectMap methodParameters_;
    public static final int RESCORE_FIELD_NUMBER = 10;
    private KnnQueryRescore rescore_;
    public static final int EXPAND_NESTED_DOCS_FIELD_NUMBER = 11;
    private boolean expandNestedDocs_ = false;
    private byte memoizedIsInitialized = (byte)-1;
    private static final KnnQuery DEFAULT_INSTANCE = new KnnQuery();
    private static final Parser<KnnQuery> PARSER = new AbstractParser<KnnQuery>(){

        public KnnQuery parsePartialFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
            Builder builder = KnnQuery.newBuilder();
            try {
                builder.mergeFrom(codedInputStream, extensionRegistryLite);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException uninitializedMessageException) {
                throw uninitializedMessageException.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException iOException) {
                throw new InvalidProtocolBufferException(iOException).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private KnnQuery(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private KnnQuery() {
        this.field_ = "";
        this.vector_ = KnnQuery.emptyFloatList();
        this.xName_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unusedPrivateParameter) {
        return new KnnQuery();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CommonProto.internal_static_org_opensearch_protobufs_KnnQuery_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CommonProto.internal_static_org_opensearch_protobufs_KnnQuery_fieldAccessorTable.ensureFieldAccessorsInitialized(KnnQuery.class, Builder.class);
    }

    @Override
    public String getField() {
        Object object = this.field_;
        if (object instanceof String) {
            return (String)object;
        }
        ByteString byteString = (ByteString)object;
        String string = byteString.toStringUtf8();
        this.field_ = string;
        return string;
    }

    @Override
    public ByteString getFieldBytes() {
        Object object = this.field_;
        if (object instanceof String) {
            ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
            this.field_ = byteString;
            return byteString;
        }
        return (ByteString)object;
    }

    @Override
    public List<Float> getVectorList() {
        return this.vector_;
    }

    @Override
    public int getVectorCount() {
        return this.vector_.size();
    }

    @Override
    public float getVector(int n) {
        return this.vector_.getFloat(n);
    }

    @Override
    public boolean hasK() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public int getK() {
        return this.k_;
    }

    @Override
    public boolean hasMinScore() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public float getMinScore() {
        return this.minScore_;
    }

    @Override
    public boolean hasMaxDistance() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public float getMaxDistance() {
        return this.maxDistance_;
    }

    @Override
    public boolean hasFilter() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public QueryContainer getFilter() {
        return this.filter_ == null ? QueryContainer.getDefaultInstance() : this.filter_;
    }

    @Override
    public QueryContainerOrBuilder getFilterOrBuilder() {
        return this.filter_ == null ? QueryContainer.getDefaultInstance() : this.filter_;
    }

    @Override
    public boolean hasBoost() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public float getBoost() {
        return this.boost_;
    }

    @Override
    public boolean hasXName() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public String getXName() {
        Object object = this.xName_;
        if (object instanceof String) {
            return (String)object;
        }
        ByteString byteString = (ByteString)object;
        String string = byteString.toStringUtf8();
        this.xName_ = string;
        return string;
    }

    @Override
    public ByteString getXNameBytes() {
        Object object = this.xName_;
        if (object instanceof String) {
            ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
            this.xName_ = byteString;
            return byteString;
        }
        return (ByteString)object;
    }

    @Override
    public boolean hasMethodParameters() {
        return (this.bitField0_ & 0x40) != 0;
    }

    @Override
    public ObjectMap getMethodParameters() {
        return this.methodParameters_ == null ? ObjectMap.getDefaultInstance() : this.methodParameters_;
    }

    @Override
    public ObjectMapOrBuilder getMethodParametersOrBuilder() {
        return this.methodParameters_ == null ? ObjectMap.getDefaultInstance() : this.methodParameters_;
    }

    @Override
    public boolean hasRescore() {
        return (this.bitField0_ & 0x80) != 0;
    }

    @Override
    public KnnQueryRescore getRescore() {
        return this.rescore_ == null ? KnnQueryRescore.getDefaultInstance() : this.rescore_;
    }

    @Override
    public KnnQueryRescoreOrBuilder getRescoreOrBuilder() {
        return this.rescore_ == null ? KnnQueryRescore.getDefaultInstance() : this.rescore_;
    }

    @Override
    public boolean hasExpandNestedDocs() {
        return (this.bitField0_ & 0x100) != 0;
    }

    @Override
    public boolean getExpandNestedDocs() {
        return this.expandNestedDocs_;
    }

    public final boolean isInitialized() {
        byte by = this.memoizedIsInitialized;
        if (by == 1) {
            return true;
        }
        if (by == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream codedOutputStream) throws IOException {
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.field_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)codedOutputStream, (int)1, (Object)this.field_);
        }
        if (this.getVectorList().size() > 0) {
            codedOutputStream.writeUInt32NoTag(18);
            codedOutputStream.writeUInt32NoTag(this.vectorMemoizedSerializedSize);
        }
        for (int i = 0; i < this.vector_.size(); ++i) {
            codedOutputStream.writeFloatNoTag(this.vector_.getFloat(i));
        }
        if ((this.bitField0_ & 1) != 0) {
            codedOutputStream.writeInt32(3, this.k_);
        }
        if ((this.bitField0_ & 2) != 0) {
            codedOutputStream.writeFloat(4, this.minScore_);
        }
        if ((this.bitField0_ & 4) != 0) {
            codedOutputStream.writeFloat(5, this.maxDistance_);
        }
        if ((this.bitField0_ & 8) != 0) {
            codedOutputStream.writeMessage(6, (MessageLite)this.getFilter());
        }
        if ((this.bitField0_ & 0x10) != 0) {
            codedOutputStream.writeFloat(7, this.boost_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)codedOutputStream, (int)8, (Object)this.xName_);
        }
        if ((this.bitField0_ & 0x40) != 0) {
            codedOutputStream.writeMessage(9, (MessageLite)this.getMethodParameters());
        }
        if ((this.bitField0_ & 0x80) != 0) {
            codedOutputStream.writeMessage(10, (MessageLite)this.getRescore());
        }
        if ((this.bitField0_ & 0x100) != 0) {
            codedOutputStream.writeBool(11, this.expandNestedDocs_);
        }
        this.getUnknownFields().writeTo(codedOutputStream);
    }

    public int getSerializedSize() {
        int n = this.memoizedSize;
        if (n != -1) {
            return n;
        }
        n = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.field_)) {
            n += GeneratedMessageV3.computeStringSize((int)1, (Object)this.field_);
        }
        int n2 = 0;
        n2 = 4 * this.getVectorList().size();
        n += n2;
        if (!this.getVectorList().isEmpty()) {
            ++n;
            n += CodedOutputStream.computeInt32SizeNoTag((int)n2);
        }
        this.vectorMemoizedSerializedSize = n2;
        if ((this.bitField0_ & 1) != 0) {
            n += CodedOutputStream.computeInt32Size((int)3, (int)this.k_);
        }
        if ((this.bitField0_ & 2) != 0) {
            n += CodedOutputStream.computeFloatSize((int)4, (float)this.minScore_);
        }
        if ((this.bitField0_ & 4) != 0) {
            n += CodedOutputStream.computeFloatSize((int)5, (float)this.maxDistance_);
        }
        if ((this.bitField0_ & 8) != 0) {
            n += CodedOutputStream.computeMessageSize((int)6, (MessageLite)this.getFilter());
        }
        if ((this.bitField0_ & 0x10) != 0) {
            n += CodedOutputStream.computeFloatSize((int)7, (float)this.boost_);
        }
        if ((this.bitField0_ & 0x20) != 0) {
            n += GeneratedMessageV3.computeStringSize((int)8, (Object)this.xName_);
        }
        if ((this.bitField0_ & 0x40) != 0) {
            n += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getMethodParameters());
        }
        if ((this.bitField0_ & 0x80) != 0) {
            n += CodedOutputStream.computeMessageSize((int)10, (MessageLite)this.getRescore());
        }
        if ((this.bitField0_ & 0x100) != 0) {
            n += CodedOutputStream.computeBoolSize((int)11, (boolean)this.expandNestedDocs_);
        }
        this.memoizedSize = n += this.getUnknownFields().getSerializedSize();
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KnnQuery)) {
            return super.equals(object);
        }
        KnnQuery knnQuery = (KnnQuery)object;
        if (!this.getField().equals(knnQuery.getField())) {
            return false;
        }
        if (!this.getVectorList().equals(knnQuery.getVectorList())) {
            return false;
        }
        if (this.hasK() != knnQuery.hasK()) {
            return false;
        }
        if (this.hasK() && this.getK() != knnQuery.getK()) {
            return false;
        }
        if (this.hasMinScore() != knnQuery.hasMinScore()) {
            return false;
        }
        if (this.hasMinScore() && Float.floatToIntBits(this.getMinScore()) != Float.floatToIntBits(knnQuery.getMinScore())) {
            return false;
        }
        if (this.hasMaxDistance() != knnQuery.hasMaxDistance()) {
            return false;
        }
        if (this.hasMaxDistance() && Float.floatToIntBits(this.getMaxDistance()) != Float.floatToIntBits(knnQuery.getMaxDistance())) {
            return false;
        }
        if (this.hasFilter() != knnQuery.hasFilter()) {
            return false;
        }
        if (this.hasFilter() && !this.getFilter().equals(knnQuery.getFilter())) {
            return false;
        }
        if (this.hasBoost() != knnQuery.hasBoost()) {
            return false;
        }
        if (this.hasBoost() && Float.floatToIntBits(this.getBoost()) != Float.floatToIntBits(knnQuery.getBoost())) {
            return false;
        }
        if (this.hasXName() != knnQuery.hasXName()) {
            return false;
        }
        if (this.hasXName() && !this.getXName().equals(knnQuery.getXName())) {
            return false;
        }
        if (this.hasMethodParameters() != knnQuery.hasMethodParameters()) {
            return false;
        }
        if (this.hasMethodParameters() && !this.getMethodParameters().equals(knnQuery.getMethodParameters())) {
            return false;
        }
        if (this.hasRescore() != knnQuery.hasRescore()) {
            return false;
        }
        if (this.hasRescore() && !this.getRescore().equals(knnQuery.getRescore())) {
            return false;
        }
        if (this.hasExpandNestedDocs() != knnQuery.hasExpandNestedDocs()) {
            return false;
        }
        if (this.hasExpandNestedDocs() && this.getExpandNestedDocs() != knnQuery.getExpandNestedDocs()) {
            return false;
        }
        return this.getUnknownFields().equals((Object)knnQuery.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int n = 41;
        n = 19 * n + KnnQuery.getDescriptor().hashCode();
        n = 37 * n + 1;
        n = 53 * n + this.getField().hashCode();
        if (this.getVectorCount() > 0) {
            n = 37 * n + 2;
            n = 53 * n + this.getVectorList().hashCode();
        }
        if (this.hasK()) {
            n = 37 * n + 3;
            n = 53 * n + this.getK();
        }
        if (this.hasMinScore()) {
            n = 37 * n + 4;
            n = 53 * n + Float.floatToIntBits(this.getMinScore());
        }
        if (this.hasMaxDistance()) {
            n = 37 * n + 5;
            n = 53 * n + Float.floatToIntBits(this.getMaxDistance());
        }
        if (this.hasFilter()) {
            n = 37 * n + 6;
            n = 53 * n + this.getFilter().hashCode();
        }
        if (this.hasBoost()) {
            n = 37 * n + 7;
            n = 53 * n + Float.floatToIntBits(this.getBoost());
        }
        if (this.hasXName()) {
            n = 37 * n + 8;
            n = 53 * n + this.getXName().hashCode();
        }
        if (this.hasMethodParameters()) {
            n = 37 * n + 9;
            n = 53 * n + this.getMethodParameters().hashCode();
        }
        if (this.hasRescore()) {
            n = 37 * n + 10;
            n = 53 * n + this.getRescore().hashCode();
        }
        if (this.hasExpandNestedDocs()) {
            n = 37 * n + 11;
            n = 53 * n + Internal.hashBoolean((boolean)this.getExpandNestedDocs());
        }
        this.memoizedHashCode = n = 29 * n + this.getUnknownFields().hashCode();
        return n;
    }

    public static KnnQuery parseFrom(ByteBuffer byteBuffer) throws InvalidProtocolBufferException {
        return (KnnQuery)PARSER.parseFrom(byteBuffer);
    }

    public static KnnQuery parseFrom(ByteBuffer byteBuffer, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        return (KnnQuery)PARSER.parseFrom(byteBuffer, extensionRegistryLite);
    }

    public static KnnQuery parseFrom(ByteString byteString) throws InvalidProtocolBufferException {
        return (KnnQuery)PARSER.parseFrom(byteString);
    }

    public static KnnQuery parseFrom(ByteString byteString, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        return (KnnQuery)PARSER.parseFrom(byteString, extensionRegistryLite);
    }

    public static KnnQuery parseFrom(byte[] byArray) throws InvalidProtocolBufferException {
        return (KnnQuery)PARSER.parseFrom(byArray);
    }

    public static KnnQuery parseFrom(byte[] byArray, ExtensionRegistryLite extensionRegistryLite) throws InvalidProtocolBufferException {
        return (KnnQuery)PARSER.parseFrom(byArray, extensionRegistryLite);
    }

    public static KnnQuery parseFrom(InputStream inputStream) throws IOException {
        return (KnnQuery)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)inputStream);
    }

    public static KnnQuery parseFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        return (KnnQuery)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)inputStream, (ExtensionRegistryLite)extensionRegistryLite);
    }

    public static KnnQuery parseDelimitedFrom(InputStream inputStream) throws IOException {
        return (KnnQuery)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)inputStream);
    }

    public static KnnQuery parseDelimitedFrom(InputStream inputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        return (KnnQuery)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)inputStream, (ExtensionRegistryLite)extensionRegistryLite);
    }

    public static KnnQuery parseFrom(CodedInputStream codedInputStream) throws IOException {
        return (KnnQuery)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)codedInputStream);
    }

    public static KnnQuery parseFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
        return (KnnQuery)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)codedInputStream, (ExtensionRegistryLite)extensionRegistryLite);
    }

    public Builder newBuilderForType() {
        return KnnQuery.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(KnnQuery knnQuery) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(knnQuery);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent builderParent) {
        Builder builder = new Builder(builderParent);
        return builder;
    }

    public static KnnQuery getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<KnnQuery> parser() {
        return PARSER;
    }

    public Parser<KnnQuery> getParserForType() {
        return PARSER;
    }

    public KnnQuery getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    static /* synthetic */ Internal.FloatList access$300() {
        return KnnQuery.emptyFloatList();
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements KnnQueryOrBuilder {
        private int bitField0_;
        private Object field_ = "";
        private Internal.FloatList vector_ = KnnQuery.access$300();
        private int k_;
        private float minScore_;
        private float maxDistance_;
        private QueryContainer filter_;
        private SingleFieldBuilderV3<QueryContainer, QueryContainer.Builder, QueryContainerOrBuilder> filterBuilder_;
        private float boost_;
        private Object xName_ = "";
        private ObjectMap methodParameters_;
        private SingleFieldBuilderV3<ObjectMap, ObjectMap.Builder, ObjectMapOrBuilder> methodParametersBuilder_;
        private KnnQueryRescore rescore_;
        private SingleFieldBuilderV3<KnnQueryRescore, KnnQueryRescore.Builder, KnnQueryRescoreOrBuilder> rescoreBuilder_;
        private boolean expandNestedDocs_;

        public static final Descriptors.Descriptor getDescriptor() {
            return CommonProto.internal_static_org_opensearch_protobufs_KnnQuery_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CommonProto.internal_static_org_opensearch_protobufs_KnnQuery_fieldAccessorTable.ensureFieldAccessorsInitialized(KnnQuery.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent builderParent) {
            super(builderParent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getFilterFieldBuilder();
                this.getMethodParametersFieldBuilder();
                this.getRescoreFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.field_ = "";
            this.vector_ = KnnQuery.emptyFloatList();
            this.k_ = 0;
            this.minScore_ = 0.0f;
            this.maxDistance_ = 0.0f;
            this.filter_ = null;
            if (this.filterBuilder_ != null) {
                this.filterBuilder_.dispose();
                this.filterBuilder_ = null;
            }
            this.boost_ = 0.0f;
            this.xName_ = "";
            this.methodParameters_ = null;
            if (this.methodParametersBuilder_ != null) {
                this.methodParametersBuilder_.dispose();
                this.methodParametersBuilder_ = null;
            }
            this.rescore_ = null;
            if (this.rescoreBuilder_ != null) {
                this.rescoreBuilder_.dispose();
                this.rescoreBuilder_ = null;
            }
            this.expandNestedDocs_ = false;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return CommonProto.internal_static_org_opensearch_protobufs_KnnQuery_descriptor;
        }

        public KnnQuery getDefaultInstanceForType() {
            return KnnQuery.getDefaultInstance();
        }

        public KnnQuery build() {
            KnnQuery knnQuery = this.buildPartial();
            if (!knnQuery.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)knnQuery);
            }
            return knnQuery;
        }

        public KnnQuery buildPartial() {
            KnnQuery knnQuery = new KnnQuery(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(knnQuery);
            }
            this.onBuilt();
            return knnQuery;
        }

        private void buildPartial0(KnnQuery knnQuery) {
            int n = this.bitField0_;
            if ((n & 1) != 0) {
                knnQuery.field_ = this.field_;
            }
            if ((n & 2) != 0) {
                this.vector_.makeImmutable();
                knnQuery.vector_ = this.vector_;
            }
            int n2 = 0;
            if ((n & 4) != 0) {
                knnQuery.k_ = this.k_;
                n2 |= 1;
            }
            if ((n & 8) != 0) {
                knnQuery.minScore_ = this.minScore_;
                n2 |= 2;
            }
            if ((n & 0x10) != 0) {
                knnQuery.maxDistance_ = this.maxDistance_;
                n2 |= 4;
            }
            if ((n & 0x20) != 0) {
                knnQuery.filter_ = this.filterBuilder_ == null ? this.filter_ : (QueryContainer)this.filterBuilder_.build();
                n2 |= 8;
            }
            if ((n & 0x40) != 0) {
                knnQuery.boost_ = this.boost_;
                n2 |= 0x10;
            }
            if ((n & 0x80) != 0) {
                knnQuery.xName_ = this.xName_;
                n2 |= 0x20;
            }
            if ((n & 0x100) != 0) {
                knnQuery.methodParameters_ = this.methodParametersBuilder_ == null ? this.methodParameters_ : (ObjectMap)this.methodParametersBuilder_.build();
                n2 |= 0x40;
            }
            if ((n & 0x200) != 0) {
                knnQuery.rescore_ = this.rescoreBuilder_ == null ? this.rescore_ : (KnnQueryRescore)this.rescoreBuilder_.build();
                n2 |= 0x80;
            }
            if ((n & 0x400) != 0) {
                knnQuery.expandNestedDocs_ = this.expandNestedDocs_;
                n2 |= 0x100;
            }
            knnQuery.bitField0_ |= n2;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
            return (Builder)super.setField(fieldDescriptor, object);
        }

        public Builder clearField(Descriptors.FieldDescriptor fieldDescriptor) {
            return (Builder)super.clearField(fieldDescriptor);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneofDescriptor) {
            return (Builder)super.clearOneof(oneofDescriptor);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, int n, Object object) {
            return (Builder)super.setRepeatedField(fieldDescriptor, n, object);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, Object object) {
            return (Builder)super.addRepeatedField(fieldDescriptor, object);
        }

        public Builder mergeFrom(Message message) {
            if (message instanceof KnnQuery) {
                return this.mergeFrom((KnnQuery)message);
            }
            super.mergeFrom(message);
            return this;
        }

        public Builder mergeFrom(KnnQuery knnQuery) {
            if (knnQuery == KnnQuery.getDefaultInstance()) {
                return this;
            }
            if (!knnQuery.getField().isEmpty()) {
                this.field_ = knnQuery.field_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!knnQuery.vector_.isEmpty()) {
                if (this.vector_.isEmpty()) {
                    this.vector_ = knnQuery.vector_;
                    this.vector_.makeImmutable();
                    this.bitField0_ |= 2;
                } else {
                    this.ensureVectorIsMutable();
                    this.vector_.addAll((Collection)knnQuery.vector_);
                }
                this.onChanged();
            }
            if (knnQuery.hasK()) {
                this.setK(knnQuery.getK());
            }
            if (knnQuery.hasMinScore()) {
                this.setMinScore(knnQuery.getMinScore());
            }
            if (knnQuery.hasMaxDistance()) {
                this.setMaxDistance(knnQuery.getMaxDistance());
            }
            if (knnQuery.hasFilter()) {
                this.mergeFilter(knnQuery.getFilter());
            }
            if (knnQuery.hasBoost()) {
                this.setBoost(knnQuery.getBoost());
            }
            if (knnQuery.hasXName()) {
                this.xName_ = knnQuery.xName_;
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            if (knnQuery.hasMethodParameters()) {
                this.mergeMethodParameters(knnQuery.getMethodParameters());
            }
            if (knnQuery.hasRescore()) {
                this.mergeRescore(knnQuery.getRescore());
            }
            if (knnQuery.hasExpandNestedDocs()) {
                this.setExpandNestedDocs(knnQuery.getExpandNestedDocs());
            }
            this.mergeUnknownFields(knnQuery.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream codedInputStream, ExtensionRegistryLite extensionRegistryLite) throws IOException {
            if (extensionRegistryLite == null) {
                throw new NullPointerException();
            }
            try {
                boolean bl = false;
                block20: while (!bl) {
                    int n = codedInputStream.readTag();
                    switch (n) {
                        case 0: {
                            bl = true;
                            continue block20;
                        }
                        case 10: {
                            this.field_ = codedInputStream.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block20;
                        }
                        case 21: {
                            float f = codedInputStream.readFloat();
                            this.ensureVectorIsMutable();
                            this.vector_.addFloat(f);
                            continue block20;
                        }
                        case 18: {
                            int n2 = codedInputStream.readRawVarint32();
                            int n3 = codedInputStream.pushLimit(n2);
                            int n4 = n2 > 4096 ? 4096 : n2;
                            this.ensureVectorIsMutable(n4 / 4);
                            while (codedInputStream.getBytesUntilLimit() > 0) {
                                this.vector_.addFloat(codedInputStream.readFloat());
                            }
                            codedInputStream.popLimit(n3);
                            continue block20;
                        }
                        case 24: {
                            this.k_ = codedInputStream.readInt32();
                            this.bitField0_ |= 4;
                            continue block20;
                        }
                        case 37: {
                            this.minScore_ = codedInputStream.readFloat();
                            this.bitField0_ |= 8;
                            continue block20;
                        }
                        case 45: {
                            this.maxDistance_ = codedInputStream.readFloat();
                            this.bitField0_ |= 0x10;
                            continue block20;
                        }
                        case 50: {
                            codedInputStream.readMessage((MessageLite.Builder)this.getFilterFieldBuilder().getBuilder(), extensionRegistryLite);
                            this.bitField0_ |= 0x20;
                            continue block20;
                        }
                        case 61: {
                            this.boost_ = codedInputStream.readFloat();
                            this.bitField0_ |= 0x40;
                            continue block20;
                        }
                        case 66: {
                            this.xName_ = codedInputStream.readStringRequireUtf8();
                            this.bitField0_ |= 0x80;
                            continue block20;
                        }
                        case 74: {
                            codedInputStream.readMessage((MessageLite.Builder)this.getMethodParametersFieldBuilder().getBuilder(), extensionRegistryLite);
                            this.bitField0_ |= 0x100;
                            continue block20;
                        }
                        case 82: {
                            codedInputStream.readMessage((MessageLite.Builder)this.getRescoreFieldBuilder().getBuilder(), extensionRegistryLite);
                            this.bitField0_ |= 0x200;
                            continue block20;
                        }
                        case 88: {
                            this.expandNestedDocs_ = codedInputStream.readBool();
                            this.bitField0_ |= 0x400;
                            continue block20;
                        }
                    }
                    if (super.parseUnknownField(codedInputStream, extensionRegistryLite, n)) continue;
                    bl = true;
                }
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                throw invalidProtocolBufferException.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getField() {
            Object object = this.field_;
            if (!(object instanceof String)) {
                ByteString byteString = (ByteString)object;
                String string = byteString.toStringUtf8();
                this.field_ = string;
                return string;
            }
            return (String)object;
        }

        @Override
        public ByteString getFieldBytes() {
            Object object = this.field_;
            if (object instanceof String) {
                ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
                this.field_ = byteString;
                return byteString;
            }
            return (ByteString)object;
        }

        public Builder setField(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.field_ = string;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearField() {
            this.field_ = KnnQuery.getDefaultInstance().getField();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setFieldBytes(ByteString byteString) {
            if (byteString == null) {
                throw new NullPointerException();
            }
            KnnQuery.checkByteStringIsUtf8((ByteString)byteString);
            this.field_ = byteString;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private void ensureVectorIsMutable() {
            if (!this.vector_.isModifiable()) {
                this.vector_ = (Internal.FloatList)KnnQuery.makeMutableCopy((Internal.ProtobufList)((Internal.ProtobufList)this.vector_));
            }
            this.bitField0_ |= 2;
        }

        private void ensureVectorIsMutable(int n) {
            if (!this.vector_.isModifiable()) {
                this.vector_ = (Internal.FloatList)KnnQuery.makeMutableCopy((Internal.ProtobufList)((Internal.ProtobufList)this.vector_), (int)n);
            }
            this.bitField0_ |= 2;
        }

        @Override
        public List<Float> getVectorList() {
            this.vector_.makeImmutable();
            return this.vector_;
        }

        @Override
        public int getVectorCount() {
            return this.vector_.size();
        }

        @Override
        public float getVector(int n) {
            return this.vector_.getFloat(n);
        }

        public Builder setVector(int n, float f) {
            this.ensureVectorIsMutable();
            this.vector_.setFloat(n, f);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder addVector(float f) {
            this.ensureVectorIsMutable();
            this.vector_.addFloat(f);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder addAllVector(Iterable<? extends Float> iterable) {
            this.ensureVectorIsMutable();
            AbstractMessageLite.Builder.addAll(iterable, (List)this.vector_);
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearVector() {
            this.vector_ = KnnQuery.emptyFloatList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasK() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public int getK() {
            return this.k_;
        }

        public Builder setK(int n) {
            this.k_ = n;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearK() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.k_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMinScore() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public float getMinScore() {
            return this.minScore_;
        }

        public Builder setMinScore(float f) {
            this.minScore_ = f;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearMinScore() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.minScore_ = 0.0f;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMaxDistance() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public float getMaxDistance() {
            return this.maxDistance_;
        }

        public Builder setMaxDistance(float f) {
            this.maxDistance_ = f;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearMaxDistance() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.maxDistance_ = 0.0f;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasFilter() {
            return (this.bitField0_ & 0x20) != 0;
        }

        @Override
        public QueryContainer getFilter() {
            if (this.filterBuilder_ == null) {
                return this.filter_ == null ? QueryContainer.getDefaultInstance() : this.filter_;
            }
            return (QueryContainer)this.filterBuilder_.getMessage();
        }

        public Builder setFilter(QueryContainer queryContainer) {
            if (this.filterBuilder_ == null) {
                if (queryContainer == null) {
                    throw new NullPointerException();
                }
                this.filter_ = queryContainer;
            } else {
                this.filterBuilder_.setMessage((AbstractMessage)queryContainer);
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder setFilter(QueryContainer.Builder builder) {
            if (this.filterBuilder_ == null) {
                this.filter_ = builder.build();
            } else {
                this.filterBuilder_.setMessage((AbstractMessage)builder.build());
            }
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder mergeFilter(QueryContainer queryContainer) {
            if (this.filterBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0 && this.filter_ != null && this.filter_ != QueryContainer.getDefaultInstance()) {
                    this.getFilterBuilder().mergeFrom(queryContainer);
                } else {
                    this.filter_ = queryContainer;
                }
            } else {
                this.filterBuilder_.mergeFrom((AbstractMessage)queryContainer);
            }
            if (this.filter_ != null) {
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            return this;
        }

        public Builder clearFilter() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.filter_ = null;
            if (this.filterBuilder_ != null) {
                this.filterBuilder_.dispose();
                this.filterBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public QueryContainer.Builder getFilterBuilder() {
            this.bitField0_ |= 0x20;
            this.onChanged();
            return (QueryContainer.Builder)this.getFilterFieldBuilder().getBuilder();
        }

        @Override
        public QueryContainerOrBuilder getFilterOrBuilder() {
            if (this.filterBuilder_ != null) {
                return (QueryContainerOrBuilder)this.filterBuilder_.getMessageOrBuilder();
            }
            return this.filter_ == null ? QueryContainer.getDefaultInstance() : this.filter_;
        }

        private SingleFieldBuilderV3<QueryContainer, QueryContainer.Builder, QueryContainerOrBuilder> getFilterFieldBuilder() {
            if (this.filterBuilder_ == null) {
                this.filterBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getFilter(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.filter_ = null;
            }
            return this.filterBuilder_;
        }

        @Override
        public boolean hasBoost() {
            return (this.bitField0_ & 0x40) != 0;
        }

        @Override
        public float getBoost() {
            return this.boost_;
        }

        public Builder setBoost(float f) {
            this.boost_ = f;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearBoost() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.boost_ = 0.0f;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasXName() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public String getXName() {
            Object object = this.xName_;
            if (!(object instanceof String)) {
                ByteString byteString = (ByteString)object;
                String string = byteString.toStringUtf8();
                this.xName_ = string;
                return string;
            }
            return (String)object;
        }

        @Override
        public ByteString getXNameBytes() {
            Object object = this.xName_;
            if (object instanceof String) {
                ByteString byteString = ByteString.copyFromUtf8((String)((String)object));
                this.xName_ = byteString;
                return byteString;
            }
            return (ByteString)object;
        }

        public Builder setXName(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            this.xName_ = string;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder clearXName() {
            this.xName_ = KnnQuery.getDefaultInstance().getXName();
            this.bitField0_ &= 0xFFFFFF7F;
            this.onChanged();
            return this;
        }

        public Builder setXNameBytes(ByteString byteString) {
            if (byteString == null) {
                throw new NullPointerException();
            }
            KnnQuery.checkByteStringIsUtf8((ByteString)byteString);
            this.xName_ = byteString;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMethodParameters() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public ObjectMap getMethodParameters() {
            if (this.methodParametersBuilder_ == null) {
                return this.methodParameters_ == null ? ObjectMap.getDefaultInstance() : this.methodParameters_;
            }
            return (ObjectMap)this.methodParametersBuilder_.getMessage();
        }

        public Builder setMethodParameters(ObjectMap objectMap) {
            if (this.methodParametersBuilder_ == null) {
                if (objectMap == null) {
                    throw new NullPointerException();
                }
                this.methodParameters_ = objectMap;
            } else {
                this.methodParametersBuilder_.setMessage((AbstractMessage)objectMap);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setMethodParameters(ObjectMap.Builder builder) {
            if (this.methodParametersBuilder_ == null) {
                this.methodParameters_ = builder.build();
            } else {
                this.methodParametersBuilder_.setMessage((AbstractMessage)builder.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeMethodParameters(ObjectMap objectMap) {
            if (this.methodParametersBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.methodParameters_ != null && this.methodParameters_ != ObjectMap.getDefaultInstance()) {
                    this.getMethodParametersBuilder().mergeFrom(objectMap);
                } else {
                    this.methodParameters_ = objectMap;
                }
            } else {
                this.methodParametersBuilder_.mergeFrom((AbstractMessage)objectMap);
            }
            if (this.methodParameters_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearMethodParameters() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.methodParameters_ = null;
            if (this.methodParametersBuilder_ != null) {
                this.methodParametersBuilder_.dispose();
                this.methodParametersBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public ObjectMap.Builder getMethodParametersBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (ObjectMap.Builder)this.getMethodParametersFieldBuilder().getBuilder();
        }

        @Override
        public ObjectMapOrBuilder getMethodParametersOrBuilder() {
            if (this.methodParametersBuilder_ != null) {
                return (ObjectMapOrBuilder)this.methodParametersBuilder_.getMessageOrBuilder();
            }
            return this.methodParameters_ == null ? ObjectMap.getDefaultInstance() : this.methodParameters_;
        }

        private SingleFieldBuilderV3<ObjectMap, ObjectMap.Builder, ObjectMapOrBuilder> getMethodParametersFieldBuilder() {
            if (this.methodParametersBuilder_ == null) {
                this.methodParametersBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMethodParameters(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.methodParameters_ = null;
            }
            return this.methodParametersBuilder_;
        }

        @Override
        public boolean hasRescore() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public KnnQueryRescore getRescore() {
            if (this.rescoreBuilder_ == null) {
                return this.rescore_ == null ? KnnQueryRescore.getDefaultInstance() : this.rescore_;
            }
            return (KnnQueryRescore)this.rescoreBuilder_.getMessage();
        }

        public Builder setRescore(KnnQueryRescore knnQueryRescore) {
            if (this.rescoreBuilder_ == null) {
                if (knnQueryRescore == null) {
                    throw new NullPointerException();
                }
                this.rescore_ = knnQueryRescore;
            } else {
                this.rescoreBuilder_.setMessage((AbstractMessage)knnQueryRescore);
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder setRescore(KnnQueryRescore.Builder builder) {
            if (this.rescoreBuilder_ == null) {
                this.rescore_ = builder.build();
            } else {
                this.rescoreBuilder_.setMessage((AbstractMessage)builder.build());
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder mergeRescore(KnnQueryRescore knnQueryRescore) {
            if (this.rescoreBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0 && this.rescore_ != null && this.rescore_ != KnnQueryRescore.getDefaultInstance()) {
                    this.getRescoreBuilder().mergeFrom(knnQueryRescore);
                } else {
                    this.rescore_ = knnQueryRescore;
                }
            } else {
                this.rescoreBuilder_.mergeFrom((AbstractMessage)knnQueryRescore);
            }
            if (this.rescore_ != null) {
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            return this;
        }

        public Builder clearRescore() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.rescore_ = null;
            if (this.rescoreBuilder_ != null) {
                this.rescoreBuilder_.dispose();
                this.rescoreBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public KnnQueryRescore.Builder getRescoreBuilder() {
            this.bitField0_ |= 0x200;
            this.onChanged();
            return (KnnQueryRescore.Builder)this.getRescoreFieldBuilder().getBuilder();
        }

        @Override
        public KnnQueryRescoreOrBuilder getRescoreOrBuilder() {
            if (this.rescoreBuilder_ != null) {
                return (KnnQueryRescoreOrBuilder)this.rescoreBuilder_.getMessageOrBuilder();
            }
            return this.rescore_ == null ? KnnQueryRescore.getDefaultInstance() : this.rescore_;
        }

        private SingleFieldBuilderV3<KnnQueryRescore, KnnQueryRescore.Builder, KnnQueryRescoreOrBuilder> getRescoreFieldBuilder() {
            if (this.rescoreBuilder_ == null) {
                this.rescoreBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRescore(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.rescore_ = null;
            }
            return this.rescoreBuilder_;
        }

        @Override
        public boolean hasExpandNestedDocs() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public boolean getExpandNestedDocs() {
            return this.expandNestedDocs_;
        }

        public Builder setExpandNestedDocs(boolean bl) {
            this.expandNestedDocs_ = bl;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearExpandNestedDocs() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.expandNestedDocs_ = false;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFieldSet) {
            return (Builder)super.setUnknownFields(unknownFieldSet);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFieldSet) {
            return (Builder)super.mergeUnknownFields(unknownFieldSet);
        }
    }
}

