/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.routing.RoutingPool;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.ValidationException;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.FeatureFlags;
import org.opensearch.core.index.Index;
import org.opensearch.index.IndexModule;
import org.opensearch.indices.SystemIndices;

public class ShardLimitValidator {
    public static final String SETTING_MAX_SHARDS_PER_CLUSTER_KEY = "cluster.routing.allocation.total_shards_limit";
    public static final Setting<Integer> SETTING_CLUSTER_MAX_SHARDS_PER_NODE = Setting.intSetting("cluster.max_shards_per_node", 1000, 1, (Setting.Validator<Integer>)new MaxShardPerNodeLimitValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_CLUSTER_MAX_SHARDS_PER_CLUSTER = Setting.intSetting("cluster.routing.allocation.total_shards_limit", -1, -1, (Setting.Validator<Integer>)new MaxShardPerClusterLimitValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_CLUSTER_MAX_REMOTE_CAPABLE_SHARDS_PER_NODE = Setting.intSetting("cluster.max_remote_capable_shards_per_node", 1000, 1, (Setting.Validator<Integer>)new MaxRemoteCapableShardPerNodeLimitValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_CLUSTER_MAX_REMOTE_CAPABLE_SHARDS_PER_CLUSTER = Setting.intSetting("cluster.routing.allocation.total_remote_capable_shards_limit", -1, -1, (Setting.Validator<Integer>)new MaxRemoteCapableShardPerClusterLimitValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_CLUSTER_IGNORE_DOT_INDEXES = Setting.boolSetting("cluster.ignore_dot_indexes", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    protected final AtomicInteger shardLimitPerNode = new AtomicInteger();
    protected final AtomicInteger shardLimitPerCluster = new AtomicInteger();
    protected final AtomicInteger remoteCapableShardLimitPerNode = new AtomicInteger();
    protected final AtomicInteger remoteCapableShardLimitPerCluster = new AtomicInteger();
    private final SystemIndices systemIndices;
    private volatile boolean ignoreDotIndexes;

    public ShardLimitValidator(Settings settings, ClusterService clusterService, SystemIndices systemIndices) {
        this.shardLimitPerNode.set(SETTING_CLUSTER_MAX_SHARDS_PER_NODE.get(settings));
        this.shardLimitPerCluster.set(SETTING_CLUSTER_MAX_SHARDS_PER_CLUSTER.get(settings));
        this.remoteCapableShardLimitPerNode.set(SETTING_CLUSTER_MAX_REMOTE_CAPABLE_SHARDS_PER_NODE.get(settings));
        this.remoteCapableShardLimitPerCluster.set(SETTING_CLUSTER_MAX_REMOTE_CAPABLE_SHARDS_PER_CLUSTER.get(settings));
        this.ignoreDotIndexes = SETTING_CLUSTER_IGNORE_DOT_INDEXES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SETTING_CLUSTER_MAX_SHARDS_PER_NODE, this::setShardLimitPerNode);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SETTING_CLUSTER_MAX_SHARDS_PER_CLUSTER, this::setShardLimitPerCluster);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SETTING_CLUSTER_MAX_REMOTE_CAPABLE_SHARDS_PER_NODE, this::setRemoteCapableShardShardLimitPerNode);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SETTING_CLUSTER_MAX_REMOTE_CAPABLE_SHARDS_PER_CLUSTER, this::setRemoteCapableShardShardLimitPerCluster);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SETTING_CLUSTER_IGNORE_DOT_INDEXES, this::setIgnoreDotIndexes);
        this.systemIndices = systemIndices;
    }

    private void setShardLimitPerNode(int newValue) {
        this.shardLimitPerNode.set(newValue);
    }

    private void setShardLimitPerCluster(int newValue) {
        this.shardLimitPerCluster.set(newValue);
    }

    private void setRemoteCapableShardShardLimitPerNode(int newValue) {
        this.remoteCapableShardLimitPerNode.set(newValue);
    }

    private void setRemoteCapableShardShardLimitPerCluster(int newValue) {
        this.remoteCapableShardLimitPerCluster.set(newValue);
    }

    public int getShardLimitPerNode() {
        return this.shardLimitPerNode.get();
    }

    public int getShardLimitPerCluster() {
        return this.shardLimitPerCluster.get();
    }

    public int getRemoteCapableShardLimitPerNode() {
        return this.remoteCapableShardLimitPerNode.get();
    }

    public int getRemoteCapableShardLimitPerCluster() {
        return this.remoteCapableShardLimitPerCluster.get();
    }

    private void setIgnoreDotIndexes(boolean newValue) {
        this.ignoreDotIndexes = newValue;
    }

    public void validateShardLimit(String indexName, Settings settings, ClusterState state) {
        RoutingPool shardRoutingPool;
        int numberOfReplicas;
        if (this.shouldIndexBeIgnored(indexName)) {
            return;
        }
        int numberOfShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(settings);
        int shardsToCreate = numberOfShards * (1 + (numberOfReplicas = IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(settings).intValue()));
        Optional<String> shardLimit = this.checkShardLimit(shardsToCreate, state, shardRoutingPool = ShardLimitValidator.getShardRoutingPool(settings));
        if (shardLimit.isPresent()) {
            ValidationException e = new ValidationException();
            e.addValidationError(shardLimit.get());
            throw e;
        }
    }

    public void validateShardLimit(ClusterState currentState, Index[] indicesToOpen) {
        Index[] filteredIndices = (Index[])Arrays.stream(indicesToOpen).filter(index -> !this.shouldIndexBeIgnored(index.getName())).filter(index -> currentState.metadata().index((Index)index).getState().equals((Object)IndexMetadata.State.CLOSE)).toArray(Index[]::new);
        if (filteredIndices.length > 0) {
            this.validateShardLimitForIndices(filteredIndices, currentState, index -> ShardLimitValidator.getTotalShardCount(currentState, index));
        }
    }

    private static int getTotalShardCount(ClusterState state, Index index) {
        IndexMetadata indexMetadata = state.metadata().index(index);
        return indexMetadata.getNumberOfShards() * (1 + indexMetadata.getNumberOfReplicas());
    }

    private boolean shouldIndexBeIgnored(String indexName) {
        if (this.ignoreDotIndexes) {
            return this.validateDotIndex(indexName) && !this.isDataStreamIndex(indexName);
        }
        return this.systemIndices.validateSystemIndex(indexName);
    }

    private boolean validateDotIndex(String indexName) {
        return indexName.charAt(0) == '.';
    }

    private boolean isDataStreamIndex(String indexName) {
        return indexName.startsWith(".ds-");
    }

    public void validateShardLimitForIndices(Index[] indices, ClusterState currentState, Function<Index, Integer> shardCalculator) throws ValidationException {
        Map<RoutingPool, Integer> shardCountByRoutingPool = Arrays.stream(indices).collect(Collectors.toMap(index -> RoutingPool.getIndexPool(currentState.metadata().index((Index)index)), shardCalculator, Integer::sum));
        ArrayList<String> violations = new ArrayList<String>();
        for (Map.Entry<RoutingPool, Integer> entry : shardCountByRoutingPool.entrySet()) {
            Optional<String> error = this.checkShardLimit(entry.getValue(), currentState, entry.getKey());
            if (!error.isPresent()) continue;
            violations.add(error.get());
        }
        if (!violations.isEmpty()) {
            ValidationException ex = new ValidationException();
            ex.addValidationErrors(violations);
            throw ex;
        }
    }

    public Optional<String> checkShardLimit(int newShards, ClusterState state, RoutingPool shardPool) {
        return shardPool == RoutingPool.REMOTE_CAPABLE ? ShardLimitValidator.checkShardLimit(newShards, state.getMetadata().getTotalOpenRemoteCapableIndexShards(), this.getRemoteCapableShardLimitPerNode(), this.getRemoteCapableShardLimitPerCluster(), state.getNodes().getWarmNodes().size(), shardPool) : ShardLimitValidator.checkShardLimit(newShards, state.getMetadata().getTotalOpenIndexShards(), this.getShardLimitPerNode(), this.getShardLimitPerCluster(), state.getNodes().getDataNodes().size(), shardPool);
    }

    static Optional<String> checkShardLimit(int newShards, long currentOpenShards, int maxShardsPerNodeSetting, int maxShardsPerClusterSetting, int nodeCount, RoutingPool shardPool) {
        if (nodeCount == 0 || newShards < 0) {
            return Optional.empty();
        }
        int computedMaxShards = (int)Math.min(Integer.MAX_VALUE, (long)maxShardsPerNodeSetting * (long)nodeCount);
        int maxShardsInCluster = maxShardsPerClusterSetting;
        maxShardsInCluster = maxShardsInCluster == -1 ? computedMaxShards : Math.min(maxShardsInCluster, computedMaxShards);
        if (currentOpenShards + (long)newShards > (long)maxShardsInCluster) {
            String errorMessage = "this action would add [" + newShards + "] total " + String.valueOf((Object)shardPool) + " shards, but this cluster currently has [" + currentOpenShards + "]/[" + maxShardsInCluster + "] maximum " + String.valueOf((Object)shardPool) + " shards open";
            return Optional.of(errorMessage);
        }
        return Optional.empty();
    }

    static RoutingPool getShardRoutingPool(Settings indexSettings) {
        Boolean isRemoteCapableIndex = IndexModule.Type.REMOTE_SNAPSHOT.match(indexSettings) || FeatureFlags.isEnabled("opensearch.experimental.feature.writable_warm_index.enabled") && indexSettings.getAsBoolean(IndexModule.IS_WARM_INDEX_SETTING.getKey(), false) != false;
        return isRemoteCapableIndex != false ? RoutingPool.REMOTE_CAPABLE : RoutingPool.LOCAL_ONLY;
    }

    private static void doValidate(int maxShardPerCluster, int maxShardPerNode) {
        if (maxShardPerCluster != -1 && maxShardPerCluster < maxShardPerNode) {
            throw new IllegalArgumentException("MaxShardPerCluster " + maxShardPerCluster + " should be greater than or equal to MaxShardPerNode " + maxShardPerNode);
        }
    }

    static final class MaxShardPerNodeLimitValidator
    implements Setting.Validator<Integer> {
        MaxShardPerNodeLimitValidator() {
        }

        @Override
        public void validate(Integer value) {
        }

        @Override
        public void validate(Integer maxShardPerNode, Map<Setting<?>, Object> settings) {
            int maxShardPerCluster = (Integer)settings.get(SETTING_CLUSTER_MAX_SHARDS_PER_CLUSTER);
            ShardLimitValidator.doValidate(maxShardPerCluster, maxShardPerNode);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<Integer>> settings = Collections.singletonList(SETTING_CLUSTER_MAX_SHARDS_PER_CLUSTER);
            return settings.iterator();
        }
    }

    static final class MaxShardPerClusterLimitValidator
    implements Setting.Validator<Integer> {
        MaxShardPerClusterLimitValidator() {
        }

        @Override
        public void validate(Integer value) {
        }

        @Override
        public void validate(Integer maxShardPerCluster, Map<Setting<?>, Object> settings) {
            int maxShardPerNode = (Integer)settings.get(SETTING_CLUSTER_MAX_SHARDS_PER_NODE);
            ShardLimitValidator.doValidate(maxShardPerCluster, maxShardPerNode);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<Integer>> settings = Collections.singletonList(SETTING_CLUSTER_MAX_SHARDS_PER_NODE);
            return settings.iterator();
        }
    }

    static final class MaxRemoteCapableShardPerNodeLimitValidator
    implements Setting.Validator<Integer> {
        MaxRemoteCapableShardPerNodeLimitValidator() {
        }

        @Override
        public void validate(Integer value) {
        }

        @Override
        public void validate(Integer maxShardPerNode, Map<Setting<?>, Object> settings) {
            int maxShardPerCluster = (Integer)settings.get(SETTING_CLUSTER_MAX_REMOTE_CAPABLE_SHARDS_PER_CLUSTER);
            ShardLimitValidator.doValidate(maxShardPerCluster, maxShardPerNode);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<Integer>> settings = Collections.singletonList(SETTING_CLUSTER_MAX_REMOTE_CAPABLE_SHARDS_PER_CLUSTER);
            return settings.iterator();
        }
    }

    static final class MaxRemoteCapableShardPerClusterLimitValidator
    implements Setting.Validator<Integer> {
        MaxRemoteCapableShardPerClusterLimitValidator() {
        }

        @Override
        public void validate(Integer value) {
        }

        @Override
        public void validate(Integer maxShardPerCluster, Map<Setting<?>, Object> settings) {
            int maxShardPerNode = (Integer)settings.get(SETTING_CLUSTER_MAX_REMOTE_CAPABLE_SHARDS_PER_NODE);
            ShardLimitValidator.doValidate(maxShardPerCluster, maxShardPerNode);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<Integer>> settings = Collections.singletonList(SETTING_CLUSTER_MAX_REMOTE_CAPABLE_SHARDS_PER_NODE);
            return settings.iterator();
        }
    }
}

