/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.FilterMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;

public class CriteriaBasedMergePolicy
extends FilterMergePolicy {
    protected final MergePolicy in;

    public CriteriaBasedMergePolicy(MergePolicy in) {
        super(in);
        this.in = in;
    }

    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos infos, MergePolicy.MergeContext mergeContext) throws IOException {
        Set merging = mergeContext.getMergingSegments();
        MergePolicy.MergeSpecification spec = null;
        HashMap<String, List> commitInfos = new HashMap<String, List>();
        for (SegmentCommitInfo si : infos) {
            if (merging.contains(si)) continue;
            String dwptGroupNumber = si.info.getAttribute("bucket");
            commitInfos.computeIfAbsent(dwptGroupNumber, k -> new ArrayList()).add(si);
        }
        for (String dwptGroupNumber : commitInfos.keySet()) {
            if (((List)commitInfos.get(dwptGroupNumber)).size() <= 1) continue;
            SegmentInfos newSIS = new SegmentInfos(infos.getIndexCreatedVersionMajor());
            for (SegmentCommitInfo info : (List)commitInfos.get(dwptGroupNumber)) {
                newSIS.add(info);
            }
            MergePolicy.MergeSpecification tieredMergePolicySpec = this.in.findMerges(mergeTrigger, newSIS, mergeContext);
            if (tieredMergePolicySpec == null) continue;
            if (spec == null) {
                spec = new MergePolicy.MergeSpecification();
            }
            spec.merges.addAll(tieredMergePolicySpec.merges);
        }
        return spec;
    }
}

