/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.DiffableStringMap;
import org.opensearch.common.io.Streams;
import org.opensearch.common.remote.AbstractClusterMetadataWriteableBlobEntity;
import org.opensearch.common.remote.BlobPathParameters;
import org.opensearch.core.compress.Compressor;
import org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.opensearch.index.remote.RemoteStoreUtils;
import org.opensearch.repositories.blobstore.ChecksumWritableBlobStoreFormat;

public class RemoteHashesOfConsistentSettings
extends AbstractClusterMetadataWriteableBlobEntity<DiffableStringMap> {
    public static final String HASHES_OF_CONSISTENT_SETTINGS = "hashes-of-consistent-settings";
    public final ChecksumWritableBlobStoreFormat<DiffableStringMap> hashesOfConsistentSettingsFormat;
    private DiffableStringMap hashesOfConsistentSettings;
    private long metadataVersion;

    public RemoteHashesOfConsistentSettings(DiffableStringMap hashesOfConsistentSettings, long metadataVersion, String clusterUUID, Compressor compressor) {
        super(clusterUUID, compressor, null);
        this.metadataVersion = metadataVersion;
        this.hashesOfConsistentSettings = hashesOfConsistentSettings;
        this.hashesOfConsistentSettingsFormat = new ChecksumWritableBlobStoreFormat(HASHES_OF_CONSISTENT_SETTINGS, DiffableStringMap::readFrom);
    }

    public RemoteHashesOfConsistentSettings(String blobName, String clusterUUID, Compressor compressor, Version version) {
        super(clusterUUID, compressor, null);
        this.blobName = blobName;
        this.hashesOfConsistentSettingsFormat = new ChecksumWritableBlobStoreFormat(HASHES_OF_CONSISTENT_SETTINGS, DiffableStringMap::readFrom, version);
    }

    @Override
    public BlobPathParameters getBlobPathParameters() {
        return new BlobPathParameters(List.of("global-metadata"), HASHES_OF_CONSISTENT_SETTINGS);
    }

    @Override
    public String getType() {
        return HASHES_OF_CONSISTENT_SETTINGS;
    }

    @Override
    public String generateBlobFileName() {
        String blobFileName;
        this.blobFileName = blobFileName = String.join((CharSequence)"__", this.getBlobPathParameters().getFilePrefix(), RemoteStoreUtils.invertLong(this.metadataVersion), RemoteStoreUtils.invertLong(System.currentTimeMillis()), String.valueOf(1));
        return blobFileName;
    }

    @Override
    public ClusterMetadataManifest.UploadedMetadata getUploadedMetadata() {
        assert (this.blobName != null);
        return new ClusterMetadataManifest.UploadedMetadataAttribute(HASHES_OF_CONSISTENT_SETTINGS, this.blobName);
    }

    @Override
    public InputStream serialize() throws IOException {
        return this.hashesOfConsistentSettingsFormat.serialize(this.hashesOfConsistentSettings, this.generateBlobFileName(), this.getCompressor()).streamInput();
    }

    @Override
    public DiffableStringMap deserialize(InputStream inputStream) throws IOException {
        return this.hashesOfConsistentSettingsFormat.deserialize(this.blobName, Streams.readFully(inputStream));
    }
}

