/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.painless;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.runtime.SwitchBootstraps;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.painless.DefBootstrap;
import org.opensearch.painless.FunctionRef;
import org.opensearch.painless.LambdaBootstrap;
import org.opensearch.painless.Utility;
import org.opensearch.painless.lookup.PainlessLookup;
import org.opensearch.painless.lookup.PainlessLookupUtility;
import org.opensearch.painless.lookup.PainlessMethod;
import org.opensearch.painless.symbol.FunctionTable;

public final class Def {
    private static final MethodHandle MAP_GET;
    private static final MethodHandle MAP_PUT;
    private static final MethodHandle LIST_GET;
    private static final MethodHandle LIST_SET;
    private static final MethodHandle ITERATOR;
    private static final MethodHandle MAP_INDEX_NORMALIZE;
    private static final MethodHandle LIST_INDEX_NORMALIZE;
    static final MethodHandle JAVA9_ARRAY_LENGTH_MH_FACTORY;

    static <T extends Throwable> void rethrow(Throwable t) throws T {
        throw t;
    }

    static MethodHandle arrayLengthGetter(Class<?> arrayType) {
        if (JAVA9_ARRAY_LENGTH_MH_FACTORY != null) {
            try {
                return JAVA9_ARRAY_LENGTH_MH_FACTORY.invokeExact(arrayType);
            }
            catch (Throwable t) {
                Def.rethrow(t);
                throw new AssertionError((Object)t);
            }
        }
        return ArrayLengthHelper.arrayLengthGetter(arrayType);
    }

    static MethodHandle lookupMethod(PainlessLookup painlessLookup, FunctionTable functions, Map<String, Object> constants, MethodHandles.Lookup methodHandlesLookup, MethodType callSiteType, Class<?> receiverClass, String name, Object[] args) throws Throwable {
        String recipeString = (String)args[0];
        int numArguments = callSiteType.parameterCount();
        if (recipeString.isEmpty()) {
            PainlessMethod painlessMethod = painlessLookup.lookupRuntimePainlessMethod(receiverClass, name, numArguments - 1);
            if (painlessMethod == null) {
                throw new IllegalArgumentException("dynamic method [" + PainlessLookupUtility.typeToCanonicalTypeName(receiverClass) + ", " + name + "/" + (numArguments - 1) + "] not found");
            }
            MethodHandle handle = painlessMethod.methodHandle;
            Object[] injections = PainlessLookupUtility.buildInjections(painlessMethod, constants);
            if (injections.length > 0) {
                handle = MethodHandles.insertArguments(handle, 1, injections);
            }
            return handle;
        }
        BitSet lambdaArgs = new BitSet(recipeString.length());
        for (int i = 0; i < recipeString.length(); ++i) {
            lambdaArgs.set(recipeString.charAt(i));
        }
        int arity = callSiteType.parameterCount() - 1;
        int upTo = 1;
        for (int i = 1; i < numArguments; ++i) {
            if (!lambdaArgs.get(i - 1)) continue;
            String signature = (String)args[upTo++];
            int numCaptures = Integer.parseInt(signature.substring(signature.indexOf(44) + 1));
            arity -= numCaptures;
        }
        PainlessMethod method = painlessLookup.lookupRuntimePainlessMethod(receiverClass, name, arity);
        if (method == null) {
            throw new IllegalArgumentException("dynamic method [" + PainlessLookupUtility.typeToCanonicalTypeName(receiverClass) + ", " + name + "/" + arity + "] not found");
        }
        MethodHandle handle = method.methodHandle;
        Object[] injections = PainlessLookupUtility.buildInjections(method, constants);
        if (injections.length > 0) {
            handle = MethodHandles.insertArguments(handle, 1, injections);
        }
        int replaced = 0;
        upTo = 1;
        for (int i = 1; i < numArguments; ++i) {
            MethodHandle filter;
            if (!lambdaArgs.get(i - 1)) continue;
            String signature = (String)args[upTo++];
            int separator = signature.lastIndexOf(46);
            int separator2 = signature.indexOf(44);
            String type = signature.substring(1, separator);
            String call = signature.substring(separator + 1, separator2);
            int numCaptures = Integer.parseInt(signature.substring(separator2 + 1));
            Class<?> interfaceType = method.typeParameters.get(i - 1 - replaced);
            if (signature.charAt(0) == 'S') {
                filter = Def.lookupReferenceInternal(painlessLookup, functions, constants, methodHandlesLookup, interfaceType, type, call, numCaptures);
            } else if (signature.charAt(0) == 'D') {
                Class[] captures = new Class[numCaptures];
                for (int capture = 0; capture < captures.length; ++capture) {
                    captures[capture] = callSiteType.parameterType(i + 1 + capture);
                }
                MethodType nestedType = MethodType.methodType(interfaceType, captures);
                CallSite nested = DefBootstrap.bootstrap(painlessLookup, functions, constants, methodHandlesLookup, call, nestedType, 0, 6, PainlessLookupUtility.typeToCanonicalTypeName(interfaceType));
                filter = nested.dynamicInvoker();
            } else {
                throw new AssertionError();
            }
            filter = MethodHandles.dropArguments(filter, 0, new Class[]{String.class});
            handle = MethodHandles.collectArguments(handle, i, filter);
            i += numCaptures;
            replaced += numCaptures;
        }
        return handle;
    }

    static MethodHandle lookupReference(PainlessLookup painlessLookup, FunctionTable functions, Map<String, Object> constants, MethodHandles.Lookup methodHandlesLookup, String interfaceClass, Class<?> receiverClass, String name) throws Throwable {
        Class<?> interfaceType = painlessLookup.canonicalTypeNameToType(interfaceClass);
        if (interfaceType == null) {
            throw new IllegalArgumentException("type [" + interfaceClass + "] not found");
        }
        PainlessMethod interfaceMethod = painlessLookup.lookupFunctionalInterfacePainlessMethod(interfaceType);
        if (interfaceMethod == null) {
            throw new IllegalArgumentException("Class [" + interfaceClass + "] is not a functional interface");
        }
        int arity = interfaceMethod.typeParameters.size();
        PainlessMethod implMethod = painlessLookup.lookupRuntimePainlessMethod(receiverClass, name, arity);
        if (implMethod == null) {
            throw new IllegalArgumentException("dynamic method [" + PainlessLookupUtility.typeToCanonicalTypeName(receiverClass) + ", " + name + "/" + arity + "] not found");
        }
        return Def.lookupReferenceInternal(painlessLookup, functions, constants, methodHandlesLookup, interfaceType, PainlessLookupUtility.typeToCanonicalTypeName(implMethod.targetClass), implMethod.javaMethod.getName(), 1);
    }

    private static MethodHandle lookupReferenceInternal(PainlessLookup painlessLookup, FunctionTable functions, Map<String, Object> constants, MethodHandles.Lookup methodHandlesLookup, Class<?> clazz, String type, String call, int captures) throws Throwable {
        FunctionRef ref = FunctionRef.create(painlessLookup, functions, null, clazz, type, call, captures, constants);
        CallSite callSite = LambdaBootstrap.lambdaBootstrap(methodHandlesLookup, ref.interfaceMethodName, ref.factoryMethodType, ref.interfaceMethodType, ref.delegateClassName, ref.delegateInvokeType, ref.delegateMethodName, ref.delegateMethodType, ref.isDelegateInterface ? 1 : 0, ref.isDelegateAugmented ? 1 : 0, ref.delegateInjections);
        return callSite.dynamicInvoker().asType(MethodType.methodType(clazz, ref.factoryMethodType.parameterArray()));
    }

    static MethodHandle lookupGetter(PainlessLookup painlessLookup, Class<?> receiverClass, String name) {
        MethodHandle getter = painlessLookup.lookupRuntimeGetterMethodHandle(receiverClass, name);
        if (getter != null) {
            return getter;
        }
        if (receiverClass.isArray() && "length".equals(name)) {
            return Def.arrayLengthGetter(receiverClass);
        }
        if (Map.class.isAssignableFrom(receiverClass)) {
            return MethodHandles.insertArguments(MAP_GET, 1, name);
        }
        if (List.class.isAssignableFrom(receiverClass)) {
            try {
                int index = Integer.parseInt(name);
                return MethodHandles.insertArguments(LIST_GET, 1, index);
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException("Illegal list shortcut value [" + name + "].");
            }
        }
        throw new IllegalArgumentException("dynamic getter [" + PainlessLookupUtility.typeToCanonicalTypeName(receiverClass) + ", " + name + "] not found");
    }

    static MethodHandle lookupSetter(PainlessLookup painlessLookup, Class<?> receiverClass, String name) {
        MethodHandle setter = painlessLookup.lookupRuntimeSetterMethodHandle(receiverClass, name);
        if (setter != null) {
            return setter;
        }
        if (Map.class.isAssignableFrom(receiverClass)) {
            return MethodHandles.insertArguments(MAP_PUT, 1, name);
        }
        if (List.class.isAssignableFrom(receiverClass)) {
            try {
                int index = Integer.parseInt(name);
                return MethodHandles.insertArguments(LIST_SET, 1, index);
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException("Illegal list shortcut value [" + name + "].");
            }
        }
        throw new IllegalArgumentException("dynamic setter [" + PainlessLookupUtility.typeToCanonicalTypeName(receiverClass) + ", " + name + "] not found");
    }

    static MethodHandle lookupIndexNormalize(Class<?> receiverClass) {
        if (receiverClass.isArray()) {
            return ArrayIndexNormalizeHelper.arrayIndexNormalizer(receiverClass);
        }
        if (Map.class.isAssignableFrom(receiverClass)) {
            return MAP_INDEX_NORMALIZE;
        }
        if (List.class.isAssignableFrom(receiverClass)) {
            return LIST_INDEX_NORMALIZE;
        }
        throw new IllegalArgumentException("Attempting to address a non-array-like type [" + receiverClass.getCanonicalName() + "] as an array.");
    }

    static MethodHandle lookupArrayStore(Class<?> receiverClass) {
        if (receiverClass.isArray()) {
            return MethodHandles.arrayElementSetter(receiverClass);
        }
        if (Map.class.isAssignableFrom(receiverClass)) {
            return MAP_PUT;
        }
        if (List.class.isAssignableFrom(receiverClass)) {
            return LIST_SET;
        }
        throw new IllegalArgumentException("Attempting to address a non-array type [" + receiverClass.getCanonicalName() + "] as an array.");
    }

    static MethodHandle lookupArrayLoad(Class<?> receiverClass) {
        if (receiverClass.isArray()) {
            return MethodHandles.arrayElementGetter(receiverClass);
        }
        if (Map.class.isAssignableFrom(receiverClass)) {
            return MAP_GET;
        }
        if (List.class.isAssignableFrom(receiverClass)) {
            return LIST_GET;
        }
        throw new IllegalArgumentException("Attempting to address a non-array type [" + receiverClass.getCanonicalName() + "] as an array.");
    }

    static MethodHandle lookupIterator(Class<?> receiverClass) {
        if (Iterable.class.isAssignableFrom(receiverClass)) {
            return ITERATOR;
        }
        if (receiverClass.isArray()) {
            return ArrayIteratorHelper.newIterator(receiverClass);
        }
        throw new IllegalArgumentException("Cannot iterate over [" + receiverClass.getCanonicalName() + "]");
    }

    public static boolean defToboolean(Object value) {
        if (value instanceof Boolean) {
            Boolean boolValue = (Boolean)value;
            return boolValue;
        }
        throw new ClassCastException("cannot cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Boolean.TYPE.getCanonicalName());
    }

    public static byte defTobyteImplicit(Object value) {
        if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            return byteValue;
        }
        throw new ClassCastException("cannot implicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Byte.TYPE.getCanonicalName());
    }

    public static short defToshortImplicit(Object value) {
        if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            return byteValue.byteValue();
        }
        if (value instanceof Short) {
            Short shortValue = (Short)value;
            return shortValue;
        }
        throw new ClassCastException("cannot implicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Short.TYPE.getCanonicalName());
    }

    public static char defTocharImplicit(Object value) {
        if (value instanceof Character) {
            Character charValue = (Character)value;
            return charValue.charValue();
        }
        throw new ClassCastException("cannot implicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Character.TYPE.getCanonicalName());
    }

    public static int defTointImplicit(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Character.class, Integer.class}, (Object)object2, n)) {
            case 0 -> {
                Byte byteValue = (Byte)object2;
                yield byteValue.byteValue();
            }
            case 1 -> {
                Short shortValue = (Short)object2;
                yield shortValue;
            }
            case 2 -> {
                Character charValue = (Character)object2;
                yield (short)charValue.charValue();
            }
            case 3 -> {
                Integer intValue = (Integer)object2;
                yield (short)intValue.intValue();
            }
            default -> throw new ClassCastException("cannot implicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Integer.TYPE.getCanonicalName());
        };
    }

    public static long defTolongImplicit(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Character.class, Integer.class, Long.class}, (Object)object2, n)) {
            case 0 -> {
                Byte byteValue = (Byte)object2;
                yield byteValue.byteValue();
            }
            case 1 -> {
                Short shortValue = (Short)object2;
                yield shortValue.shortValue();
            }
            case 2 -> {
                Character charValue = (Character)object2;
                yield charValue.charValue();
            }
            case 3 -> {
                Integer intValue = (Integer)object2;
                yield intValue.intValue();
            }
            case 4 -> {
                Long longValue = (Long)object2;
                yield longValue;
            }
            default -> throw new ClassCastException("cannot implicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Long.TYPE.getCanonicalName());
        };
    }

    public static float defTofloatImplicit(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class}, (Object)object2, n)) {
            case 0 -> {
                Byte byteValue = (Byte)object2;
                yield byteValue.byteValue();
            }
            case 1 -> {
                Short shortValue = (Short)object2;
                yield shortValue.shortValue();
            }
            case 2 -> {
                Character charValue = (Character)object2;
                yield charValue.charValue();
            }
            case 3 -> {
                Integer intValue = (Integer)object2;
                yield intValue.intValue();
            }
            case 4 -> {
                Long longValue = (Long)object2;
                yield longValue.longValue();
            }
            case 5 -> {
                Float floatValue = (Float)object2;
                yield floatValue.floatValue();
            }
            default -> throw new ClassCastException("cannot implicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Float.TYPE.getCanonicalName());
        };
    }

    public static double defTodoubleImplicit(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class}, (Object)object2, n)) {
            case 0 -> {
                Byte byteValue = (Byte)object2;
                yield byteValue.byteValue();
            }
            case 1 -> {
                Short shortValue = (Short)object2;
                yield shortValue.shortValue();
            }
            case 2 -> {
                Character charValue = (Character)object2;
                yield charValue.charValue();
            }
            case 3 -> {
                Integer intValue = (Integer)object2;
                yield intValue.intValue();
            }
            case 4 -> {
                Long longValue = (Long)object2;
                yield longValue.longValue();
            }
            case 5 -> {
                Float floatValue = (Float)object2;
                yield floatValue.floatValue();
            }
            case 6 -> {
                Double doubleValue = (Double)object2;
                yield doubleValue;
            }
            default -> throw new ClassCastException("cannot implicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Double.TYPE.getCanonicalName());
        };
    }

    public static byte defTobyteExplicit(Object value) {
        if (value instanceof Character) {
            return (byte)((Character)value).charValue();
        }
        if (Def.isNumber(value)) {
            return ((Number)value).byteValue();
        }
        throw new ClassCastException("cannot explicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Byte.TYPE.getCanonicalName());
    }

    public static short defToshortExplicit(Object value) {
        if (value instanceof Character) {
            return (short)((Character)value).charValue();
        }
        if (Def.isNumber(value)) {
            return ((Number)value).shortValue();
        }
        throw new ClassCastException("cannot explicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Short.TYPE.getCanonicalName());
    }

    public static char defTocharExplicit(Object value) {
        if (value instanceof String) {
            String stringValue = (String)value;
            return Utility.StringTochar(stringValue);
        }
        if (value instanceof Character) {
            Character charValue = (Character)value;
            return charValue.charValue();
        }
        if (Def.isNumber(value)) {
            return (char)((Number)value).intValue();
        }
        throw new ClassCastException("cannot explicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Character.TYPE.getCanonicalName());
    }

    public static int defTointExplicit(Object value) {
        if (value instanceof Character) {
            Character charValue = (Character)value;
            return charValue.charValue();
        }
        if (Def.isNumber(value)) {
            return ((Number)value).intValue();
        }
        throw new ClassCastException("cannot explicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Integer.TYPE.getCanonicalName());
    }

    public static long defTolongExplicit(Object value) {
        if (value instanceof Character) {
            Character charValue = (Character)value;
            return charValue.charValue();
        }
        if (Def.isNumber(value)) {
            return ((Number)value).longValue();
        }
        throw new ClassCastException("cannot explicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Long.TYPE.getCanonicalName());
    }

    public static float defTofloatExplicit(Object value) {
        if (value instanceof Character) {
            Character charValue = (Character)value;
            return charValue.charValue();
        }
        if (Def.isNumber(value)) {
            return ((Number)value).floatValue();
        }
        throw new ClassCastException("cannot explicitly cast float [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Byte.TYPE.getCanonicalName());
    }

    public static double defTodoubleExplicit(Object value) {
        if (value instanceof Character) {
            Character charValue = (Character)value;
            return charValue.charValue();
        }
        if (Def.isNumber(value)) {
            return ((Number)value).doubleValue();
        }
        throw new ClassCastException("cannot explicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Byte.TYPE.getCanonicalName());
    }

    public static Boolean defToBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            Boolean boolValue = (Boolean)value;
            return boolValue;
        }
        throw new ClassCastException("cannot implicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Boolean.class.getCanonicalName());
    }

    public static Byte defToByteImplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            return byteValue;
        }
        throw new ClassCastException("cannot implicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Byte.class.getCanonicalName());
    }

    public static Short defToShortImplicit(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                Byte b = (Byte)object;
                yield (short)b;
            }
            case 1 -> {
                Short i;
                yield i = (Short)object;
            }
            default -> throw new ClassCastException("cannot implicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Short.class.getCanonicalName());
        };
    }

    public static Character defToCharacterImplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            Character charValue = (Character)value;
            return charValue;
        }
        throw new ClassCastException("cannot implicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Character.class.getCanonicalName());
    }

    public static Integer defToIntegerImplicit(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Character.class, Integer.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                Byte b = (Byte)object;
                yield (int)b;
            }
            case 1 -> {
                Short i = (Short)object;
                yield (int)i;
            }
            case 2 -> {
                Character c = (Character)object;
                yield c.charValue();
            }
            case 3 -> {
                Integer i;
                yield i = (Integer)object;
            }
            default -> throw new ClassCastException("cannot implicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Integer.class.getCanonicalName());
        };
    }

    public static Long defToLongImplicit(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Character.class, Integer.class, Long.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                Byte b = (Byte)object;
                yield (long)b;
            }
            case 1 -> {
                Short i = (Short)object;
                yield (long)i;
            }
            case 2 -> {
                Character c = (Character)object;
                yield c.charValue();
            }
            case 3 -> {
                Integer i = (Integer)object;
                yield (long)i;
            }
            case 4 -> {
                Long l;
                yield l = (Long)object;
            }
            default -> throw new ClassCastException("cannot implicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Long.class.getCanonicalName());
        };
    }

    public static Float defToFloatImplicit(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                Byte b = (Byte)object;
                yield Float.valueOf(b.byteValue());
            }
            case 1 -> {
                Short i = (Short)object;
                yield Float.valueOf(i.shortValue());
            }
            case 2 -> {
                Character c = (Character)object;
                yield Float.valueOf(c.charValue());
            }
            case 3 -> {
                Integer i = (Integer)object;
                yield Float.valueOf(i.intValue());
            }
            case 4 -> {
                Long l = (Long)object;
                yield Float.valueOf(l.longValue());
            }
            case 5 -> {
                Float v;
                yield v = (Float)object;
            }
            default -> throw new ClassCastException("cannot implicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Float.class.getCanonicalName());
        };
    }

    public static Double defToDoubleImplicit(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                Byte b = (Byte)object;
                yield (double)b;
            }
            case 1 -> {
                Short i = (Short)object;
                yield (double)i;
            }
            case 2 -> {
                Character c = (Character)object;
                yield c.charValue();
            }
            case 3 -> {
                Integer i = (Integer)object;
                yield (double)i;
            }
            case 4 -> {
                Long l = (Long)object;
                yield (double)l;
            }
            case 5 -> {
                Float v = (Float)object;
                yield v.floatValue();
            }
            case 6 -> {
                Double v;
                yield v = (Double)object;
            }
            default -> throw new ClassCastException("cannot implicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Double.class.getCanonicalName());
        };
    }

    public static Byte defToByteExplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (byte)((Character)value).charValue();
        }
        if (Def.isNumber(value)) {
            return ((Number)value).byteValue();
        }
        throw new ClassCastException("cannot explicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Byte.class.getCanonicalName());
    }

    public static Short defToShortExplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (short)((Character)value).charValue();
        }
        if (Def.isNumber(value)) {
            return ((Number)value).shortValue();
        }
        throw new ClassCastException("cannot explicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Short.class.getCanonicalName());
    }

    public static Character defToCharacterExplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            return Character.valueOf(Utility.StringTochar(stringValue));
        }
        if (value instanceof Character) {
            Character charValue = (Character)value;
            return charValue;
        }
        if (Def.isNumber(value)) {
            return Character.valueOf((char)((Number)value).intValue());
        }
        throw new ClassCastException("cannot explicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Character.class.getCanonicalName());
    }

    public static Integer defToIntegerExplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (Def.isNumber(value)) {
            return ((Number)value).intValue();
        }
        throw new ClassCastException("cannot explicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Integer.class.getCanonicalName());
    }

    public static Long defToLongExplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (Def.isNumber(value)) {
            return ((Number)value).longValue();
        }
        throw new ClassCastException("cannot explicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Long.class.getCanonicalName());
    }

    public static Float defToFloatExplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return Float.valueOf(((Character)value).charValue());
        }
        if (Def.isNumber(value)) {
            return Float.valueOf(((Number)value).floatValue());
        }
        throw new ClassCastException("cannot explicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Float.class.getCanonicalName());
    }

    public static Double defToDoubleExplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (Def.isNumber(value)) {
            return ((Number)value).doubleValue();
        }
        throw new ClassCastException("cannot explicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + Double.class.getCanonicalName());
    }

    public static String defToStringImplicit(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            return stringValue;
        }
        throw new ClassCastException("cannot implicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + String.class.getCanonicalName());
    }

    public static String defToStringExplicit(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Character.class, String.class}, (Object)object, n)) {
            case -1 -> null;
            case 0 -> {
                Character charValue = (Character)object;
                yield Utility.charToString(charValue.charValue());
            }
            case 1 -> {
                String stringValue;
                yield stringValue = (String)object;
            }
            default -> throw new ClassCastException("cannot explicitly cast def [" + PainlessLookupUtility.typeToUnboxedType(value.getClass()).getCanonicalName() + "] to " + String.class.getCanonicalName());
        };
    }

    public static Object mapIndexNormalize(Map<?, ?> value, Object index) {
        return index;
    }

    public static int listIndexNormalize(List<?> value, int index) {
        return index >= 0 ? index : value.size() + index;
    }

    private static boolean isNumber(Object value) {
        return value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double;
    }

    static {
        MethodHandle arrayLengthMHFactory;
        MethodHandles.Lookup methodHandlesLookup = MethodHandles.publicLookup();
        try {
            MAP_GET = methodHandlesLookup.findVirtual(Map.class, "get", MethodType.methodType(Object.class, Object.class));
            MAP_PUT = methodHandlesLookup.findVirtual(Map.class, "put", MethodType.methodType(Object.class, Object.class, Object.class));
            LIST_GET = methodHandlesLookup.findVirtual(List.class, "get", MethodType.methodType(Object.class, Integer.TYPE));
            LIST_SET = methodHandlesLookup.findVirtual(List.class, "set", MethodType.methodType(Object.class, Integer.TYPE, Object.class));
            ITERATOR = methodHandlesLookup.findVirtual(Iterable.class, "iterator", MethodType.methodType(Iterator.class));
            MAP_INDEX_NORMALIZE = methodHandlesLookup.findStatic(Def.class, "mapIndexNormalize", MethodType.methodType(Object.class, Map.class, Object.class));
            LIST_INDEX_NORMALIZE = methodHandlesLookup.findStatic(Def.class, "listIndexNormalize", MethodType.methodType(Integer.TYPE, List.class, Integer.TYPE));
        }
        catch (ReflectiveOperationException roe) {
            throw new AssertionError((Object)roe);
        }
        try {
            arrayLengthMHFactory = methodHandlesLookup.findStatic(MethodHandles.class, "arrayLength", MethodType.methodType(MethodHandle.class, Class.class));
        }
        catch (ReflectiveOperationException roe) {
            arrayLengthMHFactory = null;
        }
        JAVA9_ARRAY_LENGTH_MH_FACTORY = arrayLengthMHFactory;
    }

    private static final class ArrayLengthHelper {
        private static final MethodHandles.Lookup PRIVATE_METHOD_HANDLES_LOOKUP = MethodHandles.lookup();
        private static final Map<Class<?>, MethodHandle> ARRAY_TYPE_MH_MAPPING = Collections.unmodifiableMap(Stream.of(boolean[].class, byte[].class, short[].class, int[].class, long[].class, char[].class, float[].class, double[].class, Object[].class).collect(Collectors.toMap(Function.identity(), type -> {
            try {
                return PRIVATE_METHOD_HANDLES_LOOKUP.findStatic(PRIVATE_METHOD_HANDLES_LOOKUP.lookupClass(), "getArrayLength", MethodType.methodType(Integer.TYPE, type));
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError((Object)e);
            }
        })));
        private static final MethodHandle OBJECT_ARRAY_MH = ARRAY_TYPE_MH_MAPPING.get(Object[].class);

        static int getArrayLength(boolean[] array) {
            return array.length;
        }

        static int getArrayLength(byte[] array) {
            return array.length;
        }

        static int getArrayLength(short[] array) {
            return array.length;
        }

        static int getArrayLength(int[] array) {
            return array.length;
        }

        static int getArrayLength(long[] array) {
            return array.length;
        }

        static int getArrayLength(char[] array) {
            return array.length;
        }

        static int getArrayLength(float[] array) {
            return array.length;
        }

        static int getArrayLength(double[] array) {
            return array.length;
        }

        static int getArrayLength(Object[] array) {
            return array.length;
        }

        static MethodHandle arrayLengthGetter(Class<?> arrayType) {
            if (!arrayType.isArray()) {
                throw new IllegalArgumentException("type must be an array");
            }
            return ARRAY_TYPE_MH_MAPPING.containsKey(arrayType) ? ARRAY_TYPE_MH_MAPPING.get(arrayType) : OBJECT_ARRAY_MH.asType(OBJECT_ARRAY_MH.type().changeParameterType(0, arrayType));
        }

        private ArrayLengthHelper() {
        }
    }

    private static final class ArrayIndexNormalizeHelper {
        private static final MethodHandles.Lookup PRIVATE_METHOD_HANDLES_LOOKUP = MethodHandles.lookup();
        private static final Map<Class<?>, MethodHandle> ARRAY_TYPE_MH_MAPPING = Collections.unmodifiableMap(Stream.of(boolean[].class, byte[].class, short[].class, int[].class, long[].class, char[].class, float[].class, double[].class, Object[].class).collect(Collectors.toMap(Function.identity(), type -> {
            try {
                return PRIVATE_METHOD_HANDLES_LOOKUP.findStatic(PRIVATE_METHOD_HANDLES_LOOKUP.lookupClass(), "normalizeIndex", MethodType.methodType(Integer.TYPE, type, Integer.TYPE));
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError((Object)e);
            }
        })));
        private static final MethodHandle OBJECT_ARRAY_MH = ARRAY_TYPE_MH_MAPPING.get(Object[].class);

        static int normalizeIndex(boolean[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(byte[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(short[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(int[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(long[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(char[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(float[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(double[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static int normalizeIndex(Object[] array, int index) {
            return index >= 0 ? index : index + array.length;
        }

        static MethodHandle arrayIndexNormalizer(Class<?> arrayType) {
            if (!arrayType.isArray()) {
                throw new IllegalArgumentException("type must be an array");
            }
            return ARRAY_TYPE_MH_MAPPING.containsKey(arrayType) ? ARRAY_TYPE_MH_MAPPING.get(arrayType) : OBJECT_ARRAY_MH.asType(OBJECT_ARRAY_MH.type().changeParameterType(0, arrayType));
        }

        private ArrayIndexNormalizeHelper() {
        }
    }

    private static final class ArrayIteratorHelper {
        private static final MethodHandles.Lookup PRIVATE_METHOD_HANDLES_LOOKUP = MethodHandles.lookup();
        private static final Map<Class<?>, MethodHandle> ARRAY_TYPE_MH_MAPPING = Collections.unmodifiableMap(Stream.of(boolean[].class, byte[].class, short[].class, int[].class, long[].class, char[].class, float[].class, double[].class, Object[].class).collect(Collectors.toMap(Function.identity(), type -> {
            try {
                return PRIVATE_METHOD_HANDLES_LOOKUP.findStatic(PRIVATE_METHOD_HANDLES_LOOKUP.lookupClass(), "iterator", MethodType.methodType(Iterator.class, type));
            }
            catch (ReflectiveOperationException e) {
                throw new AssertionError((Object)e);
            }
        })));
        private static final MethodHandle OBJECT_ARRAY_MH = ARRAY_TYPE_MH_MAPPING.get(Object[].class);

        static Iterator<Boolean> iterator(final boolean[] array) {
            return new Iterator<Boolean>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Boolean next() {
                    return array[this.index++];
                }
            };
        }

        static Iterator<Byte> iterator(final byte[] array) {
            return new Iterator<Byte>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Byte next() {
                    return array[this.index++];
                }
            };
        }

        static Iterator<Short> iterator(final short[] array) {
            return new Iterator<Short>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Short next() {
                    return array[this.index++];
                }
            };
        }

        static Iterator<Integer> iterator(final int[] array) {
            return new Iterator<Integer>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Integer next() {
                    return array[this.index++];
                }
            };
        }

        static Iterator<Long> iterator(final long[] array) {
            return new Iterator<Long>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Long next() {
                    return array[this.index++];
                }
            };
        }

        static Iterator<Character> iterator(final char[] array) {
            return new Iterator<Character>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Character next() {
                    return Character.valueOf(array[this.index++]);
                }
            };
        }

        static Iterator<Float> iterator(final float[] array) {
            return new Iterator<Float>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Float next() {
                    return Float.valueOf(array[this.index++]);
                }
            };
        }

        static Iterator<Double> iterator(final double[] array) {
            return new Iterator<Double>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Double next() {
                    return array[this.index++];
                }
            };
        }

        static Iterator<Object> iterator(final Object[] array) {
            return new Iterator<Object>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < array.length;
                }

                @Override
                public Object next() {
                    return array[this.index++];
                }
            };
        }

        static MethodHandle newIterator(Class<?> arrayType) {
            if (!arrayType.isArray()) {
                throw new IllegalArgumentException("type must be an array");
            }
            return ARRAY_TYPE_MH_MAPPING.containsKey(arrayType) ? ARRAY_TYPE_MH_MAPPING.get(arrayType) : OBJECT_ARRAY_MH.asType(OBJECT_ARRAY_MH.type().changeParameterType(0, arrayType));
        }

        private ArrayIteratorHelper() {
        }
    }
}

