/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.DrbgParameters;
import java.security.SecureRandom;
import java.security.SecureRandomParameters;
import java.security.SecureRandomSpi;
import java.util.concurrent.atomic.AtomicReference;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;
import org.bouncycastle.crypto.SecureRandomProvider;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvRandom
extends AsymmetricAlgorithmProvider {
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.random.";

    ProvRandom() {
    }

    @Override
    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.setProperty("SecureRandom.DEFAULT ThreadSafe", "true");
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecureRandom.DEFAULT", "org.bouncycastle.jcajce.provider.random.DefSecureRandom", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                PooledSecureRandomProvider pooledSecureRandomProvider = new PooledSecureRandomProvider(bouncyCastleFipsProvider, object);
                return new MySecureRandomSpi(pooledSecureRandomProvider);
            }
        });
        bouncyCastleFipsProvider.setProperty("SecureRandom.NONCEANDIV ThreadSafe", "true");
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecureRandom.NONCEANDIV", "org.bouncycastle.jcajce.provider.random.NonceAndIVSecureRandom", new EngineCreator(){

            @Override
            public Object createInstance(Object object) {
                PooledNonceSecureRandomProvider pooledNonceSecureRandomProvider = new PooledNonceSecureRandomProvider(bouncyCastleFipsProvider, object);
                return new MySecureRandomSpi(pooledNonceSecureRandomProvider);
            }
        });
    }

    private byte[] generatePersonalizationString() {
        return Arrays.concatenate(Strings.toByteArray("NonceAndIV"), Pack.longToLittleEndian(Thread.currentThread().getId()), Pack.longToLittleEndian(System.currentTimeMillis()));
    }

    private class MySecureRandomSpi
    extends SecureRandomSpi {
        private final SecureRandomParameters params;
        private final SecureRandomProvider provider;

        protected MySecureRandomSpi(SecureRandomProvider secureRandomProvider) {
            this.provider = secureRandomProvider;
            SecureRandom secureRandom = secureRandomProvider.get();
            if (secureRandom instanceof FipsSecureRandom) {
                FipsSecureRandom fipsSecureRandom = (FipsSecureRandom)secureRandom;
                this.params = DrbgParameters.instantiation(fipsSecureRandom.getSecurityStrength(), fipsSecureRandom.isPredictionResistant() ? DrbgParameters.Capability.PR_AND_RESEED : DrbgParameters.Capability.RESEED_ONLY, fipsSecureRandom.getPersonalizationString());
            } else {
                this.params = null;
            }
        }

        @Override
        protected void engineSetSeed(byte[] byArray) {
            this.provider.get().setSeed(byArray);
        }

        @Override
        protected void engineNextBytes(byte[] byArray, SecureRandomParameters secureRandomParameters) {
            DrbgParameters.NextBytes nextBytes;
            FipsSecureRandom fipsSecureRandom;
            if (secureRandomParameters instanceof DrbgParameters.NextBytes) {
                fipsSecureRandom = (FipsSecureRandom)this.provider.get();
                nextBytes = (DrbgParameters.NextBytes)secureRandomParameters;
                if (nextBytes.getStrength() > fipsSecureRandom.getSecurityStrength()) {
                    throw new IllegalArgumentException("maximum strength of DRBG is " + fipsSecureRandom.getSecurityStrength() + " bits");
                }
                if (nextBytes.getPredictionResistance() && !fipsSecureRandom.isPredictionResistant()) {
                    throw new IllegalArgumentException("prediction resistance not available");
                }
            } else {
                if (secureRandomParameters == null) {
                    super.engineNextBytes(byArray, secureRandomParameters);
                }
                throw new IllegalArgumentException("unrecognized DrbgParameters: " + secureRandomParameters.getClass());
            }
            fipsSecureRandom.nextBytes(byArray, nextBytes.getAdditionalInput());
        }

        @Override
        protected void engineNextBytes(byte[] byArray) {
            this.provider.get().nextBytes(byArray);
        }

        @Override
        protected byte[] engineGenerateSeed(int n) {
            return this.provider.get().generateSeed(n);
        }

        @Override
        protected void engineReseed(SecureRandomParameters secureRandomParameters) {
            if (secureRandomParameters instanceof DrbgParameters.Reseed) {
                DrbgParameters.Reseed reseed = (DrbgParameters.Reseed)secureRandomParameters;
                FipsSecureRandom fipsSecureRandom = (FipsSecureRandom)this.provider.get();
                if (reseed.getPredictionResistance() && !fipsSecureRandom.isPredictionResistant()) {
                    throw new IllegalArgumentException("prediction resistance not available");
                }
                fipsSecureRandom.reseed(reseed.getAdditionalInput());
            } else {
                if (secureRandomParameters != null) {
                    throw new IllegalArgumentException("unrecognized DrbgParameters: " + secureRandomParameters.getClass());
                }
                SecureRandom secureRandom = this.provider.get();
                if (secureRandom instanceof FipsSecureRandom) {
                    secureRandom.reseed();
                } else {
                    super.engineReseed(secureRandomParameters);
                }
            }
        }

        @Override
        protected SecureRandomParameters engineGetParameters() {
            return this.params;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private class PooledNonceSecureRandomProvider
    implements SecureRandomProvider {
        private final AtomicReference<SecureRandom>[] providerDefaultRandom = new AtomicReference[BouncyCastleFipsProvider.POOL_SIZE];
        private final BouncyCastleFipsProvider provider;
        private final Object constructorParameter;

        PooledNonceSecureRandomProvider(BouncyCastleFipsProvider bouncyCastleFipsProvider, Object object) {
            this.provider = bouncyCastleFipsProvider;
            this.constructorParameter = object;
            for (int i = 0; i != this.providerDefaultRandom.length; ++i) {
                this.providerDefaultRandom[i] = new AtomicReference();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public SecureRandom get() {
            int n = (Thread.currentThread().hashCode() & BouncyCastleFipsProvider.POOL_SIZE - 1) % this.providerDefaultRandom.length;
            if (this.providerDefaultRandom[n].get() != null) return this.providerDefaultRandom[n].get();
            AtomicReference<SecureRandom>[] atomicReferenceArray = this.providerDefaultRandom;
            synchronized (this.providerDefaultRandom) {
                FipsSecureRandom fipsSecureRandom;
                if (this.providerDefaultRandom[n].get() != null) return this.providerDefaultRandom[n].get();
                EntropySourceProvider entropySourceProvider = this.provider.getEntropySourceProvider();
                EntropySource entropySource = entropySourceProvider.get(this.provider.getProviderDefaultSecurityStrength() / 2 + 1);
                if (this.constructorParameter == null) {
                    fipsSecureRandom = this.provider.getProviderDefaultRandomBuilder().fromEntropySource(entropySourceProvider).setPersonalizationString(ProvRandom.this.generatePersonalizationString()).build(entropySource.getEntropy(), false, Strings.toByteArray("Bouncy Castle FIPS Provider Nonce/IV"));
                } else {
                    DrbgParameters.Instantiation instantiation = (DrbgParameters.Instantiation)this.constructorParameter;
                    fipsSecureRandom = this.provider.getProviderDefaultRandomBuilder().fromEntropySource(entropySourceProvider).setSecurityStrength(instantiation.getStrength()).setPersonalizationString(instantiation.getPersonalizationString()).build(entropySource.getEntropy(), instantiation.getCapability() == DrbgParameters.Capability.PR_AND_RESEED, Strings.toByteArray("Bouncy Castle FIPS Provider Custom Nonce/IV"));
                }
                this.providerDefaultRandom[n].compareAndSet(null, fipsSecureRandom);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.providerDefaultRandom[n].get();
            }
        }
    }

    private class PooledSecureRandomProvider
    implements SecureRandomProvider {
        private final AtomicReference<SecureRandom>[] providerDefaultRandom = new AtomicReference[BouncyCastleFipsProvider.POOL_SIZE];
        private final BouncyCastleFipsProvider provider;
        private final Object constructorParameter;

        PooledSecureRandomProvider(BouncyCastleFipsProvider bouncyCastleFipsProvider, Object object) {
            this.provider = bouncyCastleFipsProvider;
            this.constructorParameter = object;
            for (int i = 0; i != this.providerDefaultRandom.length; ++i) {
                this.providerDefaultRandom[i] = new AtomicReference();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public SecureRandom get() {
            int n = (Thread.currentThread().hashCode() & BouncyCastleFipsProvider.POOL_SIZE - 1) % this.providerDefaultRandom.length;
            if (this.providerDefaultRandom[n].get() != null) return this.providerDefaultRandom[n].get();
            AtomicReference<SecureRandom>[] atomicReferenceArray = this.providerDefaultRandom;
            synchronized (this.providerDefaultRandom) {
                SecureRandom secureRandom;
                if (this.providerDefaultRandom[n].get() != null) return this.providerDefaultRandom[n].get();
                if (this.constructorParameter == null) {
                    secureRandom = this.provider.getDefaultSecureRandom();
                } else {
                    DrbgParameters.Instantiation instantiation = (DrbgParameters.Instantiation)this.constructorParameter;
                    EntropySourceProvider entropySourceProvider = this.provider.getEntropySourceProvider();
                    EntropySource entropySource = entropySourceProvider.get(instantiation.getStrength() / 2 + 1);
                    secureRandom = this.provider.getProviderDefaultRandomBuilder().fromEntropySource(entropySourceProvider).setSecurityStrength(instantiation.getStrength()).setPersonalizationString(instantiation.getPersonalizationString()).build(entropySource.getEntropy(), instantiation.getCapability() == DrbgParameters.Capability.PR_AND_RESEED, Strings.toByteArray("Bouncy Castle FIPS Custom Default"));
                }
                this.providerDefaultRandom[n].compareAndSet(null, secureRandom);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.providerDefaultRandom[n].get();
            }
        }
    }
}

