/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.services;

import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.protobufs.SearchResponse;
import org.opensearch.protobufs.services.SearchServiceGrpc;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.grpc.listeners.SearchRequestActionListener;
import org.opensearch.transport.grpc.proto.request.search.SearchRequestProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.query.AbstractQueryBuilderProtoUtils;
import org.opensearch.transport.grpc.util.GrpcErrorHandler;

public class SearchServiceImpl
extends SearchServiceGrpc.SearchServiceImplBase {
    private static final Logger logger = LogManager.getLogger(SearchServiceImpl.class);
    private final Client client;
    private final AbstractQueryBuilderProtoUtils queryUtils;

    public SearchServiceImpl(Client client, AbstractQueryBuilderProtoUtils queryUtils) {
        if (client == null) {
            throw new IllegalArgumentException("Client cannot be null");
        }
        if (queryUtils == null) {
            throw new IllegalArgumentException("Query utils cannot be null");
        }
        this.client = client;
        this.queryUtils = queryUtils;
    }

    public void search(org.opensearch.protobufs.SearchRequest request, StreamObserver<SearchResponse> responseObserver) {
        try {
            SearchRequest searchRequest = SearchRequestProtoUtils.prepareRequest(request, this.client, this.queryUtils);
            SearchRequestActionListener listener = new SearchRequestActionListener(responseObserver);
            this.client.search(searchRequest, (ActionListener)listener);
        }
        catch (IOException | RuntimeException e) {
            logger.debug("SearchServiceImpl failed to process search request, request=" + String.valueOf(request) + ", error=" + e.getMessage());
            StatusRuntimeException grpcError = GrpcErrorHandler.convertToGrpcError(e);
            responseObserver.onError((Throwable)grpcError);
        }
    }
}

