/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tools.cli.fips.truststore;

import java.io.PrintWriter;
import java.security.Provider;
import java.util.List;
import java.util.Optional;
import org.opensearch.tools.cli.fips.truststore.CommonOptions;
import org.opensearch.tools.cli.fips.truststore.UserInteractionService;
import picocli.CommandLine;

public class ProviderSelectionService {
    private final UserInteractionService userInteraction;

    public ProviderSelectionService(UserInteractionService userInteraction) {
        this.userInteraction = userInteraction;
    }

    public Provider.Service selectProvider(CommandLine.Model.CommandSpec spec, CommonOptions options, List<Provider.Service> serviceProviderList, String preselectedPKCS11Provider) {
        if (serviceProviderList.isEmpty()) {
            throw new IllegalStateException("No PKCS11 providers available. Please ensure a PKCS11 provider is installed and configured.");
        }
        if (preselectedPKCS11Provider != null) {
            Optional<Provider.Service> found = serviceProviderList.stream().filter(service -> service.getProvider().getName().equals(preselectedPKCS11Provider)).findFirst();
            if (found.isPresent()) {
                return found.get();
            }
            PrintWriter err = spec.commandLine().getErr();
            err.println(spec.commandLine().getColorScheme().errorText("ERROR: Specified PKCS11 provider '" + preselectedPKCS11Provider + "' not found."));
            err.println(spec.commandLine().getColorScheme().errorText("Available providers:"));
            serviceProviderList.forEach(service -> err.println(spec.commandLine().getColorScheme().errorText("  - " + service.getProvider().getName())));
            throw new IllegalArgumentException("Provider not found: " + preselectedPKCS11Provider);
        }
        if (options.nonInteractive) {
            Provider.Service service2 = serviceProviderList.get(0);
            spec.commandLine().getOut().println("Using PKCS11 provider: " + service2.getProvider().getName());
            return service2;
        }
        if (serviceProviderList.size() == 1) {
            Provider.Service service3 = serviceProviderList.get(0);
            String providerName = service3.getProvider().getName();
            if (this.userInteraction.confirmAction(spec, options, "Use PKCS11 provider '" + providerName + "'?")) {
                return service3;
            }
            return null;
        }
        return this.selectProviderInteractively(spec, serviceProviderList);
    }

    protected Provider.Service selectProviderInteractively(CommandLine.Model.CommandSpec spec, List<Provider.Service> serviceProviderList) {
        PrintWriter out = spec.commandLine().getOut();
        out.println("Multiple PKCS11 providers found:");
        for (int i = 0; i < serviceProviderList.size(); ++i) {
            Provider.Service service = serviceProviderList.get(i);
            out.println("  " + (i + 1) + ". " + service.getProvider().getName() + " (Algorithm: " + service.getAlgorithm() + ")");
        }
        out.println("Select PKCS11 provider");
        int choice = this.userInteraction.promptForChoice(spec, serviceProviderList.size(), 1);
        return serviceProviderList.get(choice - 1);
    }
}

