/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.encodings;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.internal.AsymmetricBlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class PKCS1Encoding
implements AsymmetricBlockCipher {
    public static final String NOT_STRICT_LENGTH_ENABLED_PROPERTY = "org.bouncycastle.pkcs1.not_strict";
    private static final int HEADER_LENGTH = 10;
    private SecureRandom random;
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private boolean forPrivateKey;
    private boolean useStrictLength;
    private byte[] dudBlock;

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.engine = asymmetricBlockCipher;
        this.useStrictLength = this.useStrict();
    }

    private boolean useStrict() {
        return CryptoServicesRegistrar.isInApprovedOnlyMode() || !Properties.isOverrideSet(NOT_STRICT_LENGTH_ENABLED_PROPERTY);
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.random = parametersWithRandom.getRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            asymmetricKeyParameter = (AsymmetricKeyParameter)cipherParameters;
            if (!asymmetricKeyParameter.isPrivate() && bl) {
                throw new IllegalArgumentException("No SecureRandom specified.");
            }
        }
        this.engine.init(bl, cipherParameters);
        this.forPrivateKey = asymmetricKeyParameter.isPrivate();
        this.forEncryption = bl;
        this.dudBlock = new byte[this.engine.getOutputBlockSize()];
    }

    @Override
    public int getInputBlockSize() {
        int n = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return n - 10;
        }
        return n;
    }

    @Override
    public int getOutputBlockSize() {
        int n = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return n;
        }
        return n - 10;
    }

    @Override
    public byte[] processBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(byArray, n, n2);
        }
        return this.decodeBlock(byArray, n, n2);
    }

    private byte[] encodeBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        if (n2 > this.getInputBlockSize()) {
            throw new IllegalArgumentException("input data too large");
        }
        byte[] byArray2 = new byte[this.engine.getInputBlockSize()];
        if (this.forPrivateKey) {
            byArray2[0] = 1;
            for (int i = 1; i != byArray2.length - n2 - 1; ++i) {
                byArray2[i] = -1;
            }
        } else {
            this.random.nextBytes(byArray2);
            byArray2[0] = 2;
            for (int i = 1; i != byArray2.length - n2 - 1; ++i) {
                while (byArray2[i] == 0) {
                    byArray2[i] = (byte)this.random.nextInt();
                }
            }
        }
        byArray2[byArray2.length - n2 - 1] = 0;
        System.arraycopy(byArray, n, byArray2, byArray2.length - n2, n2);
        return this.engine.processBlock(byArray2, 0, byArray2.length);
    }

    private byte[] decodeBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        byte[] byArray2 = this.engine.processBlock(byArray, n, n2);
        if (byArray2.length < this.getOutputBlockSize()) {
            byArray2 = this.dudBlock;
        }
        byte by = byArray2[0];
        boolean bl = this.forPrivateKey ? by != 2 : by != 1;
        boolean bl2 = this.useStrictLength & byArray2.length != this.engine.getOutputBlockSize();
        int n3 = this.findStart(by, byArray2);
        if (bl | ++n3 < 10) {
            Arrays.fill(byArray2, (byte)0);
            throw new InvalidCipherTextException("block incorrect");
        }
        if (bl2) {
            Arrays.fill(byArray2, (byte)0);
            throw new InvalidCipherTextException("block incorrect size");
        }
        byte[] byArray3 = new byte[byArray2.length - n3];
        System.arraycopy(byArray2, n3, byArray3, 0, byArray3.length);
        return byArray3;
    }

    private int findStart(byte by, byte[] byArray) throws InvalidCipherTextException {
        int n = -1;
        boolean bl = false;
        for (int i = 1; i != byArray.length; ++i) {
            byte by2 = byArray[i];
            if (by2 == 0 & n < 0) {
                n = i;
            }
            bl |= by == 1 & n < 0 & by2 != -1;
        }
        if (bl) {
            return -1;
        }
        return n;
    }
}

