/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.macs;

import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import org.bouncycastle.crypto.internal.params.AEADParameters;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AEADCipherMac
implements Mac {
    private final AEADBlockCipher aeadCipher;
    private final int macLenInBits;

    public AEADCipherMac(AEADBlockCipher aEADBlockCipher, int n) {
        this.aeadCipher = aEADBlockCipher;
        this.macLenInBits = n;
    }

    @Override
    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("AEAD cipher based MAC needs nonce/IV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        this.aeadCipher.init(true, new AEADParameters((KeyParameter)parametersWithIV.getParameters(), this.macLenInBits, parametersWithIV.getIV()));
    }

    @Override
    public String getAlgorithmName() {
        return this.aeadCipher.getAlgorithmName() + "MAC";
    }

    @Override
    public int getMacSize() {
        return (this.macLenInBits + 7) / 8;
    }

    @Override
    public void update(byte by) throws IllegalStateException {
        this.aeadCipher.processAADByte(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) throws DataLengthException, IllegalStateException {
        this.aeadCipher.processAADBytes(byArray, n, n2);
    }

    @Override
    public int doFinal(byte[] byArray, int n) throws DataLengthException, IllegalStateException {
        try {
            return this.aeadCipher.doFinal(byArray, n);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new IllegalStateException("Unable to create MAC tag:" + invalidCipherTextException.getMessage(), invalidCipherTextException);
        }
    }

    @Override
    public void reset() {
        this.aeadCipher.reset();
    }
}

