/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.FinishedException;
import org.bouncycastle.crypto.UpdateException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class UpdateOutputStream
extends OutputStream {
    public final void update(byte by) {
        try {
            this.write(by);
        }
        catch (IOException iOException) {
            if (iOException.getCause() != null) {
                throw new UpdateException(iOException.getClass().getName() + ": " + iOException.getMessage(), iOException.getCause());
            }
            throw new UpdateException("Exception processing data: " + iOException.getMessage(), iOException);
        }
    }

    public final void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n, int n2) {
        try {
            this.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            if (iOException.getCause() != null) {
                throw new UpdateException(iOException.getClass().getName() + ": " + iOException.getMessage(), iOException.getCause());
            }
            throw new UpdateException("Exception processing data: " + iOException.getMessage(), iOException);
        }
    }

    public final void finished() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            if (iOException.getCause() != null) {
                throw new FinishedException(iOException.getClass().getName() + ": " + iOException.getMessage(), iOException.getCause());
            }
            throw new FinishedException("Exception processing data: " + iOException.getMessage(), iOException);
        }
    }
}

