/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Properties {
    public static boolean isOverrideSet(String string) {
        try {
            return Properties.isSetTrue(Properties.getPropertyValue(string));
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    public static boolean isOverrideSetTo(String string, boolean bl) {
        try {
            String string2 = Properties.getPropertyValue(string);
            if (bl) {
                return Properties.isSetTrue(string2);
            }
            return Properties.isSetFalse(string2);
        }
        catch (AccessControlException accessControlException) {
            return false;
        }
    }

    public static int asInteger(String string, int n) {
        String string2 = Properties.getPropertyValue(string);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return n;
    }

    public static String getPropertyValue(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String string2 = Security.getProperty(string);
                if (string2 != null) {
                    return string2;
                }
                return System.getProperty(string);
            }
        });
    }

    public static String getPropertyValue(final String string, final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String string3 = Security.getProperty(string);
                if (string3 != null) {
                    return string3;
                }
                string3 = System.getProperty(string);
                if (string3 != null) {
                    return string3;
                }
                return string2;
            }
        });
    }

    private static boolean isSetFalse(String string) {
        if (string == null || string.length() != 5) {
            return false;
        }
        return !(string.charAt(0) != 'f' && string.charAt(0) != 'F' || string.charAt(1) != 'a' && string.charAt(1) != 'A' || string.charAt(2) != 'l' && string.charAt(2) != 'L' || string.charAt(3) != 's' && string.charAt(3) != 'S' || string.charAt(4) != 'e' && string.charAt(4) != 'E');
    }

    private static boolean isSetTrue(String string) {
        if (string == null || string.length() != 4) {
            return false;
        }
        return !(string.charAt(0) != 't' && string.charAt(0) != 'T' || string.charAt(1) != 'r' && string.charAt(1) != 'R' || string.charAt(2) != 'u' && string.charAt(2) != 'U' || string.charAt(3) != 'e' && string.charAt(3) != 'E');
    }
}

