/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.env;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.index.shard.ShardId;

@PublicApi(since="1.0.0")
public abstract class ShardLock
implements Closeable {
    private final ShardId shardId;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public ShardLock(ShardId id) {
        this.shardId = id;
    }

    public final ShardId getShardId() {
        return this.shardId;
    }

    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.closeInternal();
        }
    }

    protected abstract void closeInternal();

    public void setDetails(String details) {
    }

    public String toString() {
        return "ShardLock{shardId=" + String.valueOf(this.shardId) + "}";
    }
}

