/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.PriorityQueue;
import org.opensearch.core.common.util.CollectionUtils;

public final class CollapseTopFieldDocs
extends TopFieldDocs {
    public final String field;
    public final Object[] collapseValues;
    private static final Comparator<ScoreDoc> SHARD_INDEX_TIE_BREAKER = Comparator.comparingInt(d -> d.shardIndex);
    private static final Comparator<ScoreDoc> DOC_ID_TIE_BREAKER = Comparator.comparingInt(d -> d.doc);
    private static final Comparator<ScoreDoc> DEFAULT_TIE_BREAKER = SHARD_INDEX_TIE_BREAKER.thenComparing(DOC_ID_TIE_BREAKER);

    public CollapseTopFieldDocs(String field, TotalHits totalHits, ScoreDoc[] scoreDocs, SortField[] sortFields, Object[] values) {
        super(totalHits, scoreDocs, sortFields);
        this.field = field;
        this.collapseValues = values;
    }

    static boolean tieBreakLessThan(ShardRef first, ScoreDoc firstDoc, ShardRef second, ScoreDoc secondDoc) {
        int value = DEFAULT_TIE_BREAKER.compare(firstDoc, secondDoc);
        if (value == 0) {
            assert (first.hitIndex != second.hitIndex);
            return first.hitIndex < second.hitIndex;
        }
        return value < 0;
    }

    public static CollapseTopFieldDocs merge(Sort sort, int start, int size, CollapseTopFieldDocs[] shardHits) {
        Object[] values;
        ScoreDoc[] hits;
        String collapseField = shardHits[0].field;
        for (int i = 1; i < shardHits.length; ++i) {
            if (collapseField.equals(shardHits[i].field)) continue;
            throw new IllegalArgumentException("collapse field differ across shards [" + collapseField + "] != [" + shardHits[i].field + "]");
        }
        MergeSortQueue queue = new MergeSortQueue(sort, shardHits);
        long totalHitCount = 0L;
        int availHitCount = 0;
        TotalHits.Relation totalHitsRelation = TotalHits.Relation.EQUAL_TO;
        for (int shardIDX = 0; shardIDX < shardHits.length; ++shardIDX) {
            CollapseTopFieldDocs shard = shardHits[shardIDX];
            totalHitCount += shard.totalHits.value();
            if (shard.totalHits.relation() == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO) {
                totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
            }
            if (CollectionUtils.isEmpty((Object[])shard.scoreDocs)) continue;
            availHitCount += shard.scoreDocs.length;
            queue.add(new ShardRef(shardIDX));
        }
        boolean unsetShardIndex = false;
        if (availHitCount <= start) {
            hits = new ScoreDoc[]{};
            values = new Object[]{};
        } else {
            ArrayList<ScoreDoc> hitList = new ArrayList<ScoreDoc>();
            ArrayList<Object> collapseList = new ArrayList<Object>();
            int requestedResultWindow = start + size;
            int numIterOnHits = Math.min(availHitCount, requestedResultWindow);
            int hitUpto = 0;
            HashSet<Object> seen = new HashSet<Object>();
            while (hitUpto < numIterOnHits && queue.size() != 0) {
                ShardRef ref = (ShardRef)queue.top();
                ScoreDoc hit = shardHits[ref.shardIndex].scoreDocs[ref.hitIndex];
                Object collapseValue = shardHits[ref.shardIndex].collapseValues[ref.hitIndex++];
                if (hitUpto > 0 && unsetShardIndex != (hit.shardIndex == -1)) {
                    throw new IllegalArgumentException("Inconsistent order of shard indices");
                }
                unsetShardIndex |= hit.shardIndex == -1;
                if (seen.contains(collapseValue)) {
                    if (ref.hitIndex < shardHits[ref.shardIndex].scoreDocs.length) {
                        queue.updateTop();
                        continue;
                    }
                    queue.pop();
                    continue;
                }
                seen.add(collapseValue);
                if (hitUpto >= start) {
                    hitList.add(hit);
                    collapseList.add(collapseValue);
                }
                ++hitUpto;
                if (ref.hitIndex < shardHits[ref.shardIndex].scoreDocs.length) {
                    queue.updateTop();
                    continue;
                }
                queue.pop();
            }
            hits = hitList.toArray(new ScoreDoc[0]);
            values = collapseList.toArray(new Object[0]);
        }
        TotalHits totalHits = new TotalHits(totalHitCount, totalHitsRelation);
        return new CollapseTopFieldDocs(collapseField, totalHits, hits, sort.getSort(), values);
    }

    private static final class ShardRef {
        final int shardIndex;
        int hitIndex;

        ShardRef(int shardIndex) {
            this.shardIndex = shardIndex;
        }

        public String toString() {
            return "ShardRef(shardIndex=" + this.shardIndex + " hitIndex=" + this.hitIndex + ")";
        }
    }

    private static class MergeSortQueue
    extends PriorityQueue<ShardRef> {
        final ScoreDoc[][] shardHits;
        final FieldComparator<?>[] comparators;
        final int[] reverseMul;

        MergeSortQueue(Sort sort, CollapseTopFieldDocs[] shardHits) {
            super(shardHits.length);
            this.shardHits = new ScoreDoc[shardHits.length][];
            for (int shardIDX = 0; shardIDX < shardHits.length; ++shardIDX) {
                ScoreDoc[] shard = shardHits[shardIDX].scoreDocs;
                if (shard == null) continue;
                this.shardHits[shardIDX] = shard;
                for (int hitIDX = 0; hitIDX < shard.length; ++hitIDX) {
                    ScoreDoc sd = shard[hitIDX];
                    FieldDoc gd = (FieldDoc)sd;
                    assert (gd.fields != null);
                }
            }
            SortField[] sortFields = sort.getSort();
            this.comparators = new FieldComparator[sortFields.length];
            this.reverseMul = new int[sortFields.length];
            for (int compIDX = 0; compIDX < sortFields.length; ++compIDX) {
                SortField sortField = sortFields[compIDX];
                this.comparators[compIDX] = sortField.getComparator(1, Pruning.NONE);
                this.reverseMul[compIDX] = sortField.getReverse() ? -1 : 1;
            }
        }

        public boolean lessThan(ShardRef first, ShardRef second) {
            assert (first != second);
            FieldDoc firstFD = (FieldDoc)this.shardHits[first.shardIndex][first.hitIndex];
            FieldDoc secondFD = (FieldDoc)this.shardHits[second.shardIndex][second.hitIndex];
            for (int compIDX = 0; compIDX < this.comparators.length; ++compIDX) {
                FieldComparator<?> comp = this.comparators[compIDX];
                int cmp = this.reverseMul[compIDX] * comp.compareValues(firstFD.fields[compIDX], secondFD.fields[compIDX]);
                if (cmp == 0) continue;
                return cmp < 0;
            }
            return CollapseTopFieldDocs.tieBreakLessThan(first, (ScoreDoc)firstFD, second, (ScoreDoc)secondFD);
        }
    }
}

