/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECKey;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.math.ec.ECPoint;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AsymmetricECPrivateKey
extends AsymmetricECKey
implements AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final byte[] publicKey;
    private int hashCode;
    private BigInteger d;

    public AsymmetricECPrivateKey(Algorithm algorithm, ECDomainParametersID eCDomainParametersID, BigInteger bigInteger) {
        this(algorithm, eCDomainParametersID, bigInteger, null);
    }

    public AsymmetricECPrivateKey(Algorithm algorithm, ECDomainParameters eCDomainParameters, BigInteger bigInteger) {
        this(algorithm, eCDomainParameters, bigInteger, null);
    }

    public AsymmetricECPrivateKey(Algorithm algorithm, ECDomainParameters eCDomainParameters, BigInteger bigInteger, ECPoint eCPoint) {
        super(algorithm, eCDomainParameters);
        this.d = bigInteger;
        this.publicKey = this.extractPublicKeyBytes(eCPoint);
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricECPrivateKey(Algorithm algorithm, ECDomainParametersID eCDomainParametersID, BigInteger bigInteger, ECPoint eCPoint) {
        super(algorithm, eCDomainParametersID);
        this.d = bigInteger;
        this.publicKey = this.extractPublicKeyBytes(eCPoint);
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricECPrivateKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, PrivateKeyInfo.getInstance(byArray));
    }

    public AsymmetricECPrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        this(algorithm, privateKeyInfo.getPrivateKeyAlgorithm(), AsymmetricECPrivateKey.parsePrivateKey(privateKeyInfo));
    }

    private AsymmetricECPrivateKey(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier, ECPrivateKey eCPrivateKey) {
        super(algorithm, algorithmIdentifier);
        this.d = eCPrivateKey.getKey();
        DERBitString dERBitString = eCPrivateKey.getPublicKey();
        this.publicKey = dERBitString == null ? null : dERBitString.getBytes();
        this.hashCode = this.calculateHashCode();
    }

    private static ECPrivateKey parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            return ECPrivateKey.getInstance(privateKeyInfo.parsePrivateKey());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to parse EC private key: " + iOException.getMessage(), iOException);
        }
    }

    private byte[] extractPublicKeyBytes(ECPoint eCPoint) {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkDestroyed(this);
        if (eCPoint == null) {
            return null;
        }
        return eCPoint.getEncoded(false);
    }

    @Override
    public final byte[] getEncoded() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
        X962Parameters x962Parameters = KeyUtils.buildCurveParameters(this.getDomainParameters());
        int n = KeyUtils.getOrderBitLength(this.getDomainParameters());
        ECPrivateKey eCPrivateKey = this.publicKey != null ? new ECPrivateKey(n, this.getS(), new DERBitString(this.publicKey), x962Parameters) : new ECPrivateKey(n, this.getS(), x962Parameters);
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), eCPrivateKey);
    }

    @Override
    public final Algorithm getAlgorithm() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkDestroyed(this);
        return super.getAlgorithm();
    }

    @Override
    public final ECDomainParameters getDomainParameters() {
        this.checkApprovedOnlyModeStatus();
        ECDomainParameters eCDomainParameters = super.getDomainParameters();
        KeyUtils.checkDestroyed(this);
        return eCDomainParameters;
    }

    public BigInteger getS() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        BigInteger bigInteger = this.d;
        KeyUtils.checkDestroyed(this);
        return bigInteger;
    }

    @Override
    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.d = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    @Override
    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    @Override
    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricECPrivateKey)) {
            return false;
        }
        AsymmetricECPrivateKey asymmetricECPrivateKey = (AsymmetricECPrivateKey)object;
        asymmetricECPrivateKey.checkApprovedOnlyModeStatus();
        if (!this.getS().equals(asymmetricECPrivateKey.getS())) {
            return false;
        }
        return this.getDomainParameters().equals(asymmetricECPrivateKey.getDomainParameters());
    }

    @Override
    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n = this.d.hashCode();
        n = 31 * n + this.getDomainParameters().hashCode();
        return n;
    }
}

