/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.opensearch.ExceptionsHelper;
import org.opensearch.common.CheckedSupplier;
import org.opensearch.common.Numbers;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.index.codec.composite.CompositeIndexFieldInfo;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.SortedNumericStarTreeValuesIterator;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.StarTreeValuesIterator;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalOrder;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.StarTreeBucketCollector;
import org.opensearch.search.aggregations.StarTreePreComputeCollector;
import org.opensearch.search.aggregations.bucket.BucketsAggregator;
import org.opensearch.search.aggregations.bucket.DeferableBucketAggregator;
import org.opensearch.search.aggregations.bucket.LocalBucketCountThresholds;
import org.opensearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.opensearch.search.aggregations.bucket.terms.BytesKeyedBucketOrds;
import org.opensearch.search.aggregations.bucket.terms.IncludeExclude;
import org.opensearch.search.aggregations.bucket.terms.InternalMultiTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.opensearch.search.aggregations.support.AggregationPath;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.startree.StarTreeQueryHelper;
import org.opensearch.search.startree.filter.DimensionFilter;
import org.opensearch.search.startree.filter.MatchAllFilter;

public class MultiTermsAggregator
extends DeferableBucketAggregator
implements StarTreePreComputeCollector {
    private final BytesKeyedBucketOrds bucketOrds;
    private final MultiTermsValuesSource multiTermsValue;
    private final boolean showTermDocCountError;
    private final List<DocValueFormat> formats;
    private final List<String> fields;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final BucketOrder order;
    private final Comparator<InternalMultiTerms.Bucket> partiallyBuiltBucketComparator;
    private final Aggregator.SubAggCollectionMode collectMode;
    private final Set<Aggregator> aggsUsedForSorting = new HashSet<Aggregator>();
    private final BytesStreamOutput starTreeScratch = new BytesStreamOutput();

    public MultiTermsAggregator(String name, AggregatorFactories factories, boolean showTermDocCountError, List<ValuesSource> rawValuesSources, List<InternalValuesSource> internalValuesSources, List<String> fields, List<DocValueFormat> formats, BucketOrder order, Aggregator.SubAggCollectionMode collectMode, TermsAggregator.BucketCountThresholds bucketCountThresholds, SearchContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, metadata);
        this.bucketOrds = BytesKeyedBucketOrds.build(context.bigArrays(), cardinality);
        this.multiTermsValue = new MultiTermsValuesSource(rawValuesSources, internalValuesSources);
        this.showTermDocCountError = showTermDocCountError;
        this.formats = formats;
        this.bucketCountThresholds = bucketCountThresholds;
        this.order = order;
        this.partiallyBuiltBucketComparator = order == null ? null : order.partiallyBuiltBucketComparator(b -> b.bucketOrd, this);
        this.collectMode = this.subAggsNeedScore() && TermsAggregator.descendsFromNestedAggregator(parent) ? Aggregator.SubAggCollectionMode.DEPTH_FIRST : collectMode;
        this.fields = fields;
        if (order instanceof InternalOrder.Aggregation) {
            AggregationPath path = ((InternalOrder.Aggregation)order).path();
            this.aggsUsedForSorting.add(path.resolveTopmostAggregator(this));
        } else if (order instanceof InternalOrder.CompoundOrder) {
            InternalOrder.CompoundOrder compoundOrder = (InternalOrder.CompoundOrder)order;
            for (BucketOrder orderElement : compoundOrder.orderElements()) {
                if (!(orderElement instanceof InternalOrder.Aggregation)) continue;
                AggregationPath path = ((InternalOrder.Aggregation)orderElement).path();
                this.aggsUsedForSorting.add(path.resolveTopmostAggregator(this));
            }
        }
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        LocalBucketCountThresholds localBucketCountThresholds = this.context.asLocalBucketCountThresholds(this.bucketCountThresholds);
        InternalMultiTerms.Bucket[][] topBucketsPerOrd = new InternalMultiTerms.Bucket[owningBucketOrds.length][];
        long[] otherDocCounts = new long[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            this.checkCancelled();
            this.collectZeroDocEntriesIfNeeded(owningBucketOrds[ordIdx]);
            long bucketsInOrd = this.bucketOrds.bucketsInOrd(owningBucketOrds[ordIdx]);
            int size = (int)Math.min(bucketsInOrd, (long)localBucketCountThresholds.getRequiredSize());
            BucketPriorityQueue<InternalMultiTerms.Bucket> ordered = new BucketPriorityQueue<InternalMultiTerms.Bucket>(size, this.partiallyBuiltBucketComparator);
            InternalMultiTerms.Bucket spare = null;
            BytesRef dest = null;
            BytesKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrds[ordIdx]);
            CheckedSupplier emptyBucketBuilder = () -> InternalMultiTerms.Bucket.EMPTY(this.showTermDocCountError, this.formats);
            while (ordsEnum.next()) {
                long docCount = this.bucketDocCount(ordsEnum.ord());
                int n = ordIdx;
                otherDocCounts[n] = otherDocCounts[n] + docCount;
                if (docCount < localBucketCountThresholds.getMinDocCount()) continue;
                if (spare == null) {
                    spare = (InternalMultiTerms.Bucket)emptyBucketBuilder.get();
                    dest = new BytesRef();
                }
                ordsEnum.readValue(dest);
                spare.termValues = MultiTermsAggregator.decode(dest);
                spare.docCount = docCount;
                spare.bucketOrd = ordsEnum.ord();
                spare = (InternalMultiTerms.Bucket)ordered.insertWithOverflow(spare);
            }
            InternalMultiTerms.Bucket[] bucketsForOrd = new InternalMultiTerms.Bucket[ordered.size()];
            topBucketsPerOrd[ordIdx] = bucketsForOrd;
            for (int b2 = ordered.size() - 1; b2 >= 0; --b2) {
                topBucketsPerOrd[ordIdx][b2] = (InternalMultiTerms.Bucket)ordered.pop();
                int n = ordIdx;
                otherDocCounts[n] = otherDocCounts[n] - topBucketsPerOrd[ordIdx][b2].getDocCount();
            }
        }
        this.buildSubAggsForAllBuckets(topBucketsPerOrd, b -> b.bucketOrd, (b, aggs) -> {
            b.aggregations = aggs;
        });
        InternalAggregation[] result = new InternalAggregation[owningBucketOrds.length];
        for (int ordIdx = 0; ordIdx < owningBucketOrds.length; ++ordIdx) {
            result[ordIdx] = this.buildResult(owningBucketOrds[ordIdx], otherDocCounts[ordIdx], topBucketsPerOrd[ordIdx]);
        }
        return result;
    }

    InternalMultiTerms buildResult(long owningBucketOrd, long otherDocCount, InternalMultiTerms.Bucket[] topBuckets) {
        BucketOrder reduceOrder;
        if (!InternalOrder.isKeyOrder(this.order)) {
            reduceOrder = InternalOrder.key(true);
            Arrays.sort(topBuckets, reduceOrder.comparator());
        } else {
            reduceOrder = this.order;
        }
        return new InternalMultiTerms(this.name, reduceOrder, this.order, this.metadata(), this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, 0L, this.formats, List.of(topBuckets), this.bucketCountThresholds);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalMultiTerms(this.name, this.order, this.order, this.metadata(), this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, 0L, 0L, this.formats, Collections.emptyList(), this.bucketCountThresholds);
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        final MultiTermsValuesSourceCollector collector = this.multiTermsValue.getValues(ctx, this.bucketOrds, this, sub);
        return new LeafBucketCollector(this){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                collector.apply(doc, owningBucketOrd);
            }
        };
    }

    @Override
    protected boolean tryPrecomputeAggregationForLeaf(LeafReaderContext ctx) throws IOException {
        CompositeIndexFieldInfo supportedStarTree = StarTreeQueryHelper.getSupportedStarTree(this.context.getQueryShardContext());
        if (supportedStarTree != null) {
            this.preComputeWithStarTree(ctx, supportedStarTree);
            return true;
        }
        return false;
    }

    private void preComputeWithStarTree(LeafReaderContext ctx, CompositeIndexFieldInfo starTree) throws IOException {
        StarTreeBucketCollector starTreeBucketCollector = this.getStarTreeBucketCollector(ctx, starTree, null);
        StarTreeQueryHelper.preComputeBucketsWithStarTree(starTreeBucketCollector);
    }

    @Override
    public StarTreeBucketCollector getStarTreeBucketCollector(final LeafReaderContext ctx, final CompositeIndexFieldInfo starTree, StarTreeBucketCollector parent) throws IOException {
        StarTreeValues starTreeValues = StarTreeQueryHelper.getStarTreeValues(ctx, starTree);
        assert (starTreeValues != null);
        final SortedNumericStarTreeValuesIterator docCountsIterator = StarTreeQueryHelper.getDocCountsIterator(starTreeValues, starTree);
        final ArrayList<StarTreeValuesIterator> dimensionIterators = new ArrayList<StarTreeValuesIterator>();
        final ArrayList<Function<Long, TermValue>> termValueBuilders = new ArrayList<Function<Long, TermValue>>();
        for (int i = 0; i < this.fields.size(); ++i) {
            String fieldName = this.fields.get(i);
            dimensionIterators.add(starTreeValues.getDimensionValuesIterator(fieldName));
            ValuesSource vs = this.multiTermsValue.rawValueSources.get(i);
            if (vs instanceof ValuesSource.Bytes.WithOrdinals) {
                ValuesSource.Bytes.WithOrdinals vsBytes = (ValuesSource.Bytes.WithOrdinals)vs;
                termValueBuilders.add(ord -> {
                    try {
                        return TermValue.of(vsBytes.globalOrdinalsValues(ctx).lookupOrd(ord.longValue()));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                continue;
            }
            if (vs instanceof ValuesSource.Numeric) {
                ValuesSource.Numeric numericSource = (ValuesSource.Numeric)vs;
                if (numericSource.isFloatingPoint()) {
                    NumberFieldMapper.NumberFieldType numberFieldType = (NumberFieldMapper.NumberFieldType)this.context.mapperService().fieldType(fieldName);
                    termValueBuilders.add(val -> TermValue.of(numberFieldType.toDoubleValue((long)val)));
                    continue;
                }
                termValueBuilders.add(TermValue::of);
                continue;
            }
            throw new IllegalStateException("Unsupported ValuesSource type for star-tree: " + vs.getClass().getName());
        }
        return new StarTreeBucketCollector(this, starTreeValues, parent == null ? StarTreeQueryHelper.getStarTreeResult(starTreeValues, this.context, this.getDimensionFilters()) : null){
            final /* synthetic */ MultiTermsAggregator this$0;
            {
                this.this$0 = this$0;
                super(starTreeValues, matchingDocsBitSet);
            }

            @Override
            public void setSubCollectors() throws IOException {
                for (Aggregator aggregator : this.this$0.subAggregators) {
                    if (!(aggregator instanceof StarTreePreComputeCollector)) continue;
                    StarTreePreComputeCollector collector = (StarTreePreComputeCollector)((Object)aggregator);
                    this.subCollectors.add(collector.getStarTreeBucketCollector(ctx, starTree, this));
                }
            }

            @Override
            public void collectStarTreeEntry(int starTreeEntry, long owningBucketOrd) throws IOException {
                if (!docCountsIterator.advanceExact(starTreeEntry)) {
                    return;
                }
                long docCountMetric = docCountsIterator.nextValue();
                ArrayList collectedValues = new ArrayList();
                for (int i = 0; i < dimensionIterators.size(); ++i) {
                    StarTreeValuesIterator dimIterator = (StarTreeValuesIterator)dimensionIterators.get(i);
                    if (!dimIterator.advanceExact(starTreeEntry)) {
                        return;
                    }
                    ArrayList<TermValue> valuesForDim = new ArrayList<TermValue>();
                    Function builder = (Function)termValueBuilders.get(i);
                    for (int j = 0; j < dimIterator.entryValueCount(); ++j) {
                        valuesForDim.add((TermValue)builder.apply(dimIterator.value()));
                    }
                    collectedValues.add(valuesForDim);
                }
                this.this$0.starTreeScratch.seek(0L);
                this.this$0.starTreeScratch.writeVInt(dimensionIterators.size());
                this.generateAndCollectFromStarTree(collectedValues, 0, owningBucketOrd, starTreeEntry, docCountMetric);
            }

            private void generateAndCollectFromStarTree(List<List<TermValue<?>>> collectedValues, int index, long owningBucketOrd, int starTreeEntry, long docCountMetric) throws IOException {
                if (index == collectedValues.size()) {
                    long bucketOrd = this.this$0.bucketOrds.add(owningBucketOrd, this.this$0.starTreeScratch.bytes().toBytesRef());
                    this.this$0.collectStarTreeBucket(this, docCountMetric, bucketOrd, starTreeEntry);
                    return;
                }
                long position = this.this$0.starTreeScratch.position();
                List<TermValue<?>> values = collectedValues.get(index);
                for (TermValue<?> value : values) {
                    value.writeTo((StreamOutput)this.this$0.starTreeScratch);
                    this.generateAndCollectFromStarTree(collectedValues, index + 1, owningBucketOrd, starTreeEntry, docCountMetric);
                    this.this$0.starTreeScratch.seek(position);
                }
            }
        };
    }

    @Override
    public List<DimensionFilter> getDimensionFilters() {
        return StarTreeQueryHelper.collectDimensionFilters(this.fields.stream().map(a -> new MatchAllFilter((String)a)).toList(), this.subAggregators);
    }

    @Override
    protected void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.bucketOrds, this.multiTermsValue});
    }

    private static List<Object> decode(BytesRef bytesRef) {
        List list;
        block8: {
            StreamInput input = new BytesArray(bytesRef).streamInput();
            try {
                list = input.readList(StreamInput::readGenericValue);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ExceptionsHelper.convertToRuntime((Exception)e);
                }
            }
            input.close();
        }
        return list;
    }

    private boolean subAggsNeedScore() {
        for (Aggregator subAgg : this.subAggregators) {
            if (!subAgg.scoreMode().needsScores()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean shouldDefer(Aggregator aggregator) {
        return this.collectMode == Aggregator.SubAggCollectionMode.BREADTH_FIRST && !this.aggsUsedForSorting.contains(aggregator);
    }

    private void collectZeroDocEntriesIfNeeded(long owningBucketOrd) throws IOException {
        if (this.bucketCountThresholds.getMinDocCount() != 0L) {
            return;
        }
        if (InternalOrder.isCountDesc(this.order) && this.bucketOrds.bucketsInOrd(owningBucketOrd) >= (long)this.bucketCountThresholds.getRequiredSize()) {
            return;
        }
        for (LeafReaderContext ctx : this.context.searcher().getTopReaderContext().leaves()) {
            MultiTermsValuesSourceCollector collector = this.multiTermsValue.getValues(ctx, this.bucketOrds, null, null);
            for (int docId = 0; docId < ctx.reader().maxDoc(); ++docId) {
                collector.apply(docId, owningBucketOrd);
            }
        }
    }

    static class MultiTermsValuesSource
    implements Releasable {
        private final List<ValuesSource> rawValueSources;
        private final List<InternalValuesSource> valuesSources;
        private final BytesStreamOutput scratch = new BytesStreamOutput();

        public MultiTermsValuesSource(List<ValuesSource> rawValueSources, List<InternalValuesSource> valuesSources) {
            this.rawValueSources = rawValueSources;
            this.valuesSources = valuesSources;
        }

        public MultiTermsValuesSourceCollector getValues(LeafReaderContext ctx, final BytesKeyedBucketOrds bucketOrds, final BucketsAggregator aggregator, final LeafBucketCollector sub) throws IOException {
            final ArrayList<InternalValuesSourceCollector> collectors = new ArrayList<InternalValuesSourceCollector>();
            for (InternalValuesSource valuesSource : this.valuesSources) {
                collectors.add(valuesSource.apply(ctx));
            }
            final boolean collectBucketOrds = aggregator != null && sub != null;
            return new MultiTermsValuesSourceCollector(){
                final /* synthetic */ MultiTermsValuesSource this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void apply(int doc, long owningBucketOrd) throws IOException {
                    ArrayList collectedValues = new ArrayList();
                    for (InternalValuesSourceCollector collector : collectors) {
                        collectedValues.add(collector.apply(doc));
                    }
                    this.this$0.scratch.seek(0L);
                    this.this$0.scratch.writeVInt(collectors.size());
                    this.generateAndCollectCompositeKeys(collectedValues, 0, owningBucketOrd, doc);
                }

                private void generateAndCollectCompositeKeys(List<List<TermValue<?>>> collectedValues, int index, long owningBucketOrd, int doc) throws IOException {
                    if (collectedValues.size() == index) {
                        long bucketOrd = bucketOrds.add(owningBucketOrd, this.this$0.scratch.bytes().toBytesRef());
                        if (collectBucketOrds) {
                            if (bucketOrd < 0L) {
                                bucketOrd = -1L - bucketOrd;
                                aggregator.collectExistingBucket(sub, doc, bucketOrd);
                            } else {
                                aggregator.collectBucket(sub, doc, bucketOrd);
                            }
                        }
                        return;
                    }
                    long position = this.this$0.scratch.position();
                    List<TermValue<?>> values = collectedValues.get(index);
                    int numIterations = values.size();
                    for (TermValue<?> value : values) {
                        value.writeTo((StreamOutput)this.this$0.scratch);
                        this.generateAndCollectCompositeKeys(collectedValues, index + 1, owningBucketOrd, doc);
                        this.this$0.scratch.seek(position);
                    }
                }
            };
        }

        public void close() {
            this.scratch.close();
        }
    }

    @FunctionalInterface
    static interface MultiTermsValuesSourceCollector {
        public void apply(int var1, long var2) throws IOException;
    }

    static class TermValue<T>
    implements Writeable {
        private static final Writeable.Writer<BytesRef> BYTES_REF_WRITER = StreamOutput.getWriter(BytesRef.class);
        private static final Writeable.Writer<Long> LONG_WRITER = StreamOutput.getWriter(Long.class);
        private static final Writeable.Writer<BigInteger> BIG_INTEGER_WRITER = StreamOutput.getWriter(BigInteger.class);
        private static final Writeable.Writer<Double> DOUBLE_WRITER = StreamOutput.getWriter(Double.class);
        private final T value;
        private final Writeable.Writer<T> writer;

        private TermValue(T value, Writeable.Writer<T> writer) {
            this.value = value;
            this.writer = writer;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.writer.write(out, this.value);
        }

        public static TermValue<BytesRef> of(BytesRef value) {
            return new TermValue<BytesRef>(value, BYTES_REF_WRITER);
        }

        public static TermValue<Long> of(Long value) {
            return new TermValue<Long>(value, LONG_WRITER);
        }

        public static TermValue<BigInteger> of(BigInteger value) {
            return new TermValue<BigInteger>(value, BIG_INTEGER_WRITER);
        }

        public static TermValue<Double> of(Double value) {
            return new TermValue<Double>(value, DOUBLE_WRITER);
        }
    }

    static class InternalValuesSourceFactory {
        InternalValuesSourceFactory() {
        }

        static InternalValuesSource bytesValuesSource(ValuesSource valuesSource, IncludeExclude.StringFilter includeExclude) {
            return ctx -> {
                SortedBinaryDocValues values = valuesSource.bytesValues(ctx);
                return doc -> {
                    if (!values.advanceExact(doc)) {
                        return Collections.emptyList();
                    }
                    int valuesCount = values.docValueCount();
                    ArrayList<TermValue<BytesRef>> termValues = new ArrayList<TermValue<BytesRef>>(valuesCount);
                    BytesRef previous = null;
                    for (int i = 0; i < valuesCount; ++i) {
                        BytesRef bytes = values.nextValue();
                        if (includeExclude != null && !includeExclude.accept(bytes) || i > 0 && bytes.equals(previous)) continue;
                        if (valuesCount > 1) {
                            BytesRef copy = BytesRef.deepCopyOf((BytesRef)bytes);
                            termValues.add(TermValue.of(copy));
                            previous = copy;
                            continue;
                        }
                        termValues.add(TermValue.of(bytes));
                    }
                    return termValues;
                };
            };
        }

        static InternalValuesSource unsignedLongValuesSource(ValuesSource.Numeric valuesSource, IncludeExclude.LongFilter longFilter) {
            return ctx -> {
                SortedNumericDocValues values = valuesSource.longValues(ctx);
                return doc -> {
                    if (values.advanceExact(doc)) {
                        int valuesCount = values.docValueCount();
                        BigInteger previous = Numbers.MAX_UNSIGNED_LONG_VALUE;
                        ArrayList<TermValue<BigInteger>> termValues = new ArrayList<TermValue<BigInteger>>(valuesCount);
                        for (int i = 0; i < valuesCount; ++i) {
                            BigInteger val = Numbers.toUnsignedBigInteger((long)values.nextValue());
                            if (previous.compareTo(val) == 0 && i != 0) continue;
                            if (longFilter == null || longFilter.accept(NumericUtils.doubleToSortableLong((double)val.doubleValue()))) {
                                termValues.add(TermValue.of(val));
                            }
                            previous = val;
                        }
                        return termValues;
                    }
                    return Collections.emptyList();
                };
            };
        }

        static InternalValuesSource longValuesSource(ValuesSource.Numeric valuesSource, IncludeExclude.LongFilter longFilter) {
            return ctx -> {
                SortedNumericDocValues values = valuesSource.longValues(ctx);
                return doc -> {
                    if (values.advanceExact(doc)) {
                        int valuesCount = values.docValueCount();
                        long previous = Long.MAX_VALUE;
                        ArrayList<TermValue<Long>> termValues = new ArrayList<TermValue<Long>>(valuesCount);
                        for (int i = 0; i < valuesCount; ++i) {
                            long val = values.nextValue();
                            if (previous == val && i != 0) continue;
                            if (longFilter == null || longFilter.accept(val)) {
                                termValues.add(TermValue.of(val));
                            }
                            previous = val;
                        }
                        return termValues;
                    }
                    return Collections.emptyList();
                };
            };
        }

        static InternalValuesSource doubleValueSource(ValuesSource.Numeric valuesSource, IncludeExclude.LongFilter longFilter) {
            return ctx -> {
                SortedNumericDoubleValues values = valuesSource.doubleValues(ctx);
                return doc -> {
                    if (values.advanceExact(doc)) {
                        int valuesCount = values.docValueCount();
                        double previous = Double.MAX_VALUE;
                        ArrayList<TermValue<Double>> termValues = new ArrayList<TermValue<Double>>(valuesCount);
                        for (int i = 0; i < valuesCount; ++i) {
                            double val = values.nextValue();
                            if (previous == val && i != 0) continue;
                            if (longFilter == null || longFilter.accept(NumericUtils.doubleToSortableLong((double)val))) {
                                termValues.add(TermValue.of(val));
                            }
                            previous = val;
                        }
                        return termValues;
                    }
                    return Collections.emptyList();
                };
            };
        }
    }

    @FunctionalInterface
    static interface InternalValuesSourceCollector {
        public List<TermValue<?>> apply(int var1) throws IOException;
    }

    @FunctionalInterface
    static interface InternalValuesSource {
        public InternalValuesSourceCollector apply(LeafReaderContext var1) throws IOException;
    }
}

