/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.list;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.pagination.PageParams;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.cat.AbstractCatAction;
import org.opensearch.transport.client.node.NodeClient;

public abstract class AbstractListAction
extends AbstractCatAction {
    private static final int DEFAULT_PAGE_SIZE = 100;
    protected PageParams pageParams;

    @Override
    protected abstract void documentation(StringBuilder var1);

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        boolean helpWanted = request.paramAsBoolean("help", false);
        if (helpWanted || !this.isActionPaginated()) {
            return super.prepareRequest(request, client);
        }
        this.pageParams = this.validateAndGetPageParams(request);
        assert (Objects.nonNull(this.pageParams)) : "pageParams can not be null for paginated queries";
        return this.doCatRequest(request, client);
    }

    @Override
    public boolean isActionPaginated() {
        return true;
    }

    protected PageParams validateAndGetPageParams(RestRequest restRequest) {
        PageParams pageParams = restRequest.parsePaginatedQueryParams(this.defaultSort(), this.defaultPageSize());
        if (pageParams.getSize() <= 0) {
            throw new IllegalArgumentException("size must be greater than zero");
        }
        if (!"asc".equals(pageParams.getSort()) && !"desc".equals(pageParams.getSort())) {
            throw new IllegalArgumentException("value of sort can either be asc or desc");
        }
        return pageParams;
    }

    protected int defaultPageSize() {
        return 100;
    }

    protected String defaultSort() {
        return "asc";
    }
}

