/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.comparators.IntComparator;
import org.apache.lucene.util.BitSet;
import org.opensearch.common.Nullable;
import org.opensearch.common.util.BigArrays;
import org.opensearch.index.fielddata.FieldData;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexNumericFieldData;
import org.opensearch.index.fielddata.LeafNumericFieldData;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.MultiValueMode;
import org.opensearch.search.sort.BucketedSort;
import org.opensearch.search.sort.SortOrder;

public class IntValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;

    public IntValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.INT;
    }

    private NumericDocValues getNumericDocValues(LeafReaderContext context, int missingValue) throws IOException {
        SortedNumericDocValues values = ((LeafNumericFieldData)this.indexFieldData.load(context)).getLongValues();
        if (this.nested == null) {
            return FieldData.replaceMissing(this.sortMode.select(values), missingValue);
        }
        BitSet rootDocs = this.nested.rootDocs(context);
        DocIdSetIterator innerDocs = this.nested.innerDocs(context);
        int maxChildren = this.nested.getNestedSort() != null ? this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
        return this.sortMode.select(values, (long)missingValue, rootDocs, innerDocs, context.reader().maxDoc(), maxChildren);
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning pruning, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final int iMissingValue = (Integer)this.missingObject(this.missingValue, reversed);
        return new IntComparator(this, numHits, fieldname, iMissingValue, reversed, this.filterPruning(pruning)){
            final /* synthetic */ IntValuesComparatorSource this$0;
            {
                this.this$0 = this$0;
                super(numHits, field, missingValue, reverse, pruning);
            }

            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                return new IntComparator.IntLeafComparator(this, context){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super((IntComparator)this$1, context);
                    }

                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                        return this.this$1.this$0.getNumericDocValues(context, iMissingValue);
                    }
                };
            }
        };
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, final SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return new BucketedSort.ForInts(this, bigArrays, sortOrder, format, bucketSize, extra){
            private final int iMissingValue;
            final /* synthetic */ IntValuesComparatorSource this$0;
            {
                this.this$0 = this$0;
                super(bigArrays, sortOrder3, format, bucketSize, extra);
                this.iMissingValue = (Integer)this.this$0.missingObject(this.this$0.missingValue, sortOrder == SortOrder.DESC);
            }

            @Override
            public BucketedSort.ForInts.Leaf forLeaf(final LeafReaderContext ctx) throws IOException {
                return new BucketedSort.ForInts.Leaf(this, ctx){
                    private final NumericDocValues docValues;
                    private int docValue;
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        super(this$1, ctx2);
                        this.docValues = this.this$1.this$0.getNumericDocValues(ctx, this.this$1.iMissingValue);
                    }

                    @Override
                    protected boolean advanceExact(int doc) throws IOException {
                        if (this.docValues.advanceExact(doc)) {
                            this.docValue = (int)this.docValues.longValue();
                            return true;
                        }
                        return false;
                    }

                    @Override
                    protected int docValue() {
                        return this.docValue;
                    }
                };
            }
        };
    }
}

