/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.document;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.opensearch.index.document.SortedUnsignedLongDocValuesRangeQuery;
import org.opensearch.lucene.util.UnsignedLongHashSet;

public abstract class SortedUnsignedLongDocValuesSetQuery
extends Query {
    private final String field;
    private final UnsignedLongHashSet numbers;

    SortedUnsignedLongDocValuesSetQuery(String field, BigInteger[] numbers) {
        this.field = Objects.requireNonNull(field);
        Arrays.sort(numbers);
        this.numbers = new UnsignedLongHashSet(Arrays.stream(numbers).mapToLong(n -> n.longValue()).toArray());
    }

    public String toString(String field) {
        return field + ": " + this.numbers.toString();
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf((Query)this);
        }
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        if (this.numbers.size() == 0) {
            return new MatchNoDocsQuery();
        }
        return super.rewrite(indexSearcher);
    }

    public boolean equals(Object other) {
        if (!this.sameClassAs(other)) {
            return false;
        }
        SortedUnsignedLongDocValuesSetQuery that = (SortedUnsignedLongDocValuesSetQuery)((Object)other);
        return this.field.equals(that.field) && this.numbers.equals(that.numbers);
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.field, this.numbers);
    }

    abstract SortedNumericDocValues getValues(LeafReader var1, String var2) throws IOException;

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, this, boost){
            final /* synthetic */ SortedUnsignedLongDocValuesSetQuery this$0;
            {
                this.this$0 = this$0;
                super(query, score);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{this.this$0.field});
            }

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = this.this$0.getValues(context.reader(), this.this$0.field);
                if (values == null) {
                    return null;
                }
                final NumericDocValues singleton = DocValues.unwrapSingleton((SortedNumericDocValues)values);
                TwoPhaseIterator iterator = singleton != null ? new TwoPhaseIterator(this, (DocIdSetIterator)singleton){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super(approximation);
                    }

                    public boolean matches() throws IOException {
                        long value = singleton.longValue();
                        return Long.compareUnsigned(value, this.this$1.this$0.numbers.minValue) >= 0 && Long.compareUnsigned(value, this.this$1.this$0.numbers.maxValue) <= 0 && this.this$1.this$0.numbers.contains(value);
                    }

                    public float matchCost() {
                        return 5.0f;
                    }
                } : new TwoPhaseIterator(this, (DocIdSetIterator)values){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super(approximation);
                    }

                    public boolean matches() throws IOException {
                        int count = values.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            long value = values.nextValue();
                            if (Long.compareUnsigned(value, this.this$1.this$0.numbers.minValue) < 0) continue;
                            if (Long.compareUnsigned(value, this.this$1.this$0.numbers.maxValue) > 0) {
                                return false;
                            }
                            if (!this.this$1.this$0.numbers.contains(value)) continue;
                            return true;
                        }
                        return false;
                    }

                    public float matchCost() {
                        return 5.0f;
                    }
                };
                ConstantScoreScorer scorer = new ConstantScoreScorer(this.score(), scoreMode, iterator);
                return new Weight.DefaultScorerSupplier((Scorer)scorer);
            }
        };
    }

    public static Query newSlowSetQuery(String field, BigInteger ... values) {
        return new SortedUnsignedLongDocValuesSetQuery(field, values){

            @Override
            SortedNumericDocValues getValues(LeafReader reader, String field) throws IOException {
                FieldInfo info = reader.getFieldInfos().fieldInfo(field);
                if (info == null) {
                    return null;
                }
                return DocValues.getSortedNumeric((LeafReader)reader, (String)field);
            }
        };
    }

    public static Query newSlowExactQuery(String field, BigInteger value) {
        return new SortedUnsignedLongDocValuesRangeQuery(field, value, value){

            @Override
            SortedNumericDocValues getValues(LeafReader reader, String field) throws IOException {
                FieldInfo info = reader.getFieldInfos().fieldInfo(field);
                if (info == null) {
                    return null;
                }
                return DocValues.getSortedNumeric((LeafReader)reader, (String)field);
            }
        };
    }
}

