/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2.model;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.maxmind.db.MaxMindDbConstructor;
import com.maxmind.db.MaxMindDbParameter;
import com.maxmind.db.Network;
import com.maxmind.geoip2.NetworkDeserializer;
import com.maxmind.geoip2.model.AnonymousIpResponse;
import java.time.LocalDate;

public class AnonymousPlusResponse
extends AnonymousIpResponse {
    private final Integer anonymizerConfidence;
    private final LocalDate networkLastSeen;
    private final String providerName;

    public AnonymousPlusResponse(@JsonProperty(value="anonymizer_confidence") Integer anonymizerConfidence, @JacksonInject(value="ip_address") @JsonProperty(value="ip_address") String ipAddress, @JsonProperty(value="is_anonymous") Boolean isAnonymous, @JsonProperty(value="is_anonymous_vpn") Boolean isAnonymousVpn, @JsonProperty(value="is_hosting_provider") Boolean isHostingProvider, @JsonProperty(value="is_public_proxy") Boolean isPublicProxy, @JsonProperty(value="is_residential_proxy") Boolean isResidentialProxy, @JsonProperty(value="is_tor_exit_node") Boolean isTorExitNode, @JacksonInject(value="network") @JsonDeserialize(using=NetworkDeserializer.class) @JsonProperty(value="network") Network network, @JsonProperty(value="network_last_seen") LocalDate networkLastSeen, @JsonProperty(value="provider_name") String providerName) {
        super(ipAddress, isAnonymous, isAnonymousVpn, isHostingProvider, isPublicProxy, isResidentialProxy, isTorExitNode, network);
        this.anonymizerConfidence = anonymizerConfidence;
        this.networkLastSeen = networkLastSeen;
        this.providerName = providerName;
    }

    @MaxMindDbConstructor
    public AnonymousPlusResponse(@MaxMindDbParameter(name="anonymizer_confidence") Integer anonymizerConfidence, @MaxMindDbParameter(name="ip_address") String ipAddress, @MaxMindDbParameter(name="is_anonymous") Boolean isAnonymous, @MaxMindDbParameter(name="is_anonymous_vpn") Boolean isAnonymousVpn, @MaxMindDbParameter(name="is_hosting_provider") Boolean isHostingProvider, @MaxMindDbParameter(name="is_public_proxy") Boolean isPublicProxy, @MaxMindDbParameter(name="is_residential_proxy") Boolean isResidentialProxy, @MaxMindDbParameter(name="is_tor_exit_node") Boolean isTorExitNode, @MaxMindDbParameter(name="network") Network network, @MaxMindDbParameter(name="network_last_seen") String networkLastSeen, @MaxMindDbParameter(name="provider_name") String providerName) {
        this(anonymizerConfidence, ipAddress, isAnonymous, isAnonymousVpn, isHostingProvider, isPublicProxy, isResidentialProxy, isTorExitNode, network, networkLastSeen != null ? LocalDate.parse(networkLastSeen) : null, providerName);
    }

    public AnonymousPlusResponse(AnonymousPlusResponse response, String ipAddress, Network network) {
        this(response.getAnonymizerConfidence(), ipAddress, (Boolean)response.isAnonymous(), (Boolean)response.isAnonymousVpn(), (Boolean)response.isHostingProvider(), (Boolean)response.isPublicProxy(), (Boolean)response.isResidentialProxy(), (Boolean)response.isTorExitNode(), network, response.getNetworkLastSeen(), response.getProviderName());
    }

    @JsonProperty
    public Integer getAnonymizerConfidence() {
        return this.anonymizerConfidence;
    }

    @JsonProperty
    public LocalDate getNetworkLastSeen() {
        return this.networkLastSeen;
    }

    @JsonProperty
    public String getProviderName() {
        return this.providerName;
    }
}

