/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.wlm;

import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.wlm.WlmMode;

@PublicApi(since="2.18.0")
public class WorkloadManagementSettings {
    private static final Double DEFAULT_NODE_LEVEL_MEMORY_REJECTION_THRESHOLD = 0.8;
    private static final Double DEFAULT_NODE_LEVEL_MEMORY_CANCELLATION_THRESHOLD = 0.9;
    private static final Double DEFAULT_NODE_LEVEL_CPU_REJECTION_THRESHOLD = 0.8;
    private static final Double DEFAULT_NODE_LEVEL_CPU_CANCELLATION_THRESHOLD = 0.9;
    private static final Long DEFAULT_QUERYGROUP_SERVICE_RUN_INTERVAL_MILLIS = 1000L;
    public static final double NODE_LEVEL_MEMORY_CANCELLATION_THRESHOLD_MAX_VALUE = 0.95;
    public static final double NODE_LEVEL_MEMORY_REJECTION_THRESHOLD_MAX_VALUE = 0.9;
    public static final double NODE_LEVEL_CPU_CANCELLATION_THRESHOLD_MAX_VALUE = 0.95;
    public static final double NODE_LEVEL_CPU_REJECTION_THRESHOLD_MAX_VALUE = 0.9;
    public static final String DEFAULT_WLM_MODE = "monitor_only";
    private Double nodeLevelMemoryCancellationThreshold;
    private Double nodeLevelMemoryRejectionThreshold;
    private Double nodeLevelCpuCancellationThreshold;
    private Double nodeLevelCpuRejectionThreshold;
    public static final String QUERYGROUP_DURESS_STREAK_SETTING_NAME = "wlm.workload_group.duress_streak";
    private int duressStreak;
    public static final Setting<Integer> QUERYGROUP_SERVICE_DURESS_STREAK_SETTING = Setting.intSetting("wlm.workload_group.duress_streak", 3, 3, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final String QUERYGROUP_ENFORCEMENT_INTERVAL_SETTING_NAME = "wlm.workload_group.enforcement_interval";
    private TimeValue workloadGroupServiceRunInterval;
    public static final Setting<Long> QUERYGROUP_SERVICE_RUN_INTERVAL_SETTING = Setting.longSetting("wlm.workload_group.enforcement_interval", (long)DEFAULT_QUERYGROUP_SERVICE_RUN_INTERVAL_MILLIS, 1000L, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final String WLM_MODE_SETTING_NAME = "wlm.workload_group.mode";
    private volatile WlmMode wlmMode;
    public static final Setting<WlmMode> WLM_MODE_SETTING = new Setting<WlmMode>("wlm.workload_group.mode", "monitor_only", WlmMode::fromName, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final String NODE_MEMORY_REJECTION_THRESHOLD_SETTING_NAME = "wlm.workload_group.node.memory_rejection_threshold";
    public static final Setting<Double> NODE_LEVEL_MEMORY_REJECTION_THRESHOLD = Setting.doubleSetting("wlm.workload_group.node.memory_rejection_threshold", (double)DEFAULT_NODE_LEVEL_MEMORY_REJECTION_THRESHOLD, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final String NODE_CPU_REJECTION_THRESHOLD_SETTING_NAME = "wlm.workload_group.node.cpu_rejection_threshold";
    public static final Setting<Double> NODE_LEVEL_CPU_REJECTION_THRESHOLD = Setting.doubleSetting("wlm.workload_group.node.cpu_rejection_threshold", (double)DEFAULT_NODE_LEVEL_CPU_REJECTION_THRESHOLD, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final String NODE_MEMORY_CANCELLATION_THRESHOLD_SETTING_NAME = "wlm.workload_group.node.memory_cancellation_threshold";
    public static final Setting<Double> NODE_LEVEL_MEMORY_CANCELLATION_THRESHOLD = Setting.doubleSetting("wlm.workload_group.node.memory_cancellation_threshold", (double)DEFAULT_NODE_LEVEL_MEMORY_CANCELLATION_THRESHOLD, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final String NODE_CPU_CANCELLATION_THRESHOLD_SETTING_NAME = "wlm.workload_group.node.cpu_cancellation_threshold";
    public static final Setting<Double> NODE_LEVEL_CPU_CANCELLATION_THRESHOLD = Setting.doubleSetting("wlm.workload_group.node.cpu_cancellation_threshold", (double)DEFAULT_NODE_LEVEL_CPU_CANCELLATION_THRESHOLD, Setting.Property.Dynamic, Setting.Property.NodeScope);

    public WorkloadManagementSettings(Settings settings, ClusterSettings clusterSettings) {
        this.wlmMode = WLM_MODE_SETTING.get(settings);
        this.nodeLevelMemoryCancellationThreshold = NODE_LEVEL_MEMORY_CANCELLATION_THRESHOLD.get(settings);
        this.nodeLevelMemoryRejectionThreshold = NODE_LEVEL_MEMORY_REJECTION_THRESHOLD.get(settings);
        this.nodeLevelCpuCancellationThreshold = NODE_LEVEL_CPU_CANCELLATION_THRESHOLD.get(settings);
        this.nodeLevelCpuRejectionThreshold = NODE_LEVEL_CPU_REJECTION_THRESHOLD.get(settings);
        this.workloadGroupServiceRunInterval = TimeValue.timeValueMillis((long)QUERYGROUP_SERVICE_RUN_INTERVAL_SETTING.get(settings));
        this.duressStreak = QUERYGROUP_SERVICE_DURESS_STREAK_SETTING.get(settings);
        this.ensureRejectionThresholdIsLessThanCancellation(this.nodeLevelMemoryRejectionThreshold, this.nodeLevelMemoryCancellationThreshold, NODE_MEMORY_REJECTION_THRESHOLD_SETTING_NAME, NODE_MEMORY_CANCELLATION_THRESHOLD_SETTING_NAME);
        this.ensureRejectionThresholdIsLessThanCancellation(this.nodeLevelCpuRejectionThreshold, this.nodeLevelCpuCancellationThreshold, NODE_CPU_REJECTION_THRESHOLD_SETTING_NAME, NODE_CPU_CANCELLATION_THRESHOLD_SETTING_NAME);
        clusterSettings.addSettingsUpdateConsumer(NODE_LEVEL_MEMORY_CANCELLATION_THRESHOLD, this::setNodeLevelMemoryCancellationThreshold);
        clusterSettings.addSettingsUpdateConsumer(NODE_LEVEL_MEMORY_REJECTION_THRESHOLD, this::setNodeLevelMemoryRejectionThreshold);
        clusterSettings.addSettingsUpdateConsumer(NODE_LEVEL_CPU_CANCELLATION_THRESHOLD, this::setNodeLevelCpuCancellationThreshold);
        clusterSettings.addSettingsUpdateConsumer(NODE_LEVEL_CPU_REJECTION_THRESHOLD, this::setNodeLevelCpuRejectionThreshold);
        clusterSettings.addSettingsUpdateConsumer(WLM_MODE_SETTING, this::setWlmMode);
        clusterSettings.addSettingsUpdateConsumer(QUERYGROUP_SERVICE_RUN_INTERVAL_SETTING, this::setWorkloadGroupServiceRunInterval);
        clusterSettings.addSettingsUpdateConsumer(QUERYGROUP_SERVICE_DURESS_STREAK_SETTING, this::setDuressStreak);
    }

    public int getDuressStreak() {
        return this.duressStreak;
    }

    private void setDuressStreak(int duressStreak) {
        this.duressStreak = duressStreak;
    }

    private void setWorkloadGroupServiceRunInterval(long newIntervalInMillis) {
        this.workloadGroupServiceRunInterval = TimeValue.timeValueMillis((long)newIntervalInMillis);
    }

    public TimeValue getWorkloadGroupServiceRunInterval() {
        return this.workloadGroupServiceRunInterval;
    }

    private void setWlmMode(WlmMode mode) {
        this.wlmMode = mode;
    }

    public WlmMode getWlmMode() {
        return this.wlmMode;
    }

    public Double getNodeLevelMemoryCancellationThreshold() {
        return this.nodeLevelMemoryCancellationThreshold;
    }

    public void setNodeLevelMemoryCancellationThreshold(Double nodeLevelMemoryCancellationThreshold) {
        if (Double.compare(nodeLevelMemoryCancellationThreshold, 0.95) > 0) {
            throw new IllegalArgumentException("wlm.workload_group.node.memory_cancellation_threshold value cannot be greater than 0.95 as it can result in a node drop");
        }
        this.ensureRejectionThresholdIsLessThanCancellation(this.nodeLevelMemoryRejectionThreshold, nodeLevelMemoryCancellationThreshold, NODE_MEMORY_REJECTION_THRESHOLD_SETTING_NAME, NODE_MEMORY_CANCELLATION_THRESHOLD_SETTING_NAME);
        this.nodeLevelMemoryCancellationThreshold = nodeLevelMemoryCancellationThreshold;
    }

    public Double getNodeLevelCpuCancellationThreshold() {
        return this.nodeLevelCpuCancellationThreshold;
    }

    public void setNodeLevelCpuCancellationThreshold(Double nodeLevelCpuCancellationThreshold) {
        if (Double.compare(nodeLevelCpuCancellationThreshold, 0.95) > 0) {
            throw new IllegalArgumentException("wlm.workload_group.node.cpu_cancellation_threshold value cannot be greater than 0.95 as it can result in a node drop");
        }
        this.ensureRejectionThresholdIsLessThanCancellation(this.nodeLevelCpuRejectionThreshold, nodeLevelCpuCancellationThreshold, NODE_CPU_REJECTION_THRESHOLD_SETTING_NAME, NODE_CPU_CANCELLATION_THRESHOLD_SETTING_NAME);
        this.nodeLevelCpuCancellationThreshold = nodeLevelCpuCancellationThreshold;
    }

    public Double getNodeLevelMemoryRejectionThreshold() {
        return this.nodeLevelMemoryRejectionThreshold;
    }

    public void setNodeLevelMemoryRejectionThreshold(Double nodeLevelMemoryRejectionThreshold) {
        if (Double.compare(nodeLevelMemoryRejectionThreshold, 0.9) > 0) {
            throw new IllegalArgumentException("wlm.workload_group.node.memory_rejection_threshold value cannot be greater than 0.90 as it can result in a node drop");
        }
        this.ensureRejectionThresholdIsLessThanCancellation(nodeLevelMemoryRejectionThreshold, this.nodeLevelMemoryCancellationThreshold, NODE_MEMORY_REJECTION_THRESHOLD_SETTING_NAME, NODE_MEMORY_CANCELLATION_THRESHOLD_SETTING_NAME);
        this.nodeLevelMemoryRejectionThreshold = nodeLevelMemoryRejectionThreshold;
    }

    public Double getNodeLevelCpuRejectionThreshold() {
        return this.nodeLevelCpuRejectionThreshold;
    }

    public void setNodeLevelCpuRejectionThreshold(Double nodeLevelCpuRejectionThreshold) {
        if (Double.compare(nodeLevelCpuRejectionThreshold, 0.9) > 0) {
            throw new IllegalArgumentException("wlm.workload_group.node.cpu_rejection_threshold value cannot be greater than 0.90 as it can result in a node drop");
        }
        this.ensureRejectionThresholdIsLessThanCancellation(nodeLevelCpuRejectionThreshold, this.nodeLevelCpuCancellationThreshold, NODE_CPU_REJECTION_THRESHOLD_SETTING_NAME, NODE_CPU_CANCELLATION_THRESHOLD_SETTING_NAME);
        this.nodeLevelCpuRejectionThreshold = nodeLevelCpuRejectionThreshold;
    }

    private void ensureRejectionThresholdIsLessThanCancellation(Double nodeLevelRejectionThreshold, Double nodeLevelCancellationThreshold, String rejectionThresholdSettingName, String cancellationThresholdSettingName) {
        if (Double.compare(nodeLevelCancellationThreshold, nodeLevelRejectionThreshold) < 0) {
            throw new IllegalArgumentException(cancellationThresholdSettingName + " value should not be less than " + rejectionThresholdSettingName);
        }
    }
}

