/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.params;

import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.params.EcPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.EcPublicKeyParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class EcDhuPrivateParameters
implements CipherParameters {
    private EcPrivateKeyParameters staticPrivateKey;
    private EcPrivateKeyParameters ephemeralPrivateKey;
    private EcPublicKeyParameters ephemeralPublicKey;

    public EcDhuPrivateParameters(EcPrivateKeyParameters ecPrivateKeyParameters, EcPrivateKeyParameters ecPrivateKeyParameters2) {
        this(ecPrivateKeyParameters, ecPrivateKeyParameters2, new EcPublicKeyParameters(ecPrivateKeyParameters2.getParameters().getG().multiply(ecPrivateKeyParameters2.getD()), ecPrivateKeyParameters2.getParameters()));
    }

    public EcDhuPrivateParameters(EcPrivateKeyParameters ecPrivateKeyParameters, EcPrivateKeyParameters ecPrivateKeyParameters2, EcPublicKeyParameters ecPublicKeyParameters) {
        this.staticPrivateKey = ecPrivateKeyParameters;
        this.ephemeralPrivateKey = ecPrivateKeyParameters2;
        this.ephemeralPublicKey = ecPublicKeyParameters;
        if (!ecPrivateKeyParameters.getParameters().equals(ecPrivateKeyParameters2.getParameters()) || !ecPrivateKeyParameters.getParameters().equals(ecPublicKeyParameters.getParameters())) {
            throw new IllegalKeyException("Static and ephemeral keys have different domain parameters");
        }
    }

    public EcPrivateKeyParameters getStaticPrivateKey() {
        return this.staticPrivateKey;
    }

    public EcPrivateKeyParameters getEphemeralPrivateKey() {
        return this.ephemeralPrivateKey;
    }

    public EcPublicKeyParameters getEphemeralPublicKey() {
        return this.ephemeralPublicKey;
    }
}

