"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CspReportOnlyConfig = void 0;
var _config = require("./config");
var _class;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
const DEFAULT_CONFIG = Object.freeze(_config.config.schema.validate({}));

/**
 * CSP-Report-Only configuration for use in OpenSearch Dashboards.
 * @public
 */

/**
 * CSP-Report-Only configuration for use in OpenSearch Dashboards.
 * @public
 */
class CspReportOnlyConfig {
  /**
   * Returns the default CSP-Report-Only configuration when passed with no config
   * @internal
   */
  constructor(rawCspReportOnlyConfig = {}) {
    _defineProperty(this, "isEmitting", void 0);
    _defineProperty(this, "rules", void 0);
    _defineProperty(this, "cspReportOnlyHeader", void 0);
    _defineProperty(this, "reportingEndpointsHeader", void 0);
    _defineProperty(this, "endpoint", void 0);
    _defineProperty(this, "useDeprecatedReportUriOnly", void 0);
    _defineProperty(this, "endpointName", 'csp-endpoint');
    const source = {
      ...DEFAULT_CONFIG,
      ...rawCspReportOnlyConfig
    };
    this.isEmitting = source.isEmitting;
    this.rules = source.rules;
    this.useDeprecatedReportUriOnly = source.useDeprecatedReportUriOnly;
    const finalRules = source.rules.map(rule => {
      if (source.allowedFrameAncestorSources && rule.startsWith('frame-ancestors')) {
        return `${rule} ${source.allowedFrameAncestorSources.join(' ')}`;
      }
      if (source.allowedConnectSources && rule.startsWith('connect-src')) {
        return `${rule} ${source.allowedConnectSources.join(' ')}`;
      }
      if (source.allowedImgSources && rule.startsWith('img-src')) {
        return `${rule} ${source.allowedImgSources.join(' ')}`;
      }
      return rule;
    });
    let cspReportOnlyHeader = finalRules.join('; ');
    if (source.endpoint) {
      this.endpoint = source.endpoint;
      if (source.useDeprecatedReportUriOnly) {
        cspReportOnlyHeader += `; report-uri ${this.endpoint};`;
      } else {
        this.reportingEndpointsHeader = `${this.endpointName}="${this.endpoint}"`;
        cspReportOnlyHeader += `; report-uri ${this.endpoint}; report-to ${this.endpointName};`;
      }
    }
    this.cspReportOnlyHeader = cspReportOnlyHeader;
  }
}
exports.CspReportOnlyConfig = CspReportOnlyConfig;
_class = CspReportOnlyConfig;
_defineProperty(CspReportOnlyConfig, "DEFAULT", new _class());