/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ltr;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.ltr.SearchModelsResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class SearchModelsRequest
extends RequestBase
implements ToCopyableBuilder<Builder, SearchModelsRequest> {
    @Nullable
    private final Integer from;
    @Nullable
    private final String prefix;
    @Nullable
    private final Integer size;
    @Nullable
    private final String store;
    public static final Endpoint<SearchModelsRequest, SearchModelsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SearchModelsRequest, SearchModelsResponse>(request -> "GET", request -> {
        boolean _store = true;
        boolean propsSet = false;
        if (request.store() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_ltr/_model";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ltr/");
            SimpleEndpoint.pathEncode(request.store, buf);
            buf.append("/_model");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, SearchModelsResponse._DESERIALIZER);

    private SearchModelsRequest(Builder builder) {
        super(builder);
        this.from = builder.from;
        this.prefix = builder.prefix;
        this.size = builder.size;
        this.store = builder.store;
    }

    public static SearchModelsRequest of(Function<Builder, ObjectBuilder<SearchModelsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final String prefix() {
        return this.prefix;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final String store() {
        return this.store;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.from != null) {
            params.put("from", String.valueOf(this.from));
        }
        if (this.prefix != null) {
            params.put("prefix", this.prefix);
        }
        if (this.size != null) {
            params.put("size", String.valueOf(this.size));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.from);
        result = 31 * result + Objects.hashCode(this.prefix);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Objects.hashCode(this.store);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchModelsRequest other = (SearchModelsRequest)o;
        return Objects.equals(this.from, other.from) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.size, other.size) && Objects.equals(this.store, other.store);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, SearchModelsRequest> {
        @Nullable
        private Integer from;
        @Nullable
        private String prefix;
        @Nullable
        private Integer size;
        @Nullable
        private String store;

        public Builder() {
        }

        private Builder(SearchModelsRequest o) {
            super(o);
            this.from = o.from;
            this.prefix = o.prefix;
            this.size = o.size;
            this.store = o.store;
        }

        private Builder(Builder o) {
            super(o);
            this.from = o.from;
            this.prefix = o.prefix;
            this.size = o.size;
            this.store = o.store;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        @Nonnull
        public final Builder prefix(@Nullable String value) {
            this.prefix = value;
            return this;
        }

        @Nonnull
        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Nonnull
        public final Builder store(@Nullable String value) {
            this.store = value;
            return this;
        }

        @Override
        @Nonnull
        public SearchModelsRequest build() {
            this._checkSingleUse();
            return new SearchModelsRequest(this);
        }
    }
}

