/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.knn;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.knn.DeletionResult;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class DeleteModelResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, DeleteModelResponse> {
    @Nonnull
    private final String modelId;
    @Nonnull
    private final DeletionResult result;
    public static final JsonpDeserializer<DeleteModelResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DeleteModelResponse::setupDeleteModelResponseDeserializer);

    private DeleteModelResponse(Builder builder) {
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.result = ApiTypeHelper.requireNonNull(builder.result, this, "result");
    }

    public static DeleteModelResponse of(Function<Builder, ObjectBuilder<DeleteModelResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String modelId() {
        return this.modelId;
    }

    @Nonnull
    public final DeletionResult result() {
        return this.result;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("model_id");
        generator.write(this.modelId);
        generator.writeKey("result");
        this.result.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupDeleteModelResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::result, DeletionResult._DESERIALIZER, "result");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.modelId.hashCode();
        result = 31 * result + this.result.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteModelResponse other = (DeleteModelResponse)o;
        return this.modelId.equals(other.modelId) && this.result.equals(other.result);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, DeleteModelResponse> {
        private String modelId;
        private DeletionResult result;

        public Builder() {
        }

        private Builder(DeleteModelResponse o) {
            this.modelId = o.modelId;
            this.result = o.result;
        }

        private Builder(Builder o) {
            this.modelId = o.modelId;
            this.result = o.result;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        @Nonnull
        public final Builder result(DeletionResult value) {
            this.result = value;
            return this;
        }

        @Override
        @Nonnull
        public DeleteModelResponse build() {
            this._checkSingleUse();
            return new DeleteModelResponse(this);
        }
    }
}

