/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.metadata;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.cluster.AckedClusterStateUpdateTask;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ack.AckedRequest;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.core.action.ActionListener;
import org.opensearch.replication.metadata.state.ReplicationStateMetadata;

@kotlin.Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH&\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/replication/metadata/UpdateReplicationMetadata;", "T", "Lorg/opensearch/cluster/AckedClusterStateUpdateTask;", "request", "Lorg/opensearch/cluster/ack/AckedRequest;", "listener", "Lorg/opensearch/core/action/ActionListener;", "<init>", "(Lorg/opensearch/cluster/ack/AckedRequest;Lorg/opensearch/core/action/ActionListener;)V", "execute", "Lorg/opensearch/cluster/ClusterState;", "currentState", "updateMetadata", "Lorg/opensearch/replication/metadata/state/ReplicationStateMetadata;", "currentStateMetadata", "opensearch-cross-cluster-replication"})
public abstract class UpdateReplicationMetadata<T>
extends AckedClusterStateUpdateTask<T> {
    public UpdateReplicationMetadata(@NotNull AckedRequest request, @NotNull ActionListener<T> listener2) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        super(request, listener2);
    }

    @NotNull
    public ClusterState execute(@NotNull ClusterState currentState) {
        ClusterState clusterState;
        ReplicationStateMetadata newMetadata;
        ReplicationStateMetadata currentMetadata;
        Intrinsics.checkNotNullParameter((Object)currentState, (String)"currentState");
        ReplicationStateMetadata replicationStateMetadata = (ReplicationStateMetadata)currentState.metadata().custom("replication_metadata");
        if (replicationStateMetadata == null) {
            replicationStateMetadata = ReplicationStateMetadata.Companion.getEMPTY();
        }
        if (Intrinsics.areEqual((Object)(currentMetadata = replicationStateMetadata), (Object)(newMetadata = this.updateMetadata(currentMetadata)))) {
            clusterState = currentState;
        } else {
            Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentState.getMetadata()).putCustom("replication_metadata", (Metadata.Custom)newMetadata);
            ClusterState clusterState2 = new ClusterState.Builder(currentState).metadata(mdBuilder).build();
            Intrinsics.checkNotNull((Object)clusterState2);
            clusterState = clusterState2;
        }
        return clusterState;
    }

    @NotNull
    public abstract ReplicationStateMetadata updateMetadata(@NotNull ReplicationStateMetadata var1);
}

