/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.status;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.broadcast.BroadcastRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0005\u0010\fJ\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lorg/opensearch/replication/action/status/ShardInfoRequest;", "Lorg/opensearch/action/support/broadcast/BroadcastRequest;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "indexName", "", "<init>", "(Ljava/lang/String;)V", "verbose", "", "(Ljava/lang/String;Z)V", "inp", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getIndexName", "()Ljava/lang/String;", "setIndexName", "getVerbose", "()Z", "setVerbose", "(Z)V", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "indices", "", "()[Ljava/lang/String;", "indicesOptions", "Lorg/opensearch/action/support/IndicesOptions;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "opensearch-cross-cluster-replication"})
public final class ShardInfoRequest
extends BroadcastRequest<ShardInfoRequest>
implements ToXContentObject {
    @NotNull
    private String indexName;
    private boolean verbose;

    @NotNull
    public final String getIndexName() {
        return this.indexName;
    }

    public final void setIndexName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.indexName = string;
    }

    public final boolean getVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public ShardInfoRequest(@NotNull String indexName) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        super(new String[0]);
        this.indexName = indexName;
    }

    public ShardInfoRequest(@NotNull String indexName, boolean verbose) {
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        super(new String[0]);
        this.indexName = indexName;
        this.verbose = verbose;
    }

    public ShardInfoRequest(@NotNull StreamInput inp) {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        super(inp);
        String string = inp.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        this.indexName = string;
    }

    @Nullable
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = new ActionRequestValidationException();
        if (((CharSequence)this.indexName).length() == 0) {
            validationException.addValidationError("Index name must be specified to obtain replication status");
        }
        if (validationException.validationErrors().isEmpty()) {
            return null;
        }
        return validationException;
    }

    @NotNull
    public String[] indices() {
        String[] stringArray = new String[]{this.indexName};
        return stringArray;
    }

    @NotNull
    public IndicesOptions indicesOptions() {
        IndicesOptions indicesOptions = IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        Intrinsics.checkNotNullExpressionValue((Object)indicesOptions, (String)"strictSingleIndexNoExpandForbidClosed(...)");
        return indicesOptions;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        builder.field("indexName", this.indexName);
        builder.endObject();
        return builder;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super.writeTo(out);
        out.writeString(this.indexName);
    }
}

