/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Enumerator;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.exception.NonFallbackCalciteException;
import org.opensearch.sql.monitor.ResourceMonitor;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.storage.scan.BackgroundSearchScanner;

public class OpenSearchIndexEnumerator
implements Enumerator<Object> {
    private final OpenSearchClient client;
    private final BackgroundSearchScanner bgScanner;
    private final List<String> fields;
    private OpenSearchRequest request;
    private final int maxResponseSize;
    private final int maxResultWindow;
    private static final long NUMBER_OF_NEXT_CALL_TO_CHECK = 1000L;
    private final ResourceMonitor monitor;
    private Integer queryCount = 0;
    private Iterator<ExprValue> iterator;
    private ExprValue current = null;

    public OpenSearchIndexEnumerator(OpenSearchClient client, List<String> fields, int maxResponseSize, int maxResultWindow, OpenSearchRequest request, ResourceMonitor monitor) {
        if (!monitor.isHealthy()) {
            throw new NonFallbackCalciteException("insufficient resources to run the query, quit.");
        }
        this.fields = fields;
        this.request = request;
        this.maxResponseSize = maxResponseSize;
        this.maxResultWindow = maxResultWindow;
        this.monitor = monitor;
        this.client = client;
        this.bgScanner = new BackgroundSearchScanner(client);
        this.bgScanner.startScanning(request);
    }

    private Iterator<ExprValue> fetchNextBatch() {
        BackgroundSearchScanner.SearchBatchResult result = this.bgScanner.fetchNextBatch(this.request, this.maxResultWindow);
        return result.iterator();
    }

    public Object current() {
        if (this.fields.size() == 1) {
            return this.resolveForCalcite(this.current, this.fields.getFirst());
        }
        return this.fields.stream().map(field -> this.resolveForCalcite(this.current, (String)field)).toArray();
    }

    private Object resolveForCalcite(ExprValue value, String rawPath) {
        return ExprValueUtils.resolveRefPaths(value, List.of(rawPath.split("\\."))).valueForCalcite();
    }

    public boolean moveNext() {
        boolean shouldCheck;
        if (this.queryCount >= this.maxResponseSize) {
            return false;
        }
        boolean bl = shouldCheck = (long)this.queryCount.intValue() % 1000L == 0L;
        if (shouldCheck && !this.monitor.isHealthy()) {
            throw new NonFallbackCalciteException("insufficient resources to load next row, quit.");
        }
        if (this.iterator == null || !this.iterator.hasNext() && !this.bgScanner.isScanDone()) {
            this.iterator = this.fetchNextBatch();
        }
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            Integer n = this.queryCount;
            this.queryCount = this.queryCount + 1;
            return true;
        }
        return false;
    }

    public void reset() {
        this.bgScanner.reset(this.request);
        this.iterator = this.bgScanner.fetchNextBatch(this.request, this.maxResultWindow).iterator();
        this.queryCount = 0;
    }

    public void close() {
        this.iterator = Collections.emptyIterator();
        this.queryCount = 0;
        this.bgScanner.close();
        if (this.request != null) {
            this.client.forceCleanup(this.request);
            this.request = null;
        }
    }
}

