/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.window.frame;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.window.WindowDefinition;
import org.opensearch.sql.expression.window.frame.WindowFrame;
import org.opensearch.sql.storage.bindingtuple.BindingTuple;
import shaded.com.google.common.collect.PeekingIterator;

public class PeerRowsWindowFrame
implements WindowFrame {
    private final WindowDefinition windowDefinition;
    protected final List<ExprValue> peers = new ArrayList<ExprValue>();
    protected int position;
    private boolean isNewPartition = true;

    @Override
    public boolean hasNext() {
        return this.position < this.peers.size();
    }

    @Override
    public List<ExprValue> next() {
        this.isNewPartition = false;
        if (this.position++ == 0) {
            return this.peers;
        }
        return Collections.emptyList();
    }

    @Override
    public ExprValue current() {
        return this.peers.get(this.position);
    }

    @Override
    public void load(PeekingIterator<ExprValue> it) {
        if (this.hasNext()) {
            return;
        }
        this.loadAllRows(it);
    }

    protected void loadAllRows(PeekingIterator<ExprValue> it) {
        this.isNewPartition = !this.isSamePartition((ExprValue)it.peek());
        this.position = 0;
        this.peers.clear();
        while (it.hasNext()) {
            ExprValue next = (ExprValue)it.peek();
            if (this.peers.isEmpty()) {
                this.peers.add((ExprValue)it.next());
                continue;
            }
            if (!this.isSamePartition(next) || !this.isPeer(next)) break;
            this.peers.add((ExprValue)it.next());
        }
    }

    @Override
    public boolean isNewPartition() {
        return this.isNewPartition;
    }

    private boolean isPeer(ExprValue next) {
        List<Expression> sortFields = this.windowDefinition.getSortList().stream().map(Pair::getRight).collect(Collectors.toList());
        ExprValue last = this.peers.get(this.peers.size() - 1);
        return this.resolve(sortFields, last).equals(this.resolve(sortFields, next));
    }

    private boolean isSamePartition(ExprValue next) {
        if (this.peers.isEmpty()) {
            return false;
        }
        List<Expression> partitionByList = this.windowDefinition.getPartitionByList();
        ExprValue last = this.peers.get(this.peers.size() - 1);
        return this.resolve(partitionByList, last).equals(this.resolve(partitionByList, next));
    }

    private List<ExprValue> resolve(List<Expression> expressions, ExprValue row) {
        BindingTuple valueEnv = row.bindingTuples();
        return expressions.stream().map(expr -> expr.valueOf(valueEnv)).collect(Collectors.toList());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PeerRowsWindowFrame)) {
            return false;
        }
        PeerRowsWindowFrame other = (PeerRowsWindowFrame)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.position != other.position) {
            return false;
        }
        if (this.isNewPartition() != other.isNewPartition()) {
            return false;
        }
        WindowDefinition this$windowDefinition = this.windowDefinition;
        WindowDefinition other$windowDefinition = other.windowDefinition;
        if (this$windowDefinition == null ? other$windowDefinition != null : !((Object)this$windowDefinition).equals(other$windowDefinition)) {
            return false;
        }
        List<ExprValue> this$peers = this.peers;
        List<ExprValue> other$peers = other.peers;
        return !(this$peers == null ? other$peers != null : !((Object)this$peers).equals(other$peers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PeerRowsWindowFrame;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.position;
        result = result * 59 + (this.isNewPartition() ? 79 : 97);
        WindowDefinition $windowDefinition = this.windowDefinition;
        result = result * 59 + ($windowDefinition == null ? 43 : ((Object)$windowDefinition).hashCode());
        List<ExprValue> $peers = this.peers;
        result = result * 59 + ($peers == null ? 43 : ((Object)$peers).hashCode());
        return result;
    }

    @Generated
    public PeerRowsWindowFrame(WindowDefinition windowDefinition) {
        this.windowDefinition = windowDefinition;
    }
}

