/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import inet.ipaddr.IPAddress;
import lombok.Generated;
import org.opensearch.sql.data.model.AbstractExprValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.utils.IPUtils;

public class ExprIpValue
extends AbstractExprValue {
    private final IPAddress value;

    public ExprIpValue(String addressString) {
        this.value = IPUtils.toAddress(addressString);
    }

    @Override
    public String value() {
        return this.value.toCanonicalString();
    }

    @Override
    public ExprIpValue valueForCalcite() {
        return this;
    }

    @Override
    public ExprType type() {
        return ExprCoreType.IP;
    }

    @Override
    public int compare(ExprValue other) {
        return IPUtils.compare(this.value, ((ExprIpValue)other).value);
    }

    @Override
    public boolean equal(ExprValue other) {
        return this.compare(other) == 0;
    }

    public String toString() {
        return this.value();
    }

    @Override
    public IPAddress ipValue() {
        return this.value;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExprIpValue)) {
            return false;
        }
        ExprIpValue other = (ExprIpValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IPAddress this$value = this.value;
        IPAddress other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExprIpValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IPAddress $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

