/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.expression;

import java.util.List;
import lombok.Generated;
import shaded.com.google.common.collect.ImmutableList;

public enum IntervalUnit {
    UNKNOWN,
    MICROSECOND,
    MILLISECOND,
    SECOND,
    MINUTE,
    HOUR,
    DAY,
    WEEK,
    MONTH,
    QUARTER,
    YEAR,
    SECOND_MICROSECOND,
    MINUTE_MICROSECOND,
    MINUTE_SECOND,
    HOUR_MICROSECOND,
    HOUR_SECOND,
    HOUR_MINUTE,
    DAY_MICROSECOND,
    DAY_SECOND,
    DAY_MINUTE,
    DAY_HOUR,
    YEAR_MONTH;

    private static final List<IntervalUnit> INTERVAL_UNITS;

    public static IntervalUnit of(String unit) {
        return INTERVAL_UNITS.stream().filter(v -> unit.equalsIgnoreCase(v.name())).findFirst().orElse(UNKNOWN);
    }

    @Generated
    private IntervalUnit() {
    }

    static {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        INTERVAL_UNITS = builder.add((Object[])IntervalUnit.values()).build();
    }
}

