/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.search_relevance;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.search_relevance.PostQuerySetsResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class PostQuerySetsRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, PostQuerySetsRequest> {
    @Nullable
    private final String description;
    @Nullable
    private final String name;
    @Nullable
    private final Integer querySetSize;
    @Nullable
    private final String sampling;
    public static final JsonpDeserializer<PostQuerySetsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PostQuerySetsRequest::setupPostQuerySetsRequestDeserializer);
    public static final Endpoint<PostQuerySetsRequest, PostQuerySetsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PostQuerySetsRequest, PostQuerySetsResponse>(request -> "POST", request -> "/_plugins/_search_relevance/query_sets", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, PostQuerySetsResponse._DESERIALIZER);

    private PostQuerySetsRequest(Builder builder) {
        super(builder);
        this.description = builder.description;
        this.name = builder.name;
        this.querySetSize = builder.querySetSize;
        this.sampling = builder.sampling;
    }

    public static PostQuerySetsRequest of(Function<Builder, ObjectBuilder<PostQuerySetsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nullable
    public final Integer querySetSize() {
        return this.querySetSize;
    }

    @Nullable
    public final String sampling() {
        return this.sampling;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.querySetSize != null) {
            generator.writeKey("querySetSize");
            generator.write(this.querySetSize.intValue());
        }
        if (this.sampling != null) {
            generator.writeKey("sampling");
            generator.write(this.sampling);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupPostQuerySetsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::querySetSize, JsonpDeserializer.integerDeserializer(), "querySetSize");
        op.add(Builder::sampling, JsonpDeserializer.stringDeserializer(), "sampling");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Objects.hashCode(this.querySetSize);
        result = 31 * result + Objects.hashCode(this.sampling);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostQuerySetsRequest other = (PostQuerySetsRequest)o;
        return Objects.equals(this.description, other.description) && Objects.equals(this.name, other.name) && Objects.equals(this.querySetSize, other.querySetSize) && Objects.equals(this.sampling, other.sampling);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, PostQuerySetsRequest> {
        @Nullable
        private String description;
        @Nullable
        private String name;
        @Nullable
        private Integer querySetSize;
        @Nullable
        private String sampling;

        public Builder() {
        }

        private Builder(PostQuerySetsRequest o) {
            super(o);
            this.description = o.description;
            this.name = o.name;
            this.querySetSize = o.querySetSize;
            this.sampling = o.sampling;
        }

        private Builder(Builder o) {
            super(o);
            this.description = o.description;
            this.name = o.name;
            this.querySetSize = o.querySetSize;
            this.sampling = o.sampling;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder querySetSize(@Nullable Integer value) {
            this.querySetSize = value;
            return this;
        }

        @Nonnull
        public final Builder sampling(@Nullable String value) {
            this.sampling = value;
            return this;
        }

        @Override
        @Nonnull
        public PostQuerySetsRequest build() {
            this._checkSingleUse();
            return new PostQuerySetsRequest(this);
        }
    }
}

