/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.rest;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.datasources.exceptions.DataSourceClientException;
import org.opensearch.sql.datasources.exceptions.ErrorMessage;
import org.opensearch.sql.datasources.utils.Scheduler;
import org.opensearch.sql.legacy.metrics.MetricName;
import org.opensearch.sql.legacy.utils.MetricUtils;
import org.opensearch.sql.opensearch.setting.OpenSearchSettings;
import org.opensearch.sql.opensearch.util.RestRequestUtil;
import org.opensearch.sql.spark.asyncquery.exceptions.AsyncQueryNotFoundException;
import org.opensearch.sql.spark.leasemanager.ConcurrencyLimitExceededException;
import org.opensearch.sql.spark.rest.model.CreateAsyncQueryRequest;
import org.opensearch.sql.spark.transport.TransportCancelAsyncQueryRequestAction;
import org.opensearch.sql.spark.transport.TransportCreateAsyncQueryRequestAction;
import org.opensearch.sql.spark.transport.TransportGetAsyncQueryResultAction;
import org.opensearch.sql.spark.transport.format.CreateAsyncQueryRequestConverter;
import org.opensearch.sql.spark.transport.model.CancelAsyncQueryActionRequest;
import org.opensearch.sql.spark.transport.model.CancelAsyncQueryActionResponse;
import org.opensearch.sql.spark.transport.model.CreateAsyncQueryActionRequest;
import org.opensearch.sql.spark.transport.model.CreateAsyncQueryActionResponse;
import org.opensearch.sql.spark.transport.model.GetAsyncQueryResultActionRequest;
import org.opensearch.sql.spark.transport.model.GetAsyncQueryResultActionResponse;
import org.opensearch.transport.client.node.NodeClient;
import shaded.com.google.common.collect.ImmutableList;

public class RestAsyncQueryManagementAction
extends BaseRestHandler {
    public static final String ASYNC_QUERY_ACTIONS = "async_query_actions";
    public static final String BASE_ASYNC_QUERY_ACTION_URL = "/_plugins/_async_query";
    private static final Logger LOG = LogManager.getLogger(RestAsyncQueryManagementAction.class);
    private final OpenSearchSettings settings;

    public String getName() {
        return ASYNC_QUERY_ACTIONS;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, BASE_ASYNC_QUERY_ACTION_URL), (Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{%s}", BASE_ASYNC_QUERY_ACTION_URL, "queryId")), (Object)new RestHandler.Route(RestRequest.Method.DELETE, String.format(Locale.ROOT, "%s/{%s}", BASE_ASYNC_QUERY_ACTION_URL, "queryId")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient nodeClient) throws IOException {
        if (!this.dataSourcesEnabled()) {
            return this.dataSourcesDisabledError(restRequest);
        }
        switch (restRequest.method()) {
            case POST: {
                return this.executePostRequest(restRequest, nodeClient);
            }
            case GET: {
                return this.executeGetAsyncQueryResultRequest(restRequest, nodeClient);
            }
            case DELETE: {
                return this.executeDeleteRequest(restRequest, nodeClient);
            }
        }
        return restChannel -> restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.METHOD_NOT_ALLOWED, String.valueOf(restRequest.method())));
    }

    private BaseRestHandler.RestChannelConsumer executePostRequest(final RestRequest restRequest, NodeClient nodeClient) {
        return restChannel -> {
            try {
                MetricUtils.incrementNumericalMetric(MetricName.ASYNC_QUERY_CREATE_API_REQUEST_COUNT);
                CreateAsyncQueryRequest submitJobRequest = CreateAsyncQueryRequestConverter.fromXContentParser(restRequest.contentParser());
                Scheduler.schedule(nodeClient, () -> nodeClient.execute(TransportCreateAsyncQueryRequestAction.ACTION_TYPE, (ActionRequest)new CreateAsyncQueryActionRequest(submitJobRequest), (ActionListener)new ActionListener<CreateAsyncQueryActionResponse>(this){
                    final /* synthetic */ RestAsyncQueryManagementAction this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void onResponse(CreateAsyncQueryActionResponse createAsyncQueryActionResponse) {
                        restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.CREATED, "application/json; charset=UTF-8", createAsyncQueryActionResponse.getResult()));
                    }

                    public void onFailure(Exception e) {
                        this.this$0.handleException(e, restChannel, restRequest.method());
                    }
                }));
            }
            catch (Exception e) {
                this.handleException(e, (RestChannel)restChannel, restRequest.method());
            }
        };
    }

    private BaseRestHandler.RestChannelConsumer executeGetAsyncQueryResultRequest(final RestRequest restRequest, NodeClient nodeClient) {
        MetricUtils.incrementNumericalMetric(MetricName.ASYNC_QUERY_GET_API_REQUEST_COUNT);
        String queryId = restRequest.param("queryId");
        return restChannel -> Scheduler.schedule(nodeClient, () -> nodeClient.execute(TransportGetAsyncQueryResultAction.ACTION_TYPE, (ActionRequest)new GetAsyncQueryResultActionRequest(queryId), (ActionListener)new ActionListener<GetAsyncQueryResultActionResponse>(this){
            final /* synthetic */ RestAsyncQueryManagementAction this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(GetAsyncQueryResultActionResponse getAsyncQueryResultActionResponse) {
                restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "application/json; charset=UTF-8", getAsyncQueryResultActionResponse.getResult()));
            }

            public void onFailure(Exception e) {
                this.this$0.handleException(e, restChannel, restRequest.method());
            }
        }));
    }

    private void handleException(Exception e, RestChannel restChannel, RestRequest.Method requestMethod) {
        if (e instanceof OpenSearchException) {
            OpenSearchException exception = (OpenSearchException)((Object)e);
            this.reportError(restChannel, (Exception)((Object)exception), exception.status());
            this.addCustomerErrorMetric(requestMethod);
        } else if (e instanceof ConcurrencyLimitExceededException) {
            LOG.error("Too many request", (Throwable)e);
            this.reportError(restChannel, e, RestStatus.TOO_MANY_REQUESTS);
            this.addCustomerErrorMetric(requestMethod);
        } else {
            LOG.error("Error happened during request handling", (Throwable)e);
            if (RestAsyncQueryManagementAction.isClientError(e)) {
                this.reportError(restChannel, e, RestStatus.BAD_REQUEST);
                this.addCustomerErrorMetric(requestMethod);
            } else {
                this.reportError(restChannel, e, RestStatus.INTERNAL_SERVER_ERROR);
                this.addSystemErrorMetric(requestMethod);
            }
        }
    }

    private BaseRestHandler.RestChannelConsumer executeDeleteRequest(final RestRequest restRequest, NodeClient nodeClient) {
        MetricUtils.incrementNumericalMetric(MetricName.ASYNC_QUERY_CANCEL_API_REQUEST_COUNT);
        String queryId = restRequest.param("queryId");
        return restChannel -> Scheduler.schedule(nodeClient, () -> nodeClient.execute(TransportCancelAsyncQueryRequestAction.ACTION_TYPE, (ActionRequest)new CancelAsyncQueryActionRequest(queryId), (ActionListener)new ActionListener<CancelAsyncQueryActionResponse>(this){
            final /* synthetic */ RestAsyncQueryManagementAction this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(CancelAsyncQueryActionResponse cancelAsyncQueryActionResponse) {
                restChannel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.NO_CONTENT, "application/json; charset=UTF-8", cancelAsyncQueryActionResponse.getResult()));
            }

            public void onFailure(Exception e) {
                this.this$0.handleException(e, restChannel, restRequest.method());
            }
        }));
    }

    private void reportError(RestChannel channel, Exception e, RestStatus status) {
        channel.sendResponse((RestResponse)new BytesRestResponse(status, new ErrorMessage(e, status.getStatus()).toString()));
    }

    private static boolean isClientError(Exception e) {
        return e instanceof IllegalArgumentException || e instanceof IllegalStateException || e instanceof DataSourceClientException || e instanceof AsyncQueryNotFoundException || e instanceof IllegalAccessException;
    }

    private void addSystemErrorMetric(RestRequest.Method requestMethod) {
        switch (requestMethod) {
            case POST: {
                MetricUtils.incrementNumericalMetric(MetricName.ASYNC_QUERY_CREATE_API_FAILED_REQ_COUNT_SYS);
                break;
            }
            case GET: {
                MetricUtils.incrementNumericalMetric(MetricName.ASYNC_QUERY_GET_API_FAILED_REQ_COUNT_SYS);
                break;
            }
            case DELETE: {
                MetricUtils.incrementNumericalMetric(MetricName.ASYNC_QUERY_CANCEL_API_FAILED_REQ_COUNT_SYS);
            }
        }
    }

    private void addCustomerErrorMetric(RestRequest.Method requestMethod) {
        switch (requestMethod) {
            case POST: {
                MetricUtils.incrementNumericalMetric(MetricName.ASYNC_QUERY_CREATE_API_FAILED_REQ_COUNT_CUS);
                break;
            }
            case GET: {
                MetricUtils.incrementNumericalMetric(MetricName.ASYNC_QUERY_GET_API_FAILED_REQ_COUNT_CUS);
                break;
            }
            case DELETE: {
                MetricUtils.incrementNumericalMetric(MetricName.ASYNC_QUERY_CANCEL_API_FAILED_REQ_COUNT_CUS);
            }
        }
    }

    private boolean dataSourcesEnabled() {
        return (Boolean)this.settings.getSettingValue(Settings.Key.DATASOURCES_ENABLED);
    }

    private BaseRestHandler.RestChannelConsumer dataSourcesDisabledError(RestRequest request) {
        RestRequestUtil.consumeAllRequestParameters(request);
        return channel -> this.reportError((RestChannel)channel, new IllegalAccessException(String.format("%s setting is false", Settings.Key.DATASOURCES_ENABLED.getKeyValue())), RestStatus.BAD_REQUEST);
    }

    @Generated
    public RestAsyncQueryManagementAction(OpenSearchSettings settings) {
        this.settings = settings;
    }
}

