/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.binning;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class SpanBucketFunction
extends ImplementorUDF {
    public SpanBucketFunction() {
        super(new SpanBucketImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.VARCHAR_2000;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.NUMERIC_NUMERIC;
    }

    public static class SpanBucketImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            Expression fieldValue = translatedOperands.get(0);
            Expression spanValue = translatedOperands.get(1);
            return Expressions.call(SpanBucketImplementor.class, (String)"calculateSpanBucket", (Expression[])new Expression[]{Expressions.convert_((Expression)Expressions.box((Expression)fieldValue), Number.class), Expressions.convert_((Expression)Expressions.box((Expression)spanValue), Number.class)});
        }

        public static String calculateSpanBucket(Number fieldValue, Number spanParam) {
            if (fieldValue == null || spanParam == null) {
                return null;
            }
            double value = fieldValue.doubleValue();
            double span = spanParam.doubleValue();
            if (span <= 0.0) {
                return null;
            }
            double binStart = Math.floor(value / span) * span;
            double binEnd = binStart + span;
            return SpanBucketImplementor.formatRange(binStart, binEnd, span);
        }

        private static String formatRange(double binStart, double binEnd, double span) {
            if (SpanBucketImplementor.isIntegerSpan(span) && SpanBucketImplementor.isIntegerValue(binStart) && SpanBucketImplementor.isIntegerValue(binEnd)) {
                return String.format("%d-%d", (long)binStart, (long)binEnd);
            }
            return SpanBucketImplementor.formatFloatingPointRange(binStart, binEnd, span);
        }

        private static boolean isIntegerSpan(double span) {
            return span == Math.floor(span) && !Double.isInfinite(span);
        }

        private static boolean isIntegerValue(double value) {
            return Math.abs(value - (double)Math.round(value)) < 1.0E-10;
        }

        private static String formatFloatingPointRange(double binStart, double binEnd, double span) {
            int decimalPlaces = SpanBucketImplementor.getAppropriateDecimalPlaces(span);
            String format = String.format("%%.%df-%%.%df", decimalPlaces, decimalPlaces);
            return String.format(format, binStart, binEnd);
        }

        private static int getAppropriateDecimalPlaces(double span) {
            if (span >= 1.0) {
                return 1;
            }
            if (span >= 0.1) {
                return 2;
            }
            if (span >= 0.01) {
                return 3;
            }
            return 4;
        }
    }
}

