/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.datasource.query;

import java.util.List;
import java.util.Optional;
import org.opensearch.common.inject.Inject;
import org.opensearch.sql.datasource.client.DataSourceClient;
import org.opensearch.sql.datasource.query.QueryHandler;

public class QueryHandlerRegistry {
    private final List<QueryHandler<?>> handlers;

    @Inject
    public QueryHandlerRegistry(List<QueryHandler<?>> handlers) {
        this.handlers = handlers;
    }

    public <T extends DataSourceClient> Optional<QueryHandler<T>> getQueryHandler(T client) {
        return this.handlers.stream().filter(handler -> {
            try {
                Class handlerClientClass = handler.getClientClass();
                return handlerClientClass.isInstance(client) && handler.canHandle(client);
            }
            catch (ClassCastException e) {
                return false;
            }
        }).map(handler -> handler).findFirst();
    }
}

