/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.identity.Subject;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.FilterClient;

public class PluginClient
extends FilterClient {
    private static final Logger logger = LogManager.getLogger(PluginClient.class);
    private Subject subject;

    public PluginClient(Client client) {
        super(client);
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        if (this.subject == null) {
            throw new IllegalStateException("PluginClient is not initialized.");
        }
        try (ThreadContext.StoredContext ctx = this.threadPool().getThreadContext().stashContext();){
            this.subject.runAs(() -> {
                logger.info("Running transport action with subject: {}", (Object)this.subject.getPrincipal().getName());
                super.doExecute(action, request, ActionListener.runBefore((ActionListener)listener, () -> ((ThreadContext.StoredContext)ctx).restore()));
            });
        }
        catch (Exception e) {
            throw ExceptionsHelper.convertToRuntime((Exception)e);
        }
    }
}

