/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.common.WorkflowResources;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.model.ProvisioningProgress;
import org.opensearch.flowframework.model.ResourceCreated;
import org.opensearch.flowframework.model.State;
import org.opensearch.flowframework.transport.GetWorkflowStateAction;
import org.opensearch.flowframework.transport.GetWorkflowStateRequest;
import org.opensearch.flowframework.transport.WorkflowRequest;
import org.opensearch.flowframework.transport.WorkflowResponse;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.util.TenantAwareHelper;
import org.opensearch.flowframework.workflow.ProcessNode;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.flowframework.workflow.WorkflowStepFactory;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class DeprovisionWorkflowTransportAction
extends HandledTransportAction<WorkflowRequest, WorkflowResponse> {
    private final Logger logger = LogManager.getLogger(DeprovisionWorkflowTransportAction.class);
    private final ThreadPool threadPool;
    private final Client client;
    private final SdkClient sdkClient;
    private final WorkflowStepFactory workflowStepFactory;
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    private final FlowFrameworkSettings flowFrameworkSettings;
    private volatile Boolean filterByEnabled;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public DeprovisionWorkflowTransportAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, Client client, SdkClient sdkClient, WorkflowStepFactory workflowStepFactory, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, FlowFrameworkSettings flowFrameworkSettings, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Settings settings) {
        super("cluster:admin/opensearch/flow_framework/workflow/deprovision", transportService, actionFilters, WorkflowRequest::new);
        this.threadPool = threadPool;
        this.client = client;
        this.sdkClient = sdkClient;
        this.workflowStepFactory = workflowStepFactory;
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
        this.flowFrameworkSettings = flowFrameworkSettings;
        this.filterByEnabled = (Boolean)FlowFrameworkSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(FlowFrameworkSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, WorkflowRequest request, ActionListener<WorkflowResponse> workflowListener) {
        String tenantId;
        String string = tenantId = request.getTemplate() == null ? null : request.getTemplate().getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.flowFrameworkSettings.isMultiTenancyEnabled(), tenantId, workflowListener)) {
            return;
        }
        if (!TenantAwareHelper.tryAcquireDeprovision(this.flowFrameworkSettings.getMaxActiveDeprovisionsPerTenant(), tenantId, workflowListener)) {
            return;
        }
        ActionListener<WorkflowResponse> listener = TenantAwareHelper.releaseDeprovisionListener(tenantId, workflowListener);
        String workflowId = request.getWorkflowId();
        User user = ParseUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ParseUtils.verifyResourceAccessAndProcessRequest("workflow", () -> this.executeDeprovisionRequest(request, tenantId, listener, context, user), () -> ParseUtils.resolveUserAndExecute(user, workflowId, tenantId, this.filterByEnabled, true, this.flowFrameworkSettings.isMultiTenancyEnabled(), (ActionListener<? extends ActionResponse>)listener, () -> this.executeDeprovisionRequest(request, tenantId, listener, context, user), this.client, this.sdkClient, this.clusterService, this.xContentRegistry));
        }
        catch (Exception e) {
            String errorMessage = "Failed to retrieve template from global context.";
            this.logger.error(errorMessage, (Throwable)e);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)e))));
        }
    }

    private void executeDeprovisionRequest(WorkflowRequest request, String tenantId, ActionListener<WorkflowResponse> listener, ThreadContext.StoredContext context, User user) {
        String workflowId = request.getWorkflowId();
        String allowDelete = request.getParams().get("allow_delete");
        GetWorkflowStateRequest getStateRequest = new GetWorkflowStateRequest(workflowId, true, tenantId);
        this.logger.info("Querying state for workflow: {}", (Object)workflowId);
        this.client.execute((ActionType)GetWorkflowStateAction.INSTANCE, (ActionRequest)getStateRequest, ActionListener.wrap(response -> {
            context.restore();
            Set deleteAllowedResources = Strings.tokenizeByCommaToSet((String)allowDelete);
            this.threadPool.executor("opensearch_deprovision_workflow").execute(() -> this.executeDeprovisionSequence(workflowId, tenantId, response.getWorkflowState().resourcesCreated(), response.getWorkflowState().getAllSharedPrincipals(), deleteAllowedResources, listener, user));
        }, exception -> {
            String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to get workflow state for workflow {}", (Object)workflowId).getFormattedMessage();
            this.logger.error(errorMessage, (Throwable)exception);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, ExceptionsHelper.status((Throwable)exception))));
        }));
    }

    private void executeDeprovisionSequence(String workflowId, String tenantId, List<ResourceCreated> resourcesCreated, List<String> allSharedPrincipals, Set<String> deleteAllowedResources, ActionListener<WorkflowResponse> listener, User user) {
        ArrayList<ResourceCreated> deleteNotAllowed = new ArrayList<ResourceCreated>();
        List<ProcessNode> deprovisionProcessSequence = new ArrayList<ProcessNode>();
        for (ResourceCreated resource : resourcesCreated) {
            String workflowStepId = resource.workflowStepId();
            String stepName = resource.workflowStepName();
            WorkflowStep deprovisionStep = this.workflowStepFactory.createStep(WorkflowResources.getDeprovisionStepByWorkflowStep(stepName));
            if (deprovisionStep.allowDeleteRequired() && !deleteAllowedResources.contains(resource.resourceId())) {
                deleteNotAllowed.add(resource);
                continue;
            }
            String deprovisionStepId = "(deprovision_" + stepName + ") " + workflowStepId;
            deprovisionProcessSequence.add(new ProcessNode(deprovisionStepId, deprovisionStep, Collections.emptyMap(), Collections.emptyMap(), new WorkflowData(Map.of(WorkflowResources.getResourceByWorkflowStep(stepName), resource.resourceId()), workflowId, deprovisionStepId), Collections.emptyList(), this.threadPool, "opensearch_deprovision_workflow", this.flowFrameworkSettings.getRequestTimeout(), tenantId));
        }
        Collections.reverse(deprovisionProcessSequence);
        this.logger.info("Deprovisioning steps: {}", (Object)deprovisionProcessSequence.stream().map(ProcessNode::id).collect(Collectors.joining(", ")));
        int resourceCount = deprovisionProcessSequence.size();
        while (resourceCount > 0) {
            Iterator iter = deprovisionProcessSequence.iterator();
            do {
                ProcessNode deprovisionNode = (ProcessNode)iter.next();
                ResourceCreated resource = DeprovisionWorkflowTransportAction.getResourceFromDeprovisionNode(deprovisionNode, resourcesCreated);
                String resourceNameAndId = DeprovisionWorkflowTransportAction.getResourceNameAndId(resource);
                PlainActionFuture<WorkflowData> deprovisionFuture = deprovisionNode.execute();
                PlainActionFuture stateUpdateFuture = PlainActionFuture.newFuture();
                try {
                    deprovisionFuture.get();
                    this.logger.info("Successful {} for {}", (Object)deprovisionNode.id(), (Object)resourceNameAndId);
                    this.flowFrameworkIndicesHandler.deleteResourceFromStateIndex(workflowId, tenantId, resource, (ActionListener<WorkflowData>)stateUpdateFuture);
                    try {
                        stateUpdateFuture.actionGet(1L, TimeUnit.SECONDS);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    iter.remove();
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Throwable t) {
                    if (t.getCause() instanceof OpenSearchStatusException && ((OpenSearchStatusException)t.getCause()).status() == RestStatus.NOT_FOUND) {
                        this.logger.info("Successful (not found) {} for {}", (Object)deprovisionNode.id(), (Object)resourceNameAndId);
                        iter.remove();
                        continue;
                    }
                    this.logger.info("Failed {} for {}", (Object)deprovisionNode.id(), (Object)resourceNameAndId);
                }
            } while (iter.hasNext());
            if (deprovisionProcessSequence.size() >= resourceCount) break;
            resourceCount = deprovisionProcessSequence.size();
            deprovisionProcessSequence = deprovisionProcessSequence.stream().map(pn -> new ProcessNode(pn.id(), this.workflowStepFactory.createStep(pn.workflowStep().getName()), pn.previousNodeInputs(), pn.params(), pn.input(), pn.predecessors(), this.threadPool, "opensearch_deprovision_workflow", pn.nodeTimeout(), tenantId)).collect(Collectors.toList());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        List<ResourceCreated> remainingResources = deprovisionProcessSequence.stream().map(pn -> DeprovisionWorkflowTransportAction.getResourceFromDeprovisionNode(pn, resourcesCreated)).collect(Collectors.toList());
        this.logger.info("Resources remaining: {}.", remainingResources);
        if (!deleteNotAllowed.isEmpty()) {
            this.logger.info("Resources requiring allow_delete: {}.", deleteNotAllowed);
        }
        this.updateWorkflowState(workflowId, tenantId, remainingResources, allSharedPrincipals, deleteNotAllowed, listener, user);
    }

    private void updateWorkflowState(String workflowId, String tenantId, List<ResourceCreated> remainingResources, List<String> allSharedPrincipals, List<ResourceCreated> deleteNotAllowed, ActionListener<WorkflowResponse> listener, User user) {
        if (remainingResources.isEmpty() && deleteNotAllowed.isEmpty()) {
            this.flowFrameworkIndicesHandler.doesTemplateExist(workflowId, tenantId, templateExists -> {
                if (Boolean.TRUE.equals(templateExists)) {
                    this.flowFrameworkIndicesHandler.putInitialStateToWorkflowState(workflowId, tenantId, user, allSharedPrincipals, (ActionListener<IndexResponse>)ActionListener.wrap(indexResponse -> {
                        this.logger.info("Reset workflow {} state to NOT_STARTED", (Object)workflowId);
                        listener.onResponse((Object)new WorkflowResponse(workflowId));
                    }, exception -> {
                        this.logger.error("Failed to reset to initial workflow state for {}", (Object)workflowId, exception);
                        listener.onFailure((Exception)((Object)new FlowFrameworkException("Failed to reset workflow state", ExceptionsHelper.status((Throwable)exception))));
                    }));
                } else {
                    this.flowFrameworkIndicesHandler.deleteFlowFrameworkSystemIndexDoc(workflowId, tenantId, (ActionListener<DeleteResponse>)ActionListener.wrap(deleteResponse -> {
                        this.logger.info("Deleted workflow {} state", (Object)workflowId);
                        listener.onResponse((Object)new WorkflowResponse(workflowId));
                    }, exception -> {
                        this.logger.error("Failed to delete workflow state for {}", (Object)workflowId, exception);
                        listener.onFailure((Exception)((Object)new FlowFrameworkException("Failed to reset workflow state", ExceptionsHelper.status((Throwable)exception))));
                    }));
                }
            }, listener);
        } else {
            ArrayList<ResourceCreated> stateIndexResources = new ArrayList<ResourceCreated>(remainingResources);
            stateIndexResources.addAll(deleteNotAllowed);
            this.flowFrameworkIndicesHandler.updateFlowFrameworkSystemIndexDoc(workflowId, tenantId, Map.ofEntries(Map.entry("state", State.COMPLETED), Map.entry("provisioning_progress", ProvisioningProgress.DONE), Map.entry("provision_end_time", Instant.now().toEpochMilli()), Map.entry("resources_created", stateIndexResources)), (ActionListener<UpdateResponse>)ActionListener.wrap(updateResponse -> this.logger.info("updated workflow {} state to COMPLETED", (Object)workflowId), exception -> this.logger.error("Failed to update workflow {} state", (Object)workflowId, exception)));
            StringBuilder message = new StringBuilder();
            DeprovisionWorkflowTransportAction.appendResourceInfo(message, "Failed to deprovision some resources: ", remainingResources);
            DeprovisionWorkflowTransportAction.appendResourceInfo(message, "These resources require the allow_delete parameter to deprovision: ", deleteNotAllowed);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(message.toString(), remainingResources.isEmpty() ? RestStatus.FORBIDDEN : RestStatus.ACCEPTED)));
        }
    }

    private static void appendResourceInfo(StringBuilder message, String prefix, List<ResourceCreated> resources) {
        if (!resources.isEmpty()) {
            if (message.length() > 0) {
                message.append(" ");
            }
            message.append(prefix).append(resources.stream().map(DeprovisionWorkflowTransportAction::getResourceNameAndId).filter(Objects::nonNull).distinct().collect(Collectors.joining(", ", "[", "]"))).append(".");
        }
    }

    private static ResourceCreated getResourceFromDeprovisionNode(ProcessNode deprovisionNode, List<ResourceCreated> resourcesCreated) {
        return resourcesCreated.stream().filter(r -> deprovisionNode.id().equals("(deprovision_" + r.workflowStepName() + ") " + r.workflowStepId())).findFirst().orElse(null);
    }

    private static String getResourceNameAndId(ResourceCreated resource) {
        if (resource == null) {
            return null;
        }
        return WorkflowResources.getResourceByWorkflowStep(resource.workflowStepName()) + " " + resource.resourceId();
    }
}

