/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config.property;

import com.oracle.labs.mlrg.olcut.config.PropertyException;
import com.oracle.labs.mlrg.olcut.config.property.GlobalProperties;
import com.oracle.labs.mlrg.olcut.config.property.GlobalProperty;
import com.oracle.labs.mlrg.olcut.config.property.LazyGlobalProperty;
import com.oracle.labs.mlrg.olcut.util.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;

public class ImmutableGlobalProperties
implements Iterable<Map.Entry<String, GlobalProperty>> {
    public static final String HOSTNAME = "gp.hostName";
    private static final Map<String, GlobalProperty> distinguished = new HashMap<String, GlobalProperty>();
    protected final HashMap<String, GlobalProperty> map;

    public ImmutableGlobalProperties() {
        this.map = new HashMap();
    }

    public ImmutableGlobalProperties(GlobalProperties globalProperties) {
        this.map = new HashMap();
        for (String key : globalProperties.map.keySet()) {
            this.map.put(key, new GlobalProperty(globalProperties.get(key)));
        }
    }

    private ImmutableGlobalProperties(HashMap<String, GlobalProperty> map) {
        this.map = map;
    }

    public GlobalProperty get(String propertyName) {
        GlobalProperty gp = this.map.get(propertyName);
        if (gp == null) {
            gp = distinguished.get(propertyName);
        }
        return gp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableGlobalProperties)) {
            return false;
        }
        ImmutableGlobalProperties entries = (ImmutableGlobalProperties)o;
        return this.map.equals(entries.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public String replaceGlobalProperties(String instanceName, String propName, String val) {
        Matcher m = GlobalProperty.globalSymbolPattern.matcher(val);
        boolean matched = false;
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String replace;
            matched = true;
            GlobalProperty prop = this.get(m.group(1));
            String string = replace = prop == null ? null : prop.getValue();
            if (replace == null) {
                throw new PropertyException(instanceName, propName, "Unknown global property:  " + m.group(0));
            }
            m.appendReplacement(sb, Matcher.quoteReplacement(replace));
        }
        m.appendTail(sb);
        if (matched) {
            return this.replaceGlobalProperties(instanceName, propName, sb.toString());
        }
        return sb.toString();
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public ImmutableGlobalProperties getImmutableProperties() {
        return new ImmutableGlobalProperties(this.map);
    }

    @Override
    public Iterator<Map.Entry<String, GlobalProperty>> iterator() {
        return this.map.entrySet().iterator();
    }

    static {
        distinguished.put(HOSTNAME, new LazyGlobalProperty(Util::getHostName));
    }
}

